"""
    Cisco Nexus Cloud API

    Cisco Nexus Cloud API is a programmatic interface that uses the REST architecture to provide access to the Nexus Cloud functionality.  # noqa: E501

    The version of the OpenAPI document: 1.0.9
    Contact: nexuscloud@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from nexuscloud_client.api_client import ApiClient, Endpoint as _Endpoint
from nexuscloud_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from nexuscloud_client.model.nexus_insights_api_v1_microburst_queues_get200_response import NexusInsightsApiV1MicroburstQueuesGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_microburst_status_get200_response import NexusInsightsApiV1MicroburstStatusGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_microburst_summary_get200_response import NexusInsightsApiV1MicroburstSummaryGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_microburst_top_bursts_get200_response import NexusInsightsApiV1MicroburstTopBurstsGet200Response


class MicroburstApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.nexus_insights_api_v1_microburst_queues_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1MicroburstQueuesGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/microburst/queues',
                'operation_id': 'nexus_insights_api_v1_microburst_queues_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                    'site_name',
                    'node_name',
                    'interface_name',
                ],
                'required': [
                    'site_group_name',
                    'site_name',
                    'node_name',
                    'interface_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'node_name':
                        (str,),
                    'interface_name':
                        (str,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'node_name': 'nodeName',
                    'interface_name': 'interfaceName',
                },
                'location_map': {
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'node_name': 'query',
                    'interface_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_microburst_status_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1MicroburstStatusGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/microburst/status',
                'operation_id': 'nexus_insights_api_v1_microburst_status_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                ],
                'required': [
                    'site_group_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                },
                'location_map': {
                    'site_group_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_microburst_summary_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1MicroburstSummaryGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/microburst/summary',
                'operation_id': 'nexus_insights_api_v1_microburst_summary_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'site_group_name',
                    'site_name',
                    'node_name',
                    'interface_name',
                    'granularity',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'site_group_name',
                    'site_name',
                    'node_name',
                    'interface_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'node_name':
                        (str,),
                    'interface_name':
                        (str,),
                    'granularity':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'node_name': 'nodeName',
                    'interface_name': 'interfaceName',
                    'granularity': 'granularity',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'node_name': 'query',
                    'interface_name': 'query',
                    'granularity': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_microburst_top_bursts_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1MicroburstTopBurstsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/microburst/topBursts',
                'operation_id': 'nexus_insights_api_v1_microburst_top_bursts_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'site_group_name',
                    'site_name',
                    'node_name',
                    'interface_name',
                    'stat_name',
                    'queue_name',
                    'count',
                    'offset',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'site_group_name',
                    'site_name',
                    'node_name',
                    'interface_name',
                ],
                'nullable': [
                ],
                'enum': [
                    'stat_name',
                    'queue_name',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('stat_name',): {

                        "PEAK": "peak",
                        "DURATION": "duration"
                    },
                    ('queue_name',): {

                        "QUEUE0": "queue0",
                        "QUEUE1": "queue1",
                        "...": "...",
                        "ALL": "all"
                    },
                },
                'openapi_types': {
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'node_name':
                        (str,),
                    'interface_name':
                        (str,),
                    'stat_name':
                        (str,),
                    'queue_name':
                        (str,),
                    'count':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'node_name': 'nodeName',
                    'interface_name': 'interfaceName',
                    'stat_name': 'statName',
                    'queue_name': 'queueName',
                    'count': 'count',
                    'offset': 'offset',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'node_name': 'query',
                    'interface_name': 'query',
                    'stat_name': 'query',
                    'queue_name': 'query',
                    'count': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def nexus_insights_api_v1_microburst_queues_get(
        self,
        site_group_name="None",
        site_name="None",
        node_name="None",
        interface_name="None",
        **kwargs
    ):
        """Get interface queues  # noqa: E501

        Get all queues in an interface for particular node and fabric name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_microburst_queues_get(site_group_name="None", site_name="None", node_name="None", interface_name="None", async_req=True)
        >>> result = thread.get()

        Args:
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. defaults to "None", must be one of ["None"]
            site_name (str): Name of the Site - limit the records pertaining to the site. defaults to "None", must be one of ["None"]
            node_name (str): Name of the fabric node - limit the records pertaining to given nodeName. defaults to "None", must be one of ["None"]
            interface_name (str): Name of the node interface - limit the records pertaining to given interfaceName. defaults to "None", must be one of ["None"]

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1MicroburstQueuesGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['site_group_name'] = \
            site_group_name
        kwargs['site_name'] = \
            site_name
        kwargs['node_name'] = \
            node_name
        kwargs['interface_name'] = \
            interface_name
        return self.nexus_insights_api_v1_microburst_queues_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_microburst_status_get(
        self,
        site_group_name="None",
        **kwargs
    ):
        """Get microburst status of all fabrics  # noqa: E501

        Get microburst status of all fabrics in the site group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_microburst_status_get(site_group_name="None", async_req=True)
        >>> result = thread.get()

        Args:
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. defaults to "None", must be one of ["None"]

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1MicroburstStatusGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['site_group_name'] = \
            site_group_name
        return self.nexus_insights_api_v1_microburst_status_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_microburst_summary_get(
        self,
        start_date="now-1h",
        end_date="now",
        site_group_name="None",
        site_name="None",
        node_name="None",
        interface_name="None",
        **kwargs
    ):
        """Get summary of microburst  # noqa: E501

        Get summary of microburst - count, avg and max peak, avg and max duration values per queue  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_microburst_summary_get(start_date="now-1h", end_date="now", site_group_name="None", site_name="None", node_name="None", interface_name="None", async_req=True)
        >>> result = thread.get()

        Args:
            start_date (str): Start date, to skip records generated earlier to this date. defaults to "now-1h", must be one of ["now-1h"]
            end_date (str): End date, to collect the records generated till specified date. defaults to "now", must be one of ["now"]
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. defaults to "None", must be one of ["None"]
            site_name (str): Name of the Site - limit the records pertaining to the site. defaults to "None", must be one of ["None"]
            node_name (str): Name of the fabric node - limit the records pertaining to given nodeName. defaults to "None", must be one of ["None"]
            interface_name (str): Name of the node interface - limit the records pertaining to given interfaceName. defaults to "None", must be one of ["None"]

        Keyword Args:
            granularity (str): Granularity of statistics in the response. [optional] if omitted the server will use the default value of "1m"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1MicroburstSummaryGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['site_group_name'] = \
            site_group_name
        kwargs['site_name'] = \
            site_name
        kwargs['node_name'] = \
            node_name
        kwargs['interface_name'] = \
            interface_name
        return self.nexus_insights_api_v1_microburst_summary_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_microburst_top_bursts_get(
        self,
        start_date="now-1h",
        end_date="now",
        site_group_name="None",
        site_name="None",
        node_name="None",
        interface_name="None",
        **kwargs
    ):
        """Top microbursts based on peak or duration  # noqa: E501

        Gives the top N microbursts at interface level based on peak or duration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_microburst_top_bursts_get(start_date="now-1h", end_date="now", site_group_name="None", site_name="None", node_name="None", interface_name="None", async_req=True)
        >>> result = thread.get()

        Args:
            start_date (str): Start date, to skip records generated earlier to this date. defaults to "now-1h", must be one of ["now-1h"]
            end_date (str): End date, to collect the records generated till specified date. defaults to "now", must be one of ["now"]
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. defaults to "None", must be one of ["None"]
            site_name (str): Name of the Site - limit the records pertaining to the site. defaults to "None", must be one of ["None"]
            node_name (str): Name of the fabric node - limit the records pertaining to given nodeName. defaults to "None", must be one of ["None"]
            interface_name (str): Name of the node interface - limit the records pertaining to given interfaceName. defaults to "None", must be one of ["None"]

        Keyword Args:
            stat_name (str): Stats type - either peak or duration. [optional] if omitted the server will use the default value of "peak"
            queue_name (str): Name of the interface queue - either a particular queueName or combination of all [queue-0, queue-1, ..., all]. [optional] if omitted the server will use the default value of "all"
            count (int): Limits the number of entries. [optional] if omitted the server will use the default value of 10
            offset (int): Pagination index into response.. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1MicroburstTopBurstsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['site_group_name'] = \
            site_group_name
        kwargs['site_name'] = \
            site_name
        kwargs['node_name'] = \
            node_name
        kwargs['interface_name'] = \
            interface_name
        return self.nexus_insights_api_v1_microburst_top_bursts_get_endpoint.call_with_http_info(**kwargs)

