"""
    Cisco Nexus Cloud API

    Cisco Nexus Cloud API is a programmatic interface that uses the REST architecture to provide access to the Nexus Cloud functionality.  # noqa: E501

    The version of the OpenAPI document: 1.0.9
    Contact: nexuscloud@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from nexuscloud_client.api_client import ApiClient, Endpoint as _Endpoint
from nexuscloud_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from nexuscloud_client.model.nexus_insights_api_v1_interfaces_summary_get200_response import NexusInsightsApiV1InterfacesSummaryGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_l3neighbors_get200_response import NexusInsightsApiV1L3neighborsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_northsouth_traffic_summary_get200_response import NexusInsightsApiV1NorthsouthTrafficSummaryGet200Response


class InterfacesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.nexus_insights_api_v1_interfaces_summary_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1InterfacesSummaryGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/interfaces/summary',
                'operation_id': 'nexus_insights_api_v1_interfaces_summary_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'site_group_name',
                    'site_name',
                    'interface_type',
                    'filter',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'interface_type':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'interface_type': 'interfaceType',
                    'filter': 'filter',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'interface_type': 'query',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_l3neighbors_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1L3neighborsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/l3neighbors',
                'operation_id': 'nexus_insights_api_v1_l3neighbors_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'neighbor_operst',
                    'end_date',
                    'sort',
                    'site_group_name',
                    'site_name',
                    'filter',
                    'count',
                    'offset',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (str,),
                    'neighbor_operst':
                        (str,),
                    'end_date':
                        (str,),
                    'sort':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'filter':
                        (str,),
                    'count':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'neighbor_operst': 'neighborOperst',
                    'end_date': 'endDate',
                    'sort': 'sort',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'filter': 'filter',
                    'count': 'count',
                    'offset': 'offset',
                },
                'location_map': {
                    'start_date': 'query',
                    'neighbor_operst': 'query',
                    'end_date': 'query',
                    'sort': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'filter': 'query',
                    'count': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_northsouth_traffic_summary_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1NorthsouthTrafficSummaryGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/northsouthTraffic/summary',
                'operation_id': 'nexus_insights_api_v1_northsouth_traffic_summary_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'site_group_name',
                    'site_name',
                    'granularity',
                    'history',
                    'filter',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'granularity':
                        (str,),
                    'history':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'granularity': 'granularity',
                    'history': 'history',
                    'filter': 'filter',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'granularity': 'query',
                    'history': 'query',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def nexus_insights_api_v1_interfaces_summary_get(
        self,
        **kwargs
    ):
        """Get Interface Summary  # noqa: E501

        Get the interfaces stats and their status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_interfaces_summary_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            start_date (str): Start Date, to collect the records from the specified date. [optional] if omitted the server will use the default value of "now-1h"
            end_date (str): End Date, to collect the records at the specified date. [optional] if omitted the server will use the default value of "now"
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional] if omitted the server will use the default value of "None"
            site_name (str): Site name - limit the records pertaining to given site name. [optional] if omitted the server will use the default value of "None"
            interface_type (str): Interface type - limit the records pertaining to the given interfaceType. [optional] if omitted the server will use the default value of "None"
            filter (str): Filter the response based on this filter field. [optional] if omitted the server will use the default value of "None"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1InterfacesSummaryGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_interfaces_summary_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_l3neighbors_get(
        self,
        **kwargs
    ):
        """Get l3neighborsSummary Summary  # noqa: E501

        Get l3neighborsSummary Summary  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_l3neighbors_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            start_date (str): Start Date, to collect the records from the specified date. [optional] if omitted the server will use the default value of "now -1h"
            neighbor_operst (str): neighbor operst filter - limit the records pertaining to given operst. [optional]
            end_date (str): End Date, to collect the records at the specified date. [optional] if omitted the server will use the default value of "now"
            sort (str): Order the response based on this field. [optional] if omitted the server will use the default value of "None"
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional] if omitted the server will use the default value of "None"
            site_name (str): Site name - limit the records pertaining to given site name. [optional] if omitted the server will use the default value of "None"
            filter (str): Filter the response based on this filter field. [optional] if omitted the server will use the default value of "None"
            count (int): Limit the number of entries in response. [optional] if omitted the server will use the default value of 100
            offset (int): Pagination index into response. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1L3neighborsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_l3neighbors_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_northsouth_traffic_summary_get(
        self,
        **kwargs
    ):
        """Get NorthSouthTraffic Summary  # noqa: E501

        Get NorthSouthTraffic Summary  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_northsouth_traffic_summary_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            start_date (str): Start Date, to collect the records from the specified date. [optional] if omitted the server will use the default value of "now -1h"
            end_date (str): End Date, to collect the records at the specified date. [optional] if omitted the server will use the default value of "now"
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional] if omitted the server will use the default value of "None"
            site_name (str): Site name - limit the records pertaining to given site name. [optional] if omitted the server will use the default value of "None"
            granularity (str): Granularity of the values w.r.t duration. [optional] if omitted the server will use the default value of "5m"
            history (str): Require the timeseries data or not. [optional] if omitted the server will use the default value of "0"
            filter (str): Filter the response based on this filter field. [optional] if omitted the server will use the default value of "None"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1NorthsouthTrafficSummaryGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_northsouth_traffic_summary_get_endpoint.call_with_http_info(**kwargs)

