"""
    Cisco Nexus Cloud API

    Cisco Nexus Cloud API is a programmatic interface that uses the REST architecture to provide access to the Nexus Cloud functionality.  # noqa: E501

    The version of the OpenAPI document: 1.0.9
    Contact: nexuscloud@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from nexuscloud_client.api_client import ApiClient, Endpoint as _Endpoint
from nexuscloud_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from nexuscloud_client.model.nexus_insights_api_v1_vcenter_browse_get200_response import NexusInsightsApiV1VcenterBrowseGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_vcenter_details_get200_response import NexusInsightsApiV1VcenterDetailsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_vcenter_summary_get200_response import NexusInsightsApiV1VcenterSummaryGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_vcenter_top_entities_get200_response import NexusInsightsApiV1VcenterTopEntitiesGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_vcenter_topology_get200_response import NexusInsightsApiV1VcenterTopologyGet200Response


class IntegrationsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.nexus_insights_api_v1_vcenter_browse_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1VcenterBrowseGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/vcenter/browse',
                'operation_id': 'nexus_insights_api_v1_vcenter_browse_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'object',
                    'start_date',
                    'end_date',
                    'site_group_name',
                    'site_name',
                    'filter',
                    'count',
                    'offset',
                    'sort',
                ],
                'required': [
                    'object',
                ],
                'nullable': [
                ],
                'enum': [
                    'object',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('object',): {

                        "HOST": "host",
                        "VM": "vm",
                        "NETWORK": "network",
                        "NETWORKHOST": "networkhost",
                        "VMNETWORK": "vmnetwork",
                        "VSS": "vss",
                        "DVS": "dvs",
                        "DDVSHOST": "ddvshost",
                        "DATASTORE": "datastore",
                        "HOSTINSTANCE": "hostinstance"
                    },
                },
                'openapi_types': {
                    'object':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'filter':
                        (str,),
                    'count':
                        (int,),
                    'offset':
                        (int,),
                    'sort':
                        (str,),
                },
                'attribute_map': {
                    'object': 'object',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'filter': 'filter',
                    'count': 'count',
                    'offset': 'offset',
                    'sort': 'sort',
                },
                'location_map': {
                    'object': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'filter': 'query',
                    'count': 'query',
                    'offset': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_vcenter_details_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1VcenterDetailsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/vcenter/details',
                'operation_id': 'nexus_insights_api_v1_vcenter_details_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'object',
                    'start_date',
                    'end_date',
                    'site_group_name',
                    'site_name',
                    'filter',
                    'count',
                    'offset',
                    'stat_name',
                    'granularity',
                ],
                'required': [
                    'object',
                ],
                'nullable': [
                ],
                'enum': [
                    'object',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('object',): {

                        "VM": "vm",
                        "HOST": "host",
                        "HOSTINSTACE": "hostinstace",
                        "DATASTORE": "datastore"
                    },
                },
                'openapi_types': {
                    'object':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'filter':
                        (str,),
                    'count':
                        (int,),
                    'offset':
                        (int,),
                    'stat_name':
                        (str,),
                    'granularity':
                        (str,),
                },
                'attribute_map': {
                    'object': 'object',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'filter': 'filter',
                    'count': 'count',
                    'offset': 'offset',
                    'stat_name': 'statName',
                    'granularity': 'granularity',
                },
                'location_map': {
                    'object': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'filter': 'query',
                    'count': 'query',
                    'offset': 'query',
                    'stat_name': 'query',
                    'granularity': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_vcenter_summary_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1VcenterSummaryGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/vcenter/summary',
                'operation_id': 'nexus_insights_api_v1_vcenter_summary_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'object',
                    'start_date',
                    'end_date',
                    'site_group_name',
                    'site_name',
                    'aggr',
                ],
                'required': [
                    'object',
                ],
                'nullable': [
                ],
                'enum': [
                    'object',
                    'aggr',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('object',): {

                        "VM": "vm"
                    },
                    ('aggr',): {

                        "ANOMALYSCORE": "anomalyScore"
                    },
                },
                'openapi_types': {
                    'object':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'aggr':
                        (str,),
                },
                'attribute_map': {
                    'object': 'object',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'aggr': 'aggr',
                },
                'location_map': {
                    'object': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'aggr': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_vcenter_top_entities_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1VcenterTopEntitiesGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/vcenter/topEntities',
                'operation_id': 'nexus_insights_api_v1_vcenter_top_entities_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'object',
                    'stat_name',
                    'sort',
                    'start_date',
                    'end_date',
                    'site_group_name',
                    'site_name',
                    'filter',
                    'count',
                    'granularity',
                ],
                'required': [
                    'object',
                    'stat_name',
                    'sort',
                ],
                'nullable': [
                ],
                'enum': [
                    'object',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('object',): {

                        "VM": "vm",
                        "HOST": "host"
                    },
                },
                'openapi_types': {
                    'object':
                        (str,),
                    'stat_name':
                        (str,),
                    'sort':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'filter':
                        (str,),
                    'count':
                        (int,),
                    'granularity':
                        (str,),
                },
                'attribute_map': {
                    'object': 'object',
                    'stat_name': 'statName',
                    'sort': 'sort',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'filter': 'filter',
                    'count': 'count',
                    'granularity': 'granularity',
                },
                'location_map': {
                    'object': 'query',
                    'stat_name': 'query',
                    'sort': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'filter': 'query',
                    'count': 'query',
                    'granularity': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_vcenter_topology_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1VcenterTopologyGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/vcenter/topology',
                'operation_id': 'nexus_insights_api_v1_vcenter_topology_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'object',
                    'start_date',
                    'end_date',
                    'site_group_name',
                    'site_name',
                ],
                'required': [
                    'filter',
                    'object',
                ],
                'nullable': [
                ],
                'enum': [
                    'object',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('object',): {

                        "VM": "vm",
                        "HOST": "host"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'object':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                },
                'attribute_map': {
                    'filter': 'filter',
                    'object': 'object',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                },
                'location_map': {
                    'filter': 'query',
                    'object': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def nexus_insights_api_v1_vcenter_browse_get(
        self,
        object,
        **kwargs
    ):
        """Browse API for different vcenter objects  # noqa: E501

        Browse API for different vcenter objects  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_vcenter_browse_get(object, async_req=True)
        >>> result = thread.get()

        Args:
            object (str): Object in the vcenter hierarchy

        Keyword Args:
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-15m"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            filter (str): Lucene format filter - Filter the response based on this filter field. [optional]
            count (int): Num of nodes in response.. [optional]
            offset (int): Pagination index into response.. [optional] if omitted the server will use the default value of 0
            sort (str): Sort the reponse by which attribute and which order.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1VcenterBrowseGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['object'] = \
            object
        return self.nexus_insights_api_v1_vcenter_browse_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_vcenter_details_get(
        self,
        object,
        **kwargs
    ):
        """Details API for different vcenter objects  # noqa: E501

        Details API for different vcenter objects  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_vcenter_details_get(object, async_req=True)
        >>> result = thread.get()

        Args:
            object (str): Object in the vcenter hierarchy

        Keyword Args:
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-15m"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            filter (str): Lucene format filter - Filter the response based on this filter field. [optional]
            count (int): Limit the number of records in the response. [optional]
            offset (int): Pagination index into response.. [optional] if omitted the server will use the default value of 0
            stat_name (str): Limit statistics in the response. [optional]
            granularity (str): Granularity of the timeseries data w.r.t duration. [optional] if omitted the server will use the default value of "5m"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1VcenterDetailsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['object'] = \
            object
        return self.nexus_insights_api_v1_vcenter_details_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_vcenter_summary_get(
        self,
        object="vm",
        **kwargs
    ):
        """Get summary of vms  # noqa: E501

        Get aggregated count of vms  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_vcenter_summary_get(object="vm", async_req=True)
        >>> result = thread.get()

        Args:
            object (str): Integration type - limit the records pertaining to this type of integration. defaults to "vm", must be one of ["vm"]

        Keyword Args:
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-15m"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            aggr (str): Aggregate records by this field. [optional] if omitted the server will use the default value of "anomalyScore"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1VcenterSummaryGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['object'] = \
            object
        return self.nexus_insights_api_v1_vcenter_summary_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_vcenter_top_entities_get(
        self,
        object,
        stat_name,
        sort,
        **kwargs
    ):
        """Top Entities API for different vcenter objects  # noqa: E501

        Top Entities API for different vcenter objects  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_vcenter_top_entities_get(object, stat_name, sort, async_req=True)
        >>> result = thread.get()

        Args:
            object (str): Object in the application hierarchy
            stat_name (str): Limit statistics in the response
            sort (str): Sort the reponse by which attribute and which order.

        Keyword Args:
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-15m"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            filter (str): Lucene format filter - Filter the response based on this filter field. [optional]
            count (int): Limit the number of records in the response. [optional] if omitted the server will use the default value of 1
            granularity (str): Granularity of statistics in the response. [optional] if omitted the server will use the default value of "5m"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1VcenterTopEntitiesGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['object'] = \
            object
        kwargs['stat_name'] = \
            stat_name
        kwargs['sort'] = \
            sort
        return self.nexus_insights_api_v1_vcenter_top_entities_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_vcenter_topology_get(
        self,
        filter,
        object,
        **kwargs
    ):
        """Get topology of a vcenter entity  # noqa: E501

        Get topology of a vcenter entity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_vcenter_topology_get(filter, object, async_req=True)
        >>> result = thread.get()

        Args:
            filter (str): Lucene format filter - Filter the response based on this filter field
            object (str): Object in the application hierarchy

        Keyword Args:
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-15m"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1VcenterTopologyGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['filter'] = \
            filter
        kwargs['object'] = \
            object
        return self.nexus_insights_api_v1_vcenter_topology_get_endpoint.call_with_http_info(**kwargs)

