"""
    Cisco Nexus Cloud API

    Cisco Nexus Cloud API is a programmatic interface that uses the REST architecture to provide access to the Nexus Cloud functionality.  # noqa: E501

    The version of the OpenAPI document: 1.0.9
    Contact: nexuscloud@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from nexuscloud_client.api_client import ApiClient, Endpoint as _Endpoint
from nexuscloud_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from nexuscloud_client.model.nexus_insights_api_v1_sites_get200_response import NexusInsightsApiV1SitesGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_sites_summary_get200_response import NexusInsightsApiV1SitesSummaryGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_sites_top_nodes_get200_response import NexusInsightsApiV1SitesTopNodesGet200Response


class FabricsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.nexus_insights_api_v1_sites_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SitesGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/sites',
                'operation_id': 'nexus_insights_api_v1_sites_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                    'site_name',
                    'filter',
                    'config_status',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'config_status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('config_status',): {

                        "ENABLED": "ENABLED",
                        "DISABLED": "DISABLED",
                        "NONE": "None"
                    },
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'filter':
                        (str,),
                    'config_status':
                        (str,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'filter': 'filter',
                    'config_status': 'configStatus',
                },
                'location_map': {
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'filter': 'query',
                    'config_status': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_sites_summary_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SitesSummaryGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/sitesSummary',
                'operation_id': 'nexus_insights_api_v1_sites_summary_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                    'site_name',
                    'start_date',
                    'end_date',
                    'history',
                    'granularity',
                    'include',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'history':
                        (str,),
                    'granularity':
                        (str,),
                    'include':
                        (str,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'history': 'history',
                    'granularity': 'granularity',
                    'include': 'include',
                },
                'location_map': {
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                    'history': 'query',
                    'granularity': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_sites_top_nodes_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SitesTopNodesGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/sites/topNodes',
                'operation_id': 'nexus_insights_api_v1_sites_top_nodes_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'node_name',
                    'site_group_name',
                    'site_name',
                    'granularity',
                    'history',
                    'count',
                    'resource_count',
                    'score_type',
                    'resource_type',
                    'node_roles',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'score_type',
                    'resource_type',
                    'node_roles',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('score_type',): {

                        "TOTALSCORE": "totalScore",
                        "ANOMALYSCORE": "anomalyScore",
                        "TRENDSCORE": "trendScore",
                        "RAWANOMALYSCORE": "rawAnomalyScore"
                    },
                    ('resource_type',): {

                        "STATISTICS": "statistics",
                        "ENVIRONMENTAL": "environmental",
                        "FLOW": "flow",
                        "RESOURCES": "resources",
                        "ENDPOINT": "endpoint",
                        "ALL": "all"
                    },
                    ('node_roles',): {

                        "CONTROLLER": "controller",
                        "LEAF": "leaf",
                        "SPINE": "spine",
                        "NONE": "None"
                    },
                },
                'openapi_types': {
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'node_name':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'granularity':
                        (str,),
                    'history':
                        (int,),
                    'count':
                        (int,),
                    'resource_count':
                        (int,),
                    'score_type':
                        (str,),
                    'resource_type':
                        (str,),
                    'node_roles':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'node_name': 'nodeName',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'granularity': 'granularity',
                    'history': 'history',
                    'count': 'count',
                    'resource_count': 'resourceCount',
                    'score_type': 'scoreType',
                    'resource_type': 'resourceType',
                    'node_roles': 'nodeRoles',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'node_name': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'granularity': 'query',
                    'history': 'query',
                    'count': 'query',
                    'resource_count': 'query',
                    'score_type': 'query',
                    'resource_type': 'query',
                    'node_roles': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def nexus_insights_api_v1_sites_get(
        self,
        **kwargs
    ):
        """Get fabrics list  # noqa: E501

        Get detailed info of fabrics  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_sites_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional] if omitted the server will use the default value of "None"
            site_name (str): Name of the Site - limit the records pertaining to this siteName. [optional] if omitted the server will use the default value of "None"
            filter (str): Lucene format filter. [optional] if omitted the server will use the default value of "None"
            config_status (str): Config status. [optional] if omitted the server will use the default value of "None"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SitesGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_sites_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_sites_summary_get(
        self,
        **kwargs
    ):
        """Get fabric anomaly summary  # noqa: E501

        Get the fabric anomaly summary having number of anomalies generated and respective anomaly scores  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_sites_summary_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional] if omitted the server will use the default value of "None"
            site_name (str): Name of the Site, Limit the records pertaining to this siteName. [optional] if omitted the server will use the default value of "None"
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-1h"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            history (str): Defines whether records need to be added with timeseries or not in response. [optional] if omitted the server will use the default value of "0"
            granularity (str): Granularity of the timeseries data w.r.t duration, applicable if history is set to yes. [optional] if omitted the server will use the default value of "5m"
            include (str): Includes the latest maximum anomalyscore of the site if set to \"anomalyScore\". [optional] if omitted the server will use the default value of "None"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SitesSummaryGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_sites_summary_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_sites_top_nodes_get(
        self,
        **kwargs
    ):
        """Get Fabric wide Top Nodes  # noqa: E501

        Get Fabric wide top nodes by Resource Utilization, Environmental, Statistics, Flow Analytics and Endpoint Analytics  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_sites_top_nodes_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            start_date (str): Start timestamp, to skip records generated earlier to this timestamp. [optional] if omitted the server will use the default value of "now-1h"
            end_date (str): End timestamp, to collect the records generated till specified time. [optional] if omitted the server will use the default value of "now"
            node_name (str): Name of the fabric node, limit the anamaloy score to given nodeName. [optional] if omitted the server will use the default value of "None"
            site_group_name (str): Name of Site Group, limit the records pertaining to the sites in this siteGroupName. [optional] if omitted the server will use the default value of "None"
            site_name (str): Name of the Site, Limit the records pertaining to this siteName. [optional] if omitted the server will use the default value of "None"
            granularity (str): Granularity of the values w.r.t duration, mandatory when history is 1. [optional] if omitted the server will use the default value of "5m"
            history (int): Defines whether records need to be added with timeseries or not in response. [optional] if omitted the server will use the default value of 0
            count (int): Limits the number of entries in the response. [optional] if omitted the server will use the default value of 10
            resource_count (int): Limits the number of resources entries per node. [optional] if omitted the server will use the default value of 10
            score_type (str): Score type, either of [totalScore, anomalyScore, trendScore, rawAnomalyScore]. [optional] if omitted the server will use the default value of "rawAnomalyScore"
            resource_type (str): Resource type, either of [statistics, environmental, flow, resources, endpoint, all]. [optional] if omitted the server will use the default value of "all"
            node_roles (str): Specifies type of node or comma seprated mutiple types like leaf,contoller,spine. [optional] if omitted the server will use the default value of "None"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SitesTopNodesGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_sites_top_nodes_get_endpoint.call_with_http_info(**kwargs)

