"""
    Cisco Nexus Cloud API

    Cisco Nexus Cloud API is a programmatic interface that uses the REST architecture to provide access to the Nexus Cloud functionality.  # noqa: E501

    The version of the OpenAPI document: 1.0.9
    Contact: nexuscloud@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from nexuscloud_client.api_client import ApiClient, Endpoint as _Endpoint
from nexuscloud_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from nexuscloud_client.model.nexus_insights_api_v1_events_buckets_get200_response import NexusInsightsApiV1EventsBucketsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_events_details_get200_response import NexusInsightsApiV1EventsDetailsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_events_summary_get200_response import NexusInsightsApiV1EventsSummaryGet200Response


class EventsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.nexus_insights_api_v1_events_buckets_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1EventsBucketsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/events/buckets',
                'operation_id': 'nexus_insights_api_v1_events_buckets_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'site_group_name',
                    'site_name',
                    'granularity',
                    'filter',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'granularity':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'granularity': 'granularity',
                    'filter': 'filter',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'granularity': 'query',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_events_details_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1EventsDetailsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/events/details',
                'operation_id': 'nexus_insights_api_v1_events_details_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'site_group_name',
                    'site_name',
                    'filter',
                    'offset',
                    'sort',
                    'count',
                    'event_type',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'event_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('event_type',): {

                        "AUDITLOG": "AuditLog",
                        "EVENT": "Event",
                        "FAULT": "Fault",
                        "NONE": "None"
                    },
                },
                'openapi_types': {
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'filter':
                        (str,),
                    'offset':
                        (int,),
                    'sort':
                        (str,),
                    'count':
                        (int,),
                    'event_type':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'filter': 'filter',
                    'offset': 'offset',
                    'sort': 'sort',
                    'count': 'count',
                    'event_type': 'eventType',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'filter': 'query',
                    'offset': 'query',
                    'sort': 'query',
                    'count': 'query',
                    'event_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_events_summary_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1EventsSummaryGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/events/summary',
                'operation_id': 'nexus_insights_api_v1_events_summary_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'site_group_name',
                    'site_name',
                    'node_name',
                    'filter',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'node_name':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'node_name': 'nodeName',
                    'filter': 'filter',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'node_name': 'query',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def nexus_insights_api_v1_events_buckets_get(
        self,
        **kwargs
    ):
        """Events buckets  # noqa: E501

        Get the count of Audit Logs, Events and Faults event types in time series pattern within the specified time period  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_events_buckets_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-1h"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional] if omitted the server will use the default value of "None"
            site_name (str): Name of the Site - limit the records pertaining to this siteName. [optional] if omitted the server will use the default value of "None"
            granularity (str): The samples interval time. [optional] if omitted the server will use the default value of "5m"
            filter (str): Lucene format filter. [optional] if omitted the server will use the default value of "None"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1EventsBucketsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_events_buckets_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_events_details_get(
        self,
        **kwargs
    ):
        """Events details  # noqa: E501

        Get the detailed info for Audit Logs, Events and Faults event types within the specified time period  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_events_details_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-1h"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional] if omitted the server will use the default value of "None"
            site_name (str): Name of the Site - limit the records pertaining to this siteName. [optional] if omitted the server will use the default value of "None"
            filter (str): Lucene format filter. [optional] if omitted the server will use the default value of "None"
            offset (int): Offset from which records are to be returned. [optional] if omitted the server will use the default value of 0
            sort (str): Sort results by event type/severity. Use +/- as prefix for ascending/descending order. [optional] if omitted the server will use the default value of "None"
            count (int): Limits the number of records in the response. [optional] if omitted the server will use the default value of 10
            event_type (str): Type of event. [optional] if omitted the server will use the default value of "None"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1EventsDetailsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_events_details_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_events_summary_get(
        self,
        **kwargs
    ):
        """Events summary  # noqa: E501

        Get the severity/action count for Audit Logs, Events and Faults event types within the specified time period  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_events_summary_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-1h"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional] if omitted the server will use the default value of "None"
            site_name (str): Name of the Site - limit the records pertaining to this siteName. [optional] if omitted the server will use the default value of "None"
            node_name (str): Name of the node - limit the records pertaining to this nodeName. [optional] if omitted the server will use the default value of "None"
            filter (str): Lucene format filter. [optional] if omitted the server will use the default value of "None"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1EventsSummaryGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_events_summary_get_endpoint.call_with_http_info(**kwargs)

