"""
    Cisco Nexus Cloud API

    Cisco Nexus Cloud API is a programmatic interface that uses the REST architecture to provide access to the Nexus Cloud functionality.  # noqa: E501

    The version of the OpenAPI document: 1.0.9
    Contact: nexuscloud@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from nexuscloud_client.api_client import ApiClient, Endpoint as _Endpoint
from nexuscloud_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from nexuscloud_client.model.nexus_insights_api_v1_endpoints_anomalies_get200_response import NexusInsightsApiV1EndpointsAnomaliesGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_endpoints_count_get200_response import NexusInsightsApiV1EndpointsCountGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_endpoints_details_get200_response import NexusInsightsApiV1EndpointsDetailsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_endpoints_duplicate_ips_get200_response import NexusInsightsApiV1EndpointsDuplicateIpsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_endpoints_get200_response import NexusInsightsApiV1EndpointsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_endpoints_history_get200_response import NexusInsightsApiV1EndpointsHistoryGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_endpoints_statistics_get200_response import NexusInsightsApiV1EndpointsStatisticsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_endpoints_top_endpoints_get200_response import NexusInsightsApiV1EndpointsTopEndpointsGet200Response


class EndpointAnalyticsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.nexus_insights_api_v1_endpoints_anomalies_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1EndpointsAnomaliesGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/endpoints/anomalies',
                'operation_id': 'nexus_insights_api_v1_endpoints_anomalies_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                    'endpoint',
                    'site_name',
                    'offset',
                    'count',
                    'sort',
                    'start_date',
                    'end_date',
                    'filter',
                ],
                'required': [
                    'site_group_name',
                    'endpoint',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                    'endpoint':
                        (str,),
                    'site_name':
                        (str,),
                    'offset':
                        (str,),
                    'count':
                        (str,),
                    'sort':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                    'endpoint': 'endpoint',
                    'site_name': 'siteName',
                    'offset': 'offset',
                    'count': 'count',
                    'sort': 'sort',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'filter': 'filter',
                },
                'location_map': {
                    'site_group_name': 'query',
                    'endpoint': 'query',
                    'site_name': 'query',
                    'offset': 'query',
                    'count': 'query',
                    'sort': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_endpoints_count_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1EndpointsCountGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/endpoints/count',
                'operation_id': 'nexus_insights_api_v1_endpoints_count_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                    'site_name',
                    'end_date',
                    'filter',
                    'aggr',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'end_date':
                        (str,),
                    'filter':
                        (str,),
                    'aggr':
                        (str,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'end_date': 'endDate',
                    'filter': 'filter',
                    'aggr': 'aggr',
                },
                'location_map': {
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'end_date': 'query',
                    'filter': 'query',
                    'aggr': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_endpoints_details_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1EndpointsDetailsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/endpoints/details',
                'operation_id': 'nexus_insights_api_v1_endpoints_details_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                    'site_name',
                    'endpoint',
                    'start_date',
                    'end_date',
                    'filter',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'endpoint':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'endpoint': 'endpoint',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'filter': 'filter',
                },
                'location_map': {
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'endpoint': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_endpoints_duplicate_ips_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1EndpointsDuplicateIpsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/endpoints/duplicateIps',
                'operation_id': 'nexus_insights_api_v1_endpoints_duplicate_ips_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                    'site_name',
                    'endpoint',
                    'details',
                    'start_date',
                    'end_date',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'details',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('details',): {

                        "TRUE": "true",
                        "FALSE": "false",
                        "NONE": "None"
                    },
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'endpoint':
                        (str,),
                    'details':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'endpoint': 'endpoint',
                    'details': 'details',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'endpoint': 'query',
                    'details': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_endpoints_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1EndpointsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/endpoints',
                'operation_id': 'nexus_insights_api_v1_endpoints_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                    'site_name',
                    'offset',
                    'count',
                    'sort',
                    'filter',
                    'start_date',
                    'end_date',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'offset':
                        (str,),
                    'count':
                        (str,),
                    'sort':
                        (str,),
                    'filter':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'offset': 'offset',
                    'count': 'count',
                    'sort': 'sort',
                    'filter': 'filter',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'offset': 'query',
                    'count': 'query',
                    'sort': 'query',
                    'filter': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_endpoints_history_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1EndpointsHistoryGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/endpoints/history',
                'operation_id': 'nexus_insights_api_v1_endpoints_history_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'endpoint',
                    'site_group_name',
                    'site_name',
                    'offset',
                    'count',
                    'sort',
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'endpoint',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'endpoint':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'offset':
                        (str,),
                    'count':
                        (str,),
                    'sort':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                },
                'attribute_map': {
                    'endpoint': 'endpoint',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'offset': 'offset',
                    'count': 'count',
                    'sort': 'sort',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'endpoint': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'offset': 'query',
                    'count': 'query',
                    'sort': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_endpoints_statistics_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1EndpointsStatisticsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/endpoints/statistics',
                'operation_id': 'nexus_insights_api_v1_endpoints_statistics_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'site_group_name',
                    'site_name',
                    'count',
                    'stat_name',
                    'start_date',
                    'end_date',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'stat_name',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('stat_name',): {

                        "TOTALENDPOINTS": "totalEndpoints",
                        "ANOMALYSCORE": "anomalyScore"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'count':
                        (str,),
                    'stat_name':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                },
                'attribute_map': {
                    'filter': 'filter',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'count': 'count',
                    'stat_name': 'statName',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'filter': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'count': 'query',
                    'stat_name': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_endpoints_top_endpoints_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1EndpointsTopEndpointsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/endpoints/topEndpoints',
                'operation_id': 'nexus_insights_api_v1_endpoints_top_endpoints_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                    'site_name',
                    'count',
                    'start_date',
                    'end_date',
                    'filter',
                    'stat_name',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'stat_name',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('stat_name',): {

                        "ANOMALYSCORE": "anomalyScore"
                    },
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'count':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'filter':
                        (str,),
                    'stat_name':
                        (str,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'count': 'count',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'filter': 'filter',
                    'stat_name': 'statName',
                },
                'location_map': {
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'count': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                    'filter': 'query',
                    'stat_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_endpoints_top_nodes_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1EndpointsStatisticsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/endpoints/topNodes',
                'operation_id': 'nexus_insights_api_v1_endpoints_top_nodes_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                    'site_name',
                    'count',
                    'stat_name',
                    'start_date',
                    'end_date',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'stat_name',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('stat_name',): {

                        "TOTALENDPOINTS": "totalEndpoints",
                        "ANOMALYSCORE": "anomalyScore"
                    },
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'count':
                        (str,),
                    'stat_name':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'count': 'count',
                    'stat_name': 'statName',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'count': 'query',
                    'stat_name': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def nexus_insights_api_v1_endpoints_anomalies_get(
        self,
        site_group_name,
        endpoint,
        **kwargs
    ):
        """Get the anomaly history of an endpoint.  # noqa: E501

        Get the entire anomaly history of an endpoint based on the timestamp.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_endpoints_anomalies_get(site_group_name, endpoint, async_req=True)
        >>> result = thread.get()

        Args:
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group
            endpoint (str): Endpoint for which the anomaly history is to be retrieved

        Keyword Args:
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            offset (str): Pagination index into response.. [optional] if omitted the server will use the default value of "0"
            count (str): Num of nodes in response.. [optional] if omitted the server will use the default value of "10"
            sort (str): Sort the reponse by which attribute and which order.. [optional]
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-1h"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            filter (str): Lucene format filter. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1EndpointsAnomaliesGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['site_group_name'] = \
            site_group_name
        kwargs['endpoint'] = \
            endpoint
        return self.nexus_insights_api_v1_endpoints_anomalies_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_endpoints_count_get(
        self,
        **kwargs
    ):
        """Get the Endpoints Count of entire site or given a condition  # noqa: E501

        Get the Endpoints Count of entire site or given a condition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_endpoints_count_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            end_date (str): End timestamp. [optional] if omitted the server will use the default value of "now"
            filter (str): Lucene format filter. [optional]
            aggr (str): Get the epCount, aggregation by this field. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1EndpointsCountGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_endpoints_count_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_endpoints_details_get(
        self,
        **kwargs
    ):
        """Get the history of an endpoint  # noqa: E501

        Get the entire history of an endpoint based on the timestamp  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_endpoints_details_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            endpoint (str): Endpoint for which the history is to be retrieved. [optional]
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-1h"
            end_date (str): End date, to collect the records generated till specified date. [optional]
            filter (str): Lucene format filter. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1EndpointsDetailsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_endpoints_details_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_endpoints_duplicate_ips_get(
        self,
        **kwargs
    ):
        """Get the count of duplicate IPs.  # noqa: E501

        Get the count of duplicate IPs associated with an endpoint based on the timestamp  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_endpoints_duplicate_ips_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            endpoint (str): Endpoint for which the duplicate ips are to be retrieved. [optional]
            details (str): option to include the details of duplicate ips list. [optional]
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-1h"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1EndpointsDuplicateIpsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_endpoints_duplicate_ips_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_endpoints_get(
        self,
        **kwargs
    ):
        """Get the snapshot of entire site or a particular node at a given time  # noqa: E501

        Get the snapshot of entire site or a particular node at a given time  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_endpoints_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            offset (str): Pagination index into response.. [optional] if omitted the server will use the default value of "0"
            count (str): Num of nodes in response.. [optional] if omitted the server will use the default value of "10"
            sort (str): Sort the reponse by which attribute and which order.. [optional]
            filter (str): Lucene format filter. [optional]
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-1h"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1EndpointsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_endpoints_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_endpoints_history_get(
        self,
        endpoint,
        **kwargs
    ):
        """Get the history of an endpoint  # noqa: E501

        Get the entire history of an endpoint based on the timestamp  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_endpoints_history_get(endpoint, async_req=True)
        >>> result = thread.get()

        Args:
            endpoint (str): Endpoint for which the history is to be retrieved

        Keyword Args:
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            offset (str): Pagination index into response.. [optional] if omitted the server will use the default value of "0"
            count (str): Num of nodes in response.. [optional] if omitted the server will use the default value of "10"
            sort (str): Sort the reponse by which attribute and which order.. [optional]
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-1h"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1EndpointsHistoryGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['endpoint'] = \
            endpoint
        return self.nexus_insights_api_v1_endpoints_history_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_endpoints_statistics_get(
        self,
        **kwargs
    ):
        """Get the top nodes by endpoint statistics.  # noqa: E501

        Get the top nodes by endpoint anomaly score or total endpoints.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_endpoints_statistics_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            filter (str): Lucene format filter - Filter the response based on this filter field. [optional]
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            count (str): Num of nodes in response.. [optional] if omitted the server will use the default value of "10"
            stat_name (str): The statName to get the top nodes by.. [optional]
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-1h"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1EndpointsStatisticsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_endpoints_statistics_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_endpoints_top_endpoints_get(
        self,
        **kwargs
    ):
        """Get the top nodes by endpoint anomaly score.  # noqa: E501

        Get the top nodes by endpoint anomaly score.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_endpoints_top_endpoints_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            count (str): Num of nodes in response.. [optional] if omitted the server will use the default value of "10"
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-1h"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            filter (str): Lucene format filter - Filter the response based on this filter field. [optional]
            stat_name (str): The statName to get the top nodes by.. [optional] if omitted the server will use the default value of "anomalyScore"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1EndpointsTopEndpointsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_endpoints_top_endpoints_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_endpoints_top_nodes_get(
        self,
        **kwargs
    ):
        """Get the top nodes by endpoint stat.  # noqa: E501

        Get the top nodes by endpoint anomaly score or total endpoints.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_endpoints_top_nodes_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            count (str): Num of nodes in response.. [optional] if omitted the server will use the default value of "10"
            stat_name (str): The statName to get the top nodes by.. [optional]
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-1h"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1EndpointsStatisticsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_endpoints_top_nodes_get_endpoint.call_with_http_info(**kwargs)

