"""
    Cisco Nexus Cloud API

    Cisco Nexus Cloud API is a programmatic interface that uses the REST architecture to provide access to the Nexus Cloud functionality.  # noqa: E501

    The version of the OpenAPI document: 1.0.9
    Contact: nexuscloud@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from nexuscloud_client.api_client import ApiClient, Endpoint as _Endpoint
from nexuscloud_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from nexuscloud_client.model.nexus_insights_api_v1_alerts_trend_get200_response import NexusInsightsApiV1AlertsTrendGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_anomalies_buckets_get200_response import NexusInsightsApiV1AnomaliesBucketsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_anomalies_details_get200_response import NexusInsightsApiV1AnomaliesDetailsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_anomalies_related_metrics_get200_response import NexusInsightsApiV1AnomaliesRelatedMetricsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_anomalies_related_objects_get200_response import NexusInsightsApiV1AnomaliesRelatedObjectsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_anomalies_summary_get200_response import NexusInsightsApiV1AnomaliesSummaryGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_anomalies_time_range_trend_get200_response import NexusInsightsApiV1AnomaliesTimeRangeTrendGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_anomalies_top_fabrics_get200_response import NexusInsightsApiV1AnomaliesTopFabricsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_anomalies_top_flow_records_get200_response import NexusInsightsApiV1AnomaliesTopFlowRecordsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_anomalies_top_flows_get200_response import NexusInsightsApiV1AnomaliesTopFlowsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_anomalies_top_nodes_get200_response import NexusInsightsApiV1AnomaliesTopNodesGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_anomalies_trend_get200_response import NexusInsightsApiV1AnomaliesTrendGet200Response


class AnomaliesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.nexus_insights_api_v1_alerts_trend_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1AlertsTrendGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/alerts/trend',
                'operation_id': 'nexus_insights_api_v1_alerts_trend_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                    'site_name',
                    'trend_interval',
                    'start_ts',
                    'end_ts',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'trend_interval':
                        (str,),
                    'start_ts':
                        (str,),
                    'end_ts':
                        (str,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'trend_interval': 'trendInterval',
                    'start_ts': 'startTs',
                    'end_ts': 'endTs',
                },
                'location_map': {
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'trend_interval': 'query',
                    'start_ts': 'query',
                    'end_ts': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_anomalies_buckets_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1AnomaliesBucketsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/anomalies/buckets',
                'operation_id': 'nexus_insights_api_v1_anomalies_buckets_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                    'granularity',
                    'end_date',
                    'start_date',
                    'site_name',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                    'granularity':
                        (str,),
                    'end_date':
                        (str,),
                    'start_date':
                        (str,),
                    'site_name':
                        (str,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                    'granularity': 'granularity',
                    'end_date': 'endDate',
                    'start_date': 'startDate',
                    'site_name': 'siteName',
                },
                'location_map': {
                    'site_group_name': 'query',
                    'granularity': 'query',
                    'end_date': 'query',
                    'start_date': 'query',
                    'site_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_anomalies_details_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1AnomaliesDetailsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/anomalies/details',
                'operation_id': 'nexus_insights_api_v1_anomalies_details_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'site_group_name',
                    'site_name',
                    'node_name',
                    'offset',
                    'count',
                    'end_date',
                    'sort',
                    'start_date',
                    'aggr',
                    'site_status',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'site_status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('site_status',): {

                        "ALL": "all",
                        "ONLINE": "online",
                        "OFFLINE": "offline"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'node_name':
                        (str,),
                    'offset':
                        (str,),
                    'count':
                        (str,),
                    'end_date':
                        (str,),
                    'sort':
                        (str,),
                    'start_date':
                        (str,),
                    'aggr':
                        (str,),
                    'site_status':
                        (str,),
                },
                'attribute_map': {
                    'filter': 'filter',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'node_name': 'nodeName',
                    'offset': 'offset',
                    'count': 'count',
                    'end_date': 'endDate',
                    'sort': 'sort',
                    'start_date': 'startDate',
                    'aggr': 'aggr',
                    'site_status': 'siteStatus',
                },
                'location_map': {
                    'filter': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'node_name': 'query',
                    'offset': 'query',
                    'count': 'query',
                    'end_date': 'query',
                    'sort': 'query',
                    'start_date': 'query',
                    'aggr': 'query',
                    'site_status': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_anomalies_related_metrics_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1AnomaliesRelatedMetricsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/anomalies/relatedMetrics',
                'operation_id': 'nexus_insights_api_v1_anomalies_related_metrics_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                    'anomaly_id',
                    'user_name',
                    'site_name',
                    'resource_list',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                    'anomaly_id':
                        (str,),
                    'user_name':
                        (str,),
                    'site_name':
                        (str,),
                    'resource_list':
                        (str,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                    'anomaly_id': 'anomalyId',
                    'user_name': 'userName',
                    'site_name': 'siteName',
                    'resource_list': 'resourceList',
                },
                'location_map': {
                    'site_group_name': 'query',
                    'anomaly_id': 'query',
                    'user_name': 'query',
                    'site_name': 'query',
                    'resource_list': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_anomalies_related_metrics_post_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1AnomaliesRelatedMetricsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/anomalies/relatedMetrics',
                'operation_id': 'nexus_insights_api_v1_anomalies_related_metrics_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                    'anomaly_id',
                    'user_name',
                    'site_name',
                    'resource_list',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                    'anomaly_id':
                        (str,),
                    'user_name':
                        (str,),
                    'site_name':
                        (str,),
                    'resource_list':
                        (str,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                    'anomaly_id': 'anomalyId',
                    'user_name': 'userName',
                    'site_name': 'siteName',
                    'resource_list': 'resourceList',
                },
                'location_map': {
                    'site_group_name': 'query',
                    'anomaly_id': 'query',
                    'user_name': 'query',
                    'site_name': 'query',
                    'resource_list': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_anomalies_related_objects_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1AnomaliesRelatedObjectsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/anomalies/relatedObjects',
                'operation_id': 'nexus_insights_api_v1_anomalies_related_objects_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                    'end_date',
                    'start_date',
                    'site_name',
                    'anomaly_id',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                    'end_date':
                        (str,),
                    'start_date':
                        (str,),
                    'site_name':
                        (str,),
                    'anomaly_id':
                        (str,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                    'end_date': 'endDate',
                    'start_date': 'startDate',
                    'site_name': 'siteName',
                    'anomaly_id': 'anomalyId',
                },
                'location_map': {
                    'site_group_name': 'query',
                    'end_date': 'query',
                    'start_date': 'query',
                    'site_name': 'query',
                    'anomaly_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_anomalies_summary_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1AnomaliesSummaryGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/anomalies/summary',
                'operation_id': 'nexus_insights_api_v1_anomalies_summary_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                    'site_name',
                    'node_name',
                    'filter',
                    'end_date',
                    'start_date',
                    'aggr',
                    'site_status',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'site_status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('site_status',): {

                        "ALL": "all",
                        "ONLINE": "online",
                        "OFFLINE": "offline"
                    },
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'node_name':
                        (str,),
                    'filter':
                        (str,),
                    'end_date':
                        (str,),
                    'start_date':
                        (str,),
                    'aggr':
                        (str,),
                    'site_status':
                        (str,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'node_name': 'nodeName',
                    'filter': 'filter',
                    'end_date': 'endDate',
                    'start_date': 'startDate',
                    'aggr': 'aggr',
                    'site_status': 'siteStatus',
                },
                'location_map': {
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'node_name': 'query',
                    'filter': 'query',
                    'end_date': 'query',
                    'start_date': 'query',
                    'aggr': 'query',
                    'site_status': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_anomalies_time_range_trend_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1AnomaliesTimeRangeTrendGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/anomalies/timeRangeTrend',
                'operation_id': 'nexus_insights_api_v1_anomalies_time_range_trend_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                    'site_name',
                    'trend_interval',
                    'num_past_intervals',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'trend_interval':
                        (str,),
                    'num_past_intervals':
                        (int,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'trend_interval': 'trendInterval',
                    'num_past_intervals': 'numPastIntervals',
                },
                'location_map': {
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'trend_interval': 'query',
                    'num_past_intervals': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_anomalies_top_fabrics_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1AnomaliesTopFabricsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/anomalies/topFabrics',
                'operation_id': 'nexus_insights_api_v1_anomalies_top_fabrics_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'site_group_name',
                    'count',
                    'offset',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'site_group_name':
                        (str,),
                    'count':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'site_group_name': 'siteGroupName',
                    'count': 'count',
                    'offset': 'offset',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'site_group_name': 'query',
                    'count': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_anomalies_top_flow_records_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1AnomaliesTopFlowRecordsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/anomalies/topFlowRecords',
                'operation_id': 'nexus_insights_api_v1_anomalies_top_flow_records_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'end_date',
                    'start_date',
                    'site_group_name',
                    'node_name',
                    'count',
                    'stat_name',
                    'filter',
                    'granularity',
                    'site_name',
                ],
                'required': [
                    'end_date',
                    'start_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'end_date':
                        (str,),
                    'start_date':
                        (str,),
                    'site_group_name':
                        (str,),
                    'node_name':
                        (str,),
                    'count':
                        (str,),
                    'stat_name':
                        (str,),
                    'filter':
                        (str,),
                    'granularity':
                        (str,),
                    'site_name':
                        (str,),
                },
                'attribute_map': {
                    'end_date': 'endDate',
                    'start_date': 'startDate',
                    'site_group_name': 'siteGroupName',
                    'node_name': 'nodeName',
                    'count': 'count',
                    'stat_name': 'statName',
                    'filter': 'filter',
                    'granularity': 'granularity',
                    'site_name': 'siteName',
                },
                'location_map': {
                    'end_date': 'query',
                    'start_date': 'query',
                    'site_group_name': 'query',
                    'node_name': 'query',
                    'count': 'query',
                    'stat_name': 'query',
                    'filter': 'query',
                    'granularity': 'query',
                    'site_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_anomalies_top_flows_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1AnomaliesTopFlowsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/anomalies/topFlows',
                'operation_id': 'nexus_insights_api_v1_anomalies_top_flows_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'end_date',
                    'start_date',
                    'site_group_name',
                    'site_name',
                    'count',
                    'offset',
                    'stat_name',
                ],
                'required': [
                    'end_date',
                    'start_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'end_date':
                        (str,),
                    'start_date':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'count':
                        (str,),
                    'offset':
                        (int,),
                    'stat_name':
                        (str,),
                },
                'attribute_map': {
                    'end_date': 'endDate',
                    'start_date': 'startDate',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'count': 'count',
                    'offset': 'offset',
                    'stat_name': 'statName',
                },
                'location_map': {
                    'end_date': 'query',
                    'start_date': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'count': 'query',
                    'offset': 'query',
                    'stat_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_anomalies_top_nodes_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1AnomaliesTopNodesGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/anomalies/topNodes',
                'operation_id': 'nexus_insights_api_v1_anomalies_top_nodes_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'site_group_name',
                    'site_name',
                    'node_name',
                    'filter',
                    'offset',
                    'count',
                    'stat_name',
                    'level',
                    'aggr',
                    'granularity',
                    'response_by_create_time',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'level',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('level',): {

                        "FABRIC": "fabric",
                        "NODE": "node",
                        "NONE": "None"
                    },
                },
                'openapi_types': {
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'node_name':
                        (str,),
                    'filter':
                        (str,),
                    'offset':
                        (int,),
                    'count':
                        (int,),
                    'stat_name':
                        (str,),
                    'level':
                        (str,),
                    'aggr':
                        (str,),
                    'granularity':
                        (str,),
                    'response_by_create_time':
                        (bool,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'node_name': 'nodeName',
                    'filter': 'filter',
                    'offset': 'offset',
                    'count': 'count',
                    'stat_name': 'statName',
                    'level': 'level',
                    'aggr': 'aggr',
                    'granularity': 'granularity',
                    'response_by_create_time': 'responseByCreateTime',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'node_name': 'query',
                    'filter': 'query',
                    'offset': 'query',
                    'count': 'query',
                    'stat_name': 'query',
                    'level': 'query',
                    'aggr': 'query',
                    'granularity': 'query',
                    'response_by_create_time': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_anomalies_trend_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1AnomaliesTrendGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/anomalies/trend',
                'operation_id': 'nexus_insights_api_v1_anomalies_trend_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                    'site_name',
                    'trend_interval',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'trend_interval':
                        (str,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'trend_interval': 'trendInterval',
                },
                'location_map': {
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'trend_interval': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def nexus_insights_api_v1_alerts_trend_get(
        self,
        **kwargs
    ):
        """Get the number of anomalies for past one week  # noqa: E501

        Given an insightsGroup or Fabric, return the number of anomalies on every day of the week  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_alerts_trend_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            site_group_name (str): Name of the site group - limit the records pertaining to this site group. [optional]
            site_name (str): Name of the site - limit the records pertaining to this site. [optional]
            trend_interval (str): [optional]
            start_ts (str): [optional]
            end_ts (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1AlertsTrendGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_alerts_trend_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_anomalies_buckets_get(
        self,
        **kwargs
    ):
        """Return the anomalies buckets  # noqa: E501

        Returning anomalies buckets  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_anomalies_buckets_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            granularity (str): Granularity of the timeseries data w.r.t duration. [optional]
            end_date (str): End date, to collect the records generated till specified date. [optional]
            start_date (str): Start date, to skip records generated earlier to this date. [optional]
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1AnomaliesBucketsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_anomalies_buckets_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_anomalies_details_get(
        self,
        **kwargs
    ):
        """Get Anomalies details list  # noqa: E501

        Get the list of anomalies for a given IG or site  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_anomalies_details_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            filter (str): Lucene format filter - Filter the response based on this filter field. [optional]
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            node_name (str): Name of the fabric node, limit the anomaly score to given nodeName. [optional] if omitted the server will use the default value of "None"
            offset (str): Pagination index into response.. [optional]
            count (str): Num of nodes in response.. [optional]
            end_date (str): End date, to collect the records generated till specified date. [optional]
            sort (str): Sort the reponse by which attribute and which order.. [optional]
            start_date (str): Start date, to skip records generated earlier to this date. [optional]
            aggr (str): Aggregate records by this field. [optional]
            site_status (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1AnomaliesDetailsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_anomalies_details_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_anomalies_related_metrics_get(
        self,
        **kwargs
    ):
        """Get the list of default resources  # noqa: E501

        defaultDescription  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_anomalies_related_metrics_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            anomaly_id (str): Identifier for the anomaly. [optional]
            user_name (str): User name. [optional]
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            resource_list (str): Comma separated list of tuples specifying the resources to be applied for POST request.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1AnomaliesRelatedMetricsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_anomalies_related_metrics_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_anomalies_related_metrics_post(
        self,
        **kwargs
    ):
        """Get the list of default resources  # noqa: E501

        defaultDescription  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_anomalies_related_metrics_post(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            anomaly_id (str): Identifier for the anomaly. [optional]
            user_name (str): User name. [optional]
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            resource_list (str): Comma separated list of tuples specifying the resources to be applied for POST request.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1AnomaliesRelatedMetricsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_anomalies_related_metrics_post_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_anomalies_related_objects_get(
        self,
        **kwargs
    ):
        """Get the list of related objects  # noqa: E501

        Get the list of related objects  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_anomalies_related_objects_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            end_date (str): End date, to collect the records generated till specified date. [optional]
            start_date (str): Start date, to skip records generated earlier to this date. [optional]
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            anomaly_id (str): Identifier for the anomaly. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1AnomaliesRelatedObjectsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_anomalies_related_objects_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_anomalies_summary_get(
        self,
        **kwargs
    ):
        """Get the summary of anomalies  # noqa: E501

        Given an insightsGroup or Fabric, return the summary of anomalies  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_anomalies_summary_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            site_name (str): Name of the fabric - limit the records pertaining to this fabricName. [optional]
            node_name (str): Name of the fabric node, limit the anomaly score to given nodeName. [optional] if omitted the server will use the default value of "None"
            filter (str): Lucene format filter. [optional] if omitted the server will use the default value of "None"
            end_date (str): End date, to collect the records generated till specified date. [optional]
            start_date (str): Start date, to skip records generated earlier to this date. [optional]
            aggr (str): Aggregate records by this field. [optional]
            site_status (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1AnomaliesSummaryGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_anomalies_summary_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_anomalies_time_range_trend_get(
        self,
        **kwargs
    ):
        """Get the number of anomalies for past one week  # noqa: E501

        Given an insightsGroup or Fabric, return the number of anomalies on every day of the week  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_anomalies_time_range_trend_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            site_group_name (str): Name of the site group - limit the records pertaining to this site group. [optional]
            site_name (str): Name of the site - limit the records pertaining to this site. [optional]
            trend_interval (str): [optional]
            num_past_intervals (int): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1AnomaliesTimeRangeTrendGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_anomalies_time_range_trend_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_anomalies_top_fabrics_get(
        self,
        **kwargs
    ):
        """Get Top Fabrics based on Anomaly Score  # noqa: E501

        Get Top Fabrics along with Anomaly Score and Anomaly Count  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_anomalies_top_fabrics_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-1h"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            site_group_name (str): Name of the Site Group, limit the records to this site group. [optional] if omitted the server will use the default value of "None"
            count (int): Limits the number of entries in the response. [optional] if omitted the server will use the default value of 10
            offset (int): Pagination index into response.. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1AnomaliesTopFabricsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_anomalies_top_fabrics_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_anomalies_top_flow_records_get(
        self,
        end_date="now",
        start_date="now-15m",
        **kwargs
    ):
        """Get top flow records by anomalies  # noqa: E501

        Get top flow records by anomalies  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_anomalies_top_flow_records_get(end_date="now", start_date="now-15m", async_req=True)
        >>> result = thread.get()

        Args:
            end_date (str): End date, to collect the records generated till specified date. defaults to "now", must be one of ["now"]
            start_date (str): Start date, to skip records generated earlier to this date. defaults to "now-15m", must be one of ["now-15m"]

        Keyword Args:
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            node_name (str): Name of the fabric node, limit the anomaly score to given nodeName. [optional] if omitted the server will use the default value of "None"
            count (str): Num of nodes in response.. [optional]
            stat_name (str): The statName to get the top nodes by.. [optional]
            filter (str): Lucene format filter - Filter the response based on this filter field. [optional]
            granularity (str): Granularity of the timeseries data w.r.t duration. [optional]
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1AnomaliesTopFlowRecordsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['end_date'] = \
            end_date
        kwargs['start_date'] = \
            start_date
        return self.nexus_insights_api_v1_anomalies_top_flow_records_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_anomalies_top_flows_get(
        self,
        end_date="now",
        start_date="now-15m",
        **kwargs
    ):
        """Get the top flows by anomalies  # noqa: E501

        Get the top flows by anomalies  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_anomalies_top_flows_get(end_date="now", start_date="now-15m", async_req=True)
        >>> result = thread.get()

        Args:
            end_date (str): End date, to collect the records generated till specified date. defaults to "now", must be one of ["now"]
            start_date (str): Start date, to skip records generated earlier to this date. defaults to "now-15m", must be one of ["now-15m"]

        Keyword Args:
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            count (str): Limit the number of records in the response. [optional]
            offset (int): Pagination index into response.. [optional] if omitted the server will use the default value of 0
            stat_name (str): Limit statistics in the response. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1AnomaliesTopFlowsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['end_date'] = \
            end_date
        kwargs['start_date'] = \
            start_date
        return self.nexus_insights_api_v1_anomalies_top_flows_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_anomalies_top_nodes_get(
        self,
        **kwargs
    ):
        """Get top nodes list based on anomaly score  # noqa: E501

        Get the list of the fabric wide top nodes based on anomaly scores  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_anomalies_top_nodes_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-1h"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            site_group_name (str): Name of the Site Group, limit the records to this site group. [optional] if omitted the server will use the default value of "None"
            site_name (str): Name of the Site, limit the records pertaining to this siteName. [optional] if omitted the server will use the default value of "None"
            node_name (str): Name of the Fabric node, limit the anomaly score to given nodeName. [optional] if omitted the server will use the default value of "None"
            filter (str): Lucene format filter. [optional] if omitted the server will use the default value of "None"
            offset (int): Offset from which records are returned. [optional] if omitted the server will use the default value of 0
            count (int): Limits the number of nodes in response. [optional] if omitted the server will use the default value of 10
            stat_name (str): Type of the stats, either of {cpu, memory, queue}. [optional] if omitted the server will use the default value of "None"
            level (str): Level at which records are to be returned like \"fabric\", \"node\". [optional] if omitted the server will use the default value of "None"
            aggr (str): default value: \"severity\". [optional] if omitted the server will use the default value of "severity"
            granularity (str): Granularity of the values w.r.t duration. [optional] if omitted the server will use the default value of "5m"
            response_by_create_time (bool): Sort records in response by create time. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1AnomaliesTopNodesGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_anomalies_top_nodes_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_anomalies_trend_get(
        self,
        **kwargs
    ):
        """Get the trend of anomalies  # noqa: E501

        Given an insightsGroup or Fabric, return the trend of anomalies  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_anomalies_trend_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            site_group_name (str): Name of the site group - limit the records pertaining to this site group. [optional]
            site_name (str): Name of the site - limit the records pertaining to this site. [optional]
            trend_interval (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1AnomaliesTrendGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_anomalies_trend_get_endpoint.call_with_http_info(**kwargs)

