"""
    Cisco Nexus Cloud API

    Cisco Nexus Cloud API is a programmatic interface that uses the REST architecture to provide access to the Nexus Cloud functionality.  # noqa: E501

    The version of the OpenAPI document: 1.0.9
    Contact: nexuscloud@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from nexuscloud_client.api_client import ApiClient, Endpoint as _Endpoint
from nexuscloud_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from nexuscloud_client.model.nexus_insights_api_v1_advisories_details_get200_response import NexusInsightsApiV1AdvisoriesDetailsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_advisories_details_get401_response import NexusInsightsApiV1AdvisoriesDetailsGet401Response
from nexuscloud_client.model.nexus_insights_api_v1_advisories_summary_get200_response import NexusInsightsApiV1AdvisoriesSummaryGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_advisories_top_fabrics_get200_response import NexusInsightsApiV1AdvisoriesTopFabricsGet200Response


class AdvisoriesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.nexus_insights_api_v1_advisories_details_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1AdvisoriesDetailsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/advisories/details',
                'operation_id': 'nexus_insights_api_v1_advisories_details_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'site_group_name',
                    'site_name',
                    'node_name',
                    'offset',
                    'count',
                    'end_date',
                    'sort',
                    'start_date',
                    'site_status',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'site_status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('site_status',): {

                        "ALL": "all",
                        "ONLINE": "online",
                        "OFFLINE": "offline"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'node_name':
                        (str,),
                    'offset':
                        (str,),
                    'count':
                        (str,),
                    'end_date':
                        (str,),
                    'sort':
                        (str,),
                    'start_date':
                        (str,),
                    'site_status':
                        (str,),
                },
                'attribute_map': {
                    'filter': 'filter',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'node_name': 'nodeName',
                    'offset': 'offset',
                    'count': 'count',
                    'end_date': 'endDate',
                    'sort': 'sort',
                    'start_date': 'startDate',
                    'site_status': 'siteStatus',
                },
                'location_map': {
                    'filter': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'node_name': 'query',
                    'offset': 'query',
                    'count': 'query',
                    'end_date': 'query',
                    'sort': 'query',
                    'start_date': 'query',
                    'site_status': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_advisories_summary_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1AdvisoriesSummaryGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/advisories/summary',
                'operation_id': 'nexus_insights_api_v1_advisories_summary_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'site_group_name',
                    'site_name',
                    'node_name',
                    'end_date',
                    'start_date',
                    'aggr',
                    'site_status',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'site_status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('site_status',): {

                        "ALL": "all",
                        "ONLINE": "online",
                        "OFFLINE": "offline"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'node_name':
                        (str,),
                    'end_date':
                        (str,),
                    'start_date':
                        (str,),
                    'aggr':
                        (str,),
                    'site_status':
                        (str,),
                },
                'attribute_map': {
                    'filter': 'filter',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'node_name': 'nodeName',
                    'end_date': 'endDate',
                    'start_date': 'startDate',
                    'aggr': 'aggr',
                    'site_status': 'siteStatus',
                },
                'location_map': {
                    'filter': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'node_name': 'query',
                    'end_date': 'query',
                    'start_date': 'query',
                    'aggr': 'query',
                    'site_status': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_advisories_top_fabrics_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1AdvisoriesTopFabricsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/advisories/topFabrics',
                'operation_id': 'nexus_insights_api_v1_advisories_top_fabrics_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'site_group_name',
                    'count',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'site_group_name':
                        (str,),
                    'count':
                        (int,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'site_group_name': 'siteGroupName',
                    'count': 'count',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'site_group_name': 'query',
                    'count': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def nexus_insights_api_v1_advisories_details_get(
        self,
        **kwargs
    ):
        """Get the advisories  # noqa: E501

        Get the list of advisories for a given InsightsGroup or site  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_advisories_details_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            filter (str): Lucene format filter - Filter the response based on this filter field. [optional]
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            node_name (str): Name of the fabric node - limit the records to the nodeName. [optional]
            offset (str): Pagination index into response. [optional]
            count (str): Limits the number of entries in the response. [optional]
            end_date (str): End date, to collect the records generated till specified date. [optional]
            sort (str): Sort records in response by this field. [optional]
            start_date (str): Start date, to skip records generated earlier to this date. [optional]
            site_status (str): Status of the site. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1AdvisoriesDetailsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_advisories_details_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_advisories_summary_get(
        self,
        **kwargs
    ):
        """Get the summary of advisories  # noqa: E501

        Get the summary of advisories for a given InsightsGroup or site  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_advisories_summary_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            filter (str): Lucene format filter - Filter the response based on this filter field. [optional]
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            node_name (str): Name of the fabric node - limit the records to the nodeName. [optional]
            end_date (str): End date, to collect the records generated till specified date. [optional]
            start_date (str): Start date, to skip records generated earlier to this date. [optional]
            aggr (str): Aggregate records by this field. [optional]
            site_status (str): Status of the site. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1AdvisoriesSummaryGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_advisories_summary_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_advisories_top_fabrics_get(
        self,
        **kwargs
    ):
        """Get Top Fabrics based on Advisory Score  # noqa: E501

        Get Top Fabrics along with Advisory Score and Advisory Count  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_advisories_top_fabrics_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            start_date (str): Start timestamp, to skip records generated earlier to this timestamp. [optional] if omitted the server will use the default value of "now-1h"
            end_date (str): End timestamp, to collect the records generated till specified time. [optional] if omitted the server will use the default value of "now"
            site_group_name (str): Name of the Site Group, limit the records to this siteGroup. [optional] if omitted the server will use the default value of "None"
            count (int): Limits the number of entries in the response. [optional] if omitted the server will use the default value of 10
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1AdvisoriesTopFabricsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_advisories_top_fabrics_get_endpoint.call_with_http_info(**kwargs)

