# newscatcherapi-python-sdk
NewsCatcher is a data-as-a-service startup that has one main goal:
to build the largest database of structured news articles published online.
In other words, we're like Google for the news part of the web, which you can access as a source of data.

Some useful links:
- [How NewsCatcher Works](https://docs.newscatcherapi.com/knowledge-base/how-newscatcher-works)
- [GitHub for the Python SDK](https://github.com/NewscatcherAPI/newscatcherapi-sdk-python)


This Python package is automatically generated by [Konfig](https://konfigthis.com):

- API version: 1.0.1
- Package version: 4.2.0

## Requirements.

Python >=3.7

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install newscatcherapi-python-sdk==4.2.0
```
(you may need to run `pip` with root permission: `sudo pip install newscatcherapi-python-sdk==4.2.0`)

Then import the package:
```python
import newscatcherapi_client
```
## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from pprint import pprint
from newscatcherapi_client import Newscatcher

newscatcher = Newscatcher(
        # Defining the host is optional and defaults to https://api.newscatcherapi.com/v2
        # See configuration.py for a list of all supported configuration parameters.
        host = "https://api.newscatcherapi.com/v2",
    
        # Configure API key authorization: api_key
        api_key = 'YOUR_API_KEY'
    
        # Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
        # api_key_prefix = {'api_key': 'Bearer'}
)

# Get Latest News Articles
response = newscatcher.latest_headlines.get(
    query_params = {
        'lang': "en",
        'not_lang': "af",
        'countries': "US,CA",
        'not_countries': "US,CA",
        'topic': "business",
        'sources': "nytimes.com,theguardian.com",
        'not_sources': "wsj.com",
        'ranked_only': True,
        'page_size': 100,
        'page': 1,
    }
)
pprint(response)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.newscatcherapi.com/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*LatestHeadlinesApi* | [**get**](docs/apis/tags/LatestHeadlinesApi.md#get) | **get** /latest_headlines | Get Latest News Articles
*LatestHeadlinesApi* | [**post**](docs/apis/tags/LatestHeadlinesApi.md#post) | **post** /latest_headlines | Get Latest News Articles
*SearchApi* | [**get**](docs/apis/tags/SearchApi.md#get) | **get** /search | Search for specific news articles
*SearchApi* | [**post**](docs/apis/tags/SearchApi.md#post) | **post** /search | Search for specific news articles
*SourcesApi* | [**get**](docs/apis/tags/SourcesApi.md#get) | **get** /sources | Get top news sources supported by NewsCatcher.
*SourcesApi* | [**post**](docs/apis/tags/SourcesApi.md#post) | **post** /sources | Get top news sources supported by NewsCatcher.

## Documentation For Models

 - [Article](docs/models/Article.md)
 - [Countries](docs/models/Countries.md)
 - [Date](docs/models/Date.md)
 - [ErrorResponse](docs/models/ErrorResponse.md)
 - [ErrorStatus](docs/models/ErrorStatus.md)
 - [Lang](docs/models/Lang.md)
 - [LatestHeadlines](docs/models/LatestHeadlines.md)
 - [LatestHeadlinesUserInput](docs/models/LatestHeadlinesUserInput.md)
 - [Model200Response](docs/models/Model200Response.md)
 - [Model200ResponseLatest](docs/models/Model200ResponseLatest.md)
 - [Model200ResponseSources](docs/models/Model200ResponseSources.md)
 - [ModelList](docs/models/ModelList.md)
 - [NotSources](docs/models/NotSources.md)
 - [Page](docs/models/Page.md)
 - [PageSize](docs/models/PageSize.md)
 - [PublishDatePrecision](docs/models/PublishDatePrecision.md)
 - [Q](docs/models/Q.md)
 - [Rank](docs/models/Rank.md)
 - [RankedOnly](docs/models/RankedOnly.md)
 - [Search](docs/models/Search.md)
 - [SearchIn](docs/models/SearchIn.md)
 - [SearchUserInput](docs/models/SearchUserInput.md)
 - [SortBy](docs/models/SortBy.md)
 - [Sources](docs/models/Sources.md)
 - [SourcesQuery](docs/models/SourcesQuery.md)
 - [SourcesUserInput](docs/models/SourcesUserInput.md)
 - [SuccessStatus](docs/models/SuccessStatus.md)
 - [Topic](docs/models/Topic.md)
 - [When](docs/models/When.md)

## Documentation For Authorization

 Authentication schemes defined for the API:
## api_key

- **Type**: API key
- **API key parameter name**: x-api-key
- **Location**: HTTP header


