# coding: utf-8

"""
    NewsCatcher News API V2

    NewsCatcher is a data-as-a-service startup that has one main goal: to build the largest database of structured news articles published online. In other words, we're like Google for the news part of the web, which you can access as a source of data.  Some useful links: - [How NewsCatcher Works](https://docs.newscatcherapi.com/knowledge-base/how-newscatcher-works) - [GitHub for the Python SDK](https://github.com/NewscatcherAPI/newscatcherapi-sdk-python)   # noqa: E501

    The version of the OpenAPI document: 1.0.1
    Contact: team@newscatcherapi.com
    Generated by: https://konfigthis.com
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from newscatcherapi_client import schemas  # noqa: F401


class Model200ResponseLatest(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by Konfig.
    Ref: https://konfigthis.com

    Do not edit the class manually.
    """


    class MetaOapg:
        
        class properties:
        
            @staticmethod
            def status() -> typing.Type['SuccessStatus']:
                return SuccessStatus
            total_hits = schemas.IntSchema
            page = schemas.IntSchema
            total_pages = schemas.IntSchema
            page_size = schemas.IntSchema
        
            @staticmethod
            def articles() -> typing.Type['Article']:
                return Article
        
            @staticmethod
            def user_input() -> typing.Type['LatestHeadlinesUserInput']:
                return LatestHeadlinesUserInput
            __annotations__ = {
                "status": status,
                "total_hits": total_hits,
                "page": page,
                "total_pages": total_pages,
                "page_size": page_size,
                "articles": articles,
                "user_input": user_input,
            }
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["status"]) -> 'SuccessStatus': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["total_hits"]) -> MetaOapg.properties.total_hits: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["page"]) -> MetaOapg.properties.page: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["total_pages"]) -> MetaOapg.properties.total_pages: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["page_size"]) -> MetaOapg.properties.page_size: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["articles"]) -> 'Article': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["user_input"]) -> 'LatestHeadlinesUserInput': ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["status", "total_hits", "page", "total_pages", "page_size", "articles", "user_input", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["status"]) -> typing.Union['SuccessStatus', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["total_hits"]) -> typing.Union[MetaOapg.properties.total_hits, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["page"]) -> typing.Union[MetaOapg.properties.page, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["total_pages"]) -> typing.Union[MetaOapg.properties.total_pages, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["page_size"]) -> typing.Union[MetaOapg.properties.page_size, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["articles"]) -> typing.Union['Article', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["user_input"]) -> typing.Union['LatestHeadlinesUserInput', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["status", "total_hits", "page", "total_pages", "page_size", "articles", "user_input", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        status: typing.Union['SuccessStatus', schemas.Unset] = schemas.unset,
        total_hits: typing.Union[MetaOapg.properties.total_hits, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        page: typing.Union[MetaOapg.properties.page, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        total_pages: typing.Union[MetaOapg.properties.total_pages, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        page_size: typing.Union[MetaOapg.properties.page_size, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        articles: typing.Union['Article', schemas.Unset] = schemas.unset,
        user_input: typing.Union['LatestHeadlinesUserInput', schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'Model200ResponseLatest':
        return super().__new__(
            cls,
            *args,
            status=status,
            total_hits=total_hits,
            page=page,
            total_pages=total_pages,
            page_size=page_size,
            articles=articles,
            user_input=user_input,
            _configuration=_configuration,
            **kwargs,
        )

from newscatcherapi_client.model.article import Article
from newscatcherapi_client.model.latest_headlines_user_input import LatestHeadlinesUserInput
from newscatcherapi_client.model.success_status import SuccessStatus
