# coding: utf-8
"""
    NewsCatcher News API V2

    NewsCatcher is a data-as-a-service startup that has one main goal: to build the largest database of structured news articles published online. In other words, we're like Google for the news part of the web, which you can access as a source of data.  Some useful links: - [How NewsCatcher Works](https://docs.newscatcherapi.com/knowledge-base/how-newscatcher-works) - [GitHub for the Python SDK](https://github.com/NewscatcherAPI/newscatcherapi-sdk-python)   # noqa: E501

    The version of the OpenAPI document: 1.0.1
    Contact: team@newscatcherapi.com
    Generated by: https://konfigthis.com
"""

from newscatcherapi_client.configuration import Configuration
from newscatcherapi_client.api_client import ApiClient
from newscatcherapi_client.apis.tags.latest_headlines_api import LatestHeadlinesApi
from newscatcherapi_client.apis.tags.search_api import SearchApi
from newscatcherapi_client.apis.tags.sources_api import SourcesApi


class Newscatcher:

    def __init__(self, configuration: Configuration = None, **kwargs):
        if (len(kwargs) > 0):
            configuration = Configuration(**kwargs)
        if (configuration is None):
            raise Exception("configuration is required")
        api_client = ApiClient(configuration)
        self.latest_headlines = LatestHeadlinesApi(api_client)
        self.search = SearchApi(api_client)
        self.sources = SourcesApi(api_client)
