import typing_extensions

from newscatcherapi_client.apis.tags import TagValues
from newscatcherapi_client.apis.tags.search_api import SearchApi
from newscatcherapi_client.apis.tags.latest_headlines_api import LatestHeadlinesApi
from newscatcherapi_client.apis.tags.sources_api import SourcesApi

TagToApi = typing_extensions.TypedDict(
    'TagToApi',
    {
        TagValues.SEARCH: SearchApi,
        TagValues.LATEST_HEADLINES: LatestHeadlinesApi,
        TagValues.SOURCES: SourcesApi,
    }
)

tag_to_api = TagToApi(
    {
        TagValues.SEARCH: SearchApi,
        TagValues.LATEST_HEADLINES: LatestHeadlinesApi,
        TagValues.SOURCES: SourcesApi,
    }
)
