# newscatcherapi-python-sdk
NewsCatcher is a data-as-a-service startup that has one main goal:
to build the largest database of structured news articles published online.
In other words, we're like Google for the news part of the web, which you can access as a source of data.

Some useful links:
- [How NewsCatcher Works](https://docs.newscatcherapi.com/knowledge-base/how-newscatcher-works)
- [GitHub for the Python SDK](https://github.com/NewscatcherAPI/newscatcherapi-sdk-python)


This Python package is automatically generated by the [Konfig](https://konfigthis.com):

- API version: 1.0.1
- Package version: 2.1.0

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/konfig-dev/newscatcher-sdks/tree/main/python.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/konfig-dev/newscatcher-sdks/tree/main/python.git`)

Then import the package:
```python
import newscatcherapi_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import newscatcherapi_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import newscatcherapi_client
from pprint import pprint
from newscatcherapi_client.api import latest_headlines_api
from newscatcherapi_client.model.error_response import ErrorResponse
from newscatcherapi_client.model.latest_headlines import LatestHeadlines
from newscatcherapi_client.model.model200_response_latest import Model200ResponseLatest
from newscatcherapi_client.model.page import Page
from newscatcherapi_client.model.page_size import PageSize
from newscatcherapi_client.model.topic import Topic
# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: api_key
configuration = newscatcherapi_client.Configuration(api_key={'api_key': 'YOUR_API_KEY'})

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['api_key'] = 'Bearer'


# Enter a context with an instance of the API client
with newscatcherapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = latest_headlines_api.LatestHeadlinesApi(api_client)
    lang = "en" # str | Specifies the languages of the search. For example: `en`. The only accepted format is [ISO 639-1 — 2](https://en.wikipedia.org/wiki/ISO_639-1) letter code.  (optional)
    not_lang = "af" # str | Inverse to the `lang` parameter  (optional)
    countries = "US,CA" # str | Countries where the news publisher is located. **Important**: This parameter is not responsible for the countries mentioned in the news article. One or multiple countries can be used in the search. The only acceptable format is [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) For example, `US,CA,MX` or just `US`  (optional)
    not_countries = "US,CA" # str | The inverse of the `countries` parameter.  (optional)
    topic = Topic("business") # Topic | Accepted values: `news`, `sport`, `tech`, `world`, `finance`, `politics`, `business`, `economics`, `entertainment`, `beauty`, `travel`, `music`, `food`, `science`, `gaming` The topic to which you want to restrict the articles of your choice. Not all news articles are assigned with a topic, therefore, we cannot guarantee that 100% of topics talking about technology will be assigned a tech label.  (optional)
    sources = "nytimes.com,theguardian.com" # str | One or more news resources to filter your search. It should be the normal form of the URL, For example: `nytimes.com,theguardian.com`  (optional)
    not_sources = "wsj.com" # str | One or more sources to be excluded from the search. Comma-separated list. For example: `nytimes.com,cnn.com,wsj.com`  (optional)
    ranked_only = True # bool | Default: `True` Limit the search only for the sources which are in the top 1 million online websites. Unranked sources are assigned a rank that equals `999999`  (optional)
    page_size = PageSize(100) # PageSize | `[1:100]` How many articles to return per page.  (optional)
    page = Page(1) # Page | The number of the page. Use it to scroll through the results. This parameter is used to paginate: scroll through results because one API response cannot return more than 100 articles.  (optional)

    try:
        # Get Latest News Articles
        api_response = api_instance.get(lang=lang, not_lang=not_lang, countries=countries, not_countries=not_countries, topic=topic, sources=sources, not_sources=not_sources, ranked_only=ranked_only, page_size=page_size, page=page)
        pprint(api_response)
    except newscatcherapi_client.ApiException as e:
        print("Exception when calling LatestHeadlinesApi->get: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.newscatcherapi.com/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*LatestHeadlinesApi* | [**get**](docs/LatestHeadlinesApi.md#get) | **GET** /latest_headlines | Get Latest News Articles
*LatestHeadlinesApi* | [**post**](docs/LatestHeadlinesApi.md#post) | **POST** /latest_headlines | Get Latest News Articles
*SearchApi* | [**get**](docs/SearchApi.md#get) | **GET** /search | Search for specific news articles
*SearchApi* | [**post**](docs/SearchApi.md#post) | **POST** /search | Search for specific news articles
*SourcesApi* | [**get**](docs/SourcesApi.md#get) | **GET** /sources | Get top news sources supported by NewsCatcher.
*SourcesApi* | [**post**](docs/SourcesApi.md#post) | **POST** /sources | Get top news sources supported by NewsCatcher.


## Documentation For Models

 - [Article](docs/Article.md)
 - [ArticleInner](docs/ArticleInner.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [ErrorStatus](docs/ErrorStatus.md)
 - [Lang](docs/Lang.md)
 - [LatestHeadlines](docs/LatestHeadlines.md)
 - [LatestHeadlinesUserInput](docs/LatestHeadlinesUserInput.md)
 - [List](docs/List.md)
 - [Model200Response](docs/Model200Response.md)
 - [Model200ResponseLatest](docs/Model200ResponseLatest.md)
 - [Model200ResponseSources](docs/Model200ResponseSources.md)
 - [Page](docs/Page.md)
 - [PageSize](docs/PageSize.md)
 - [PublishDatePrecision](docs/PublishDatePrecision.md)
 - [Rank](docs/Rank.md)
 - [Search](docs/Search.md)
 - [SearchIn](docs/SearchIn.md)
 - [SearchUserInput](docs/SearchUserInput.md)
 - [SortBy](docs/SortBy.md)
 - [SourcesQuery](docs/SourcesQuery.md)
 - [SourcesUserInput](docs/SourcesUserInput.md)
 - [SuccessStatus](docs/SuccessStatus.md)
 - [Topic](docs/Topic.md)


## Documentation For Authorization


## api_key

- **Type**: API key
- **API key parameter name**: x-api-key
- **Location**: HTTP header


## Author

team@newscatcherapi.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in newscatcherapi_client.apis and newscatcherapi_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from newscatcherapi_client.api.default_api import DefaultApi`
- `from newscatcherapi_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import newscatcherapi_client
from newscatcherapi_client.apis import *
from newscatcherapi_client.models import *
```

