"""
    NewsCatcher News API V2

    NewsCatcher is a data-as-a-service startup that has one main goal: to build the largest database of structured news articles published online. In other words, we're like Google for the news part of the web, which you can access as a source of data.  Some useful links: - [How NewsCatcher Works](https://docs.newscatcherapi.com/knowledge-base/how-newscatcher-works) - [GitHub for the Python SDK](https://github.com/NewscatcherAPI/newscatcherapi-sdk-python)   # noqa: E501

    The version of the OpenAPI document: 1.0.1
    Contact: team@newscatcherapi.com
    Generated by: https://konfigthis.com
"""


import re  # noqa: F401
import sys  # noqa: F401

from newscatcherapi_client.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from newscatcherapi_client.exceptions import ApiAttributeError



class Search(ModelNormal):
    """NOTE: This class is auto generated by Konfig.
    Ref: https://konfigthis.com

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('lang',): {
            'AF': "af",
            'AR': "ar",
            'BG': "bg",
            'BN': "bn",
            'CA': "ca",
            'CN': "cn",
            'CS': "cs",
            'CY': "cy",
            'DA': "da",
            'DE': "de",
            'EL': "el",
            'EN': "en",
            'ES': "es",
            'ET': "et",
            'FA': "fa",
            'FI': "fi",
            'FR': "fr",
            'GU': "gu",
            'HE': "he",
            'HI': "hi",
            'HR': "hr",
            'HU': "hu",
            'ID': "id",
            'IT': "it",
            'JA': "ja",
            'KN': "kn",
            'KO': "ko",
            'LT': "lt",
            'LV': "lv",
            'MK': "mk",
            'ML': "ml",
            'MR': "mr",
            'NE': "ne",
            'NL': "nl",
            'FALSE': "false",
            'PA': "pa",
            'PL': "pl",
            'PT': "pt",
            'RO': "ro",
            'RU': "ru",
            'SK': "sk",
            'SL': "sl",
            'SO': "so",
            'SQ': "sq",
            'SV': "sv",
            'SW': "sw",
            'TA': "ta",
            'TE': "te",
            'TH': "th",
            'TL': "tl",
            'TR': "tr",
            'TW': "tw",
            'UK': "uk",
            'UR': "ur",
            'VI': "vi",
        },
        ('not_lang',): {
            'AF': "af",
            'AR': "ar",
            'BG': "bg",
            'BN': "bn",
            'CA': "ca",
            'CN': "cn",
            'CS': "cs",
            'CY': "cy",
            'DA': "da",
            'DE': "de",
            'EL': "el",
            'EN': "en",
            'ES': "es",
            'ET': "et",
            'FA': "fa",
            'FI': "fi",
            'FR': "fr",
            'GU': "gu",
            'HE': "he",
            'HI': "hi",
            'HR': "hr",
            'HU': "hu",
            'ID': "id",
            'IT': "it",
            'JA': "ja",
            'KN': "kn",
            'KO': "ko",
            'LT': "lt",
            'LV': "lv",
            'MK': "mk",
            'ML': "ml",
            'MR': "mr",
            'NE': "ne",
            'NL': "nl",
            'FALSE': "false",
            'PA': "pa",
            'PL': "pl",
            'PT': "pt",
            'RO': "ro",
            'RU': "ru",
            'SK': "sk",
            'SL': "sl",
            'SO': "so",
            'SQ': "sq",
            'SV': "sv",
            'SW': "sw",
            'TA': "ta",
            'TE': "te",
            'TH': "th",
            'TL': "tl",
            'TR': "tr",
            'TW': "tw",
            'UK': "uk",
            'UR': "ur",
            'VI': "vi",
        },
        ('published_date_precision',): {
            'FULL': "full",
            'TIMEZONE_UNKNOWN': "timezone unknown",
            'DATE': "date",
        },
        ('search_in',): {
            'TITLE': "title",
            'SUMMARY': "summary",
            'TITLE_SUMMARY': "title_summary",
        },
        ('topic',): {
            'NEWS': "news",
            'SPORT': "sport",
            'TECH': "tech",
            'WORLD': "world",
            'FINANCE': "finance",
            'POLITICS': "politics",
            'BUSINESS': "business",
            'ECONOMICS': "economics",
            'ENTERTAINMENT': "entertainment",
            'BEAUTY': "beauty",
            'TRAVEL': "travel",
            'MUSIC': "music",
            'FOOD': "food",
            'SCIENCE': "science",
            'GAMING': "gaming",
        },
        ('sort_by',): {
            'RELEVANCY': "relevancy",
            'DATE': "date",
            'RANK': "rank",
        },
    }

    validations = {
        ('page_size',): {
            'inclusive_maximum': 100,
            'inclusive_minimum': 1,
        },
        ('page',): {
            'inclusive_minimum': 1,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'q': (str,),  # noqa: E501
            'lang': (str,),  # noqa: E501
            'not_lang': (str,),  # noqa: E501
            'published_date_precision': (str,),  # noqa: E501
            '_from': (str,),  # noqa: E501
            'to': (str,),  # noqa: E501
            'search_in': (str,),  # noqa: E501
            'countries': (str,),  # noqa: E501
            'not_countries': (str,),  # noqa: E501
            'topic': (str,),  # noqa: E501
            'sources': (str,),  # noqa: E501
            'not_sources': (str,),  # noqa: E501
            'ranked_only': (bool,),  # noqa: E501
            'sort_by': (str,),  # noqa: E501
            'page_size': (int,),  # noqa: E501
            'page': (int,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'q': 'q',  # noqa: E501
        'lang': 'lang',  # noqa: E501
        'not_lang': 'not_lang',  # noqa: E501
        'published_date_precision': 'published_date_precision',  # noqa: E501
        '_from': 'from',  # noqa: E501
        'to': 'to',  # noqa: E501
        'search_in': 'search_in',  # noqa: E501
        'countries': 'countries',  # noqa: E501
        'not_countries': 'not_countries',  # noqa: E501
        'topic': 'topic',  # noqa: E501
        'sources': 'sources',  # noqa: E501
        'not_sources': 'not_sources',  # noqa: E501
        'ranked_only': 'ranked_only',  # noqa: E501
        'sort_by': 'sort_by',  # noqa: E501
        'page_size': 'page_size',  # noqa: E501
        'page': 'page',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """Search - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            q (str): Keyword/keywords you're searching for. This is the most important part of your query. Please, refer to the **Advanced Query Parameter** section of the docs for more examples and explanations.. [optional]  # noqa: E501
            lang (str): The language you want to search in.. [optional]  # noqa: E501
            not_lang (str): Inverse to the lang parameter.. [optional]  # noqa: E501
            published_date_precision (str): Precision of the publication date.. [optional]  # noqa: E501
            _from (str): YYYY/mm/dd From which point in time to start the search. The default timezone is UTC.  Defaults to the past week.. [optional]  # noqa: E501
            to (str): YYYY/mm/dd Until which point in time to search for. The default timezone is UTC.. [optional]  # noqa: E501
            search_in (str): [optional]  # noqa: E501
            countries (str): [optional]  # noqa: E501
            not_countries (str): [optional]  # noqa: E501
            topic (str): [optional]  # noqa: E501
            sources (str): [optional]  # noqa: E501
            not_sources (str): [optional]  # noqa: E501
            ranked_only (bool): [optional]  # noqa: E501
            sort_by (str): [optional]  # noqa: E501
            page_size (int): [optional]  # noqa: E501
            page (int): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """Search - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            q (str): Keyword/keywords you're searching for. This is the most important part of your query. Please, refer to the **Advanced Query Parameter** section of the docs for more examples and explanations.. [optional]  # noqa: E501
            lang (str): The language you want to search in.. [optional]  # noqa: E501
            not_lang (str): Inverse to the lang parameter.. [optional]  # noqa: E501
            published_date_precision (str): Precision of the publication date.. [optional]  # noqa: E501
            _from (str): YYYY/mm/dd From which point in time to start the search. The default timezone is UTC.  Defaults to the past week.. [optional]  # noqa: E501
            to (str): YYYY/mm/dd Until which point in time to search for. The default timezone is UTC.. [optional]  # noqa: E501
            search_in (str): [optional]  # noqa: E501
            countries (str): [optional]  # noqa: E501
            not_countries (str): [optional]  # noqa: E501
            topic (str): [optional]  # noqa: E501
            sources (str): [optional]  # noqa: E501
            not_sources (str): [optional]  # noqa: E501
            ranked_only (bool): [optional]  # noqa: E501
            sort_by (str): [optional]  # noqa: E501
            page_size (int): [optional]  # noqa: E501
            page (int): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
