# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['neuralfields']

package_data = \
{'': ['*']}

install_requires = \
['dunamai>=1.15.0,<2.0.0', 'torch>=1.13.1,<2.0.0']

setup_kwargs = {
    'name': 'neuralfields',
    'version': '0.0.2',
    'description': 'A type of potential-based recurrent neural networks implemented with PyTorch',
    'long_description': "# Neural Fields &ndash; Old Idea, New Glory\n\n[![license][license-badge]][license]\n[![docs][docs-stable-badge]][docs-stable]\n[![docs][docs-latest-badge]][docs-latest]\n[![pre-commit][pre-commit-badge]][pre-commit]\n[![bandit][bandit-badge]][bandit-hp]\n[![isort][isort-badge]][isort-hp]\n[![black][black-badge]][black]\n[![ci][ci-badge]][ci]\n[![tests][tests-badge]][tests]\n[![coverage][coverage-badge]][coverage]\n\n## About\n\nIn 1977, Shun-ichi Amari introduced _neural fields_, a class of potential-based recurrent neural networks [1].\nThis architecture was developed as a simplistic model of the activity of neurons in a (human) brain.\nIt's main characteristic is the lateral in-/exhibition of neurons though their accumulated potential.\nDue to its simplicity and expressiveness, Amari’s work was highly influential and led to several follow-up papers such\nas [2, 3, 4, 5] to only name a few.\n\n## Citing\n\nIf you use code or ideas from this repository for your projects or research, **please cite and star** it.\nIt does not cost you anything, and would support me for putting in the effort of providing a clean state-of-the-art\nimplementation to you.\n\n```\n@misc{Muratore_neuralfields,\n  author = {Fabio Muratore},\n  title = {neuralfields - A type of potential-based recurrent neural networks implemented with PyTorch},\n  year = {2023},\n  publisher = {GitHub},\n  journal = {GitHub repository},\n  howpublished = {\\url{https://github.com/famura/neuralfields}}\n}\n```\n\n## Features\n\n* There are two variants of the neural fields implemented in this repository: one called `NeuralField` that matches\n  the model of Amari closely using 1D convolutions, as well as another one called `SimpleNeuralField` that replaces the\n  convolutions and introduces custom potential dynamics function.\n* Both implementations have by modern standards very few, i.e. typically less than 1000, parameters. I suggest that you\n  start with the `NeuralField` class since it is more expressive. However, the `SimpleNeuralField` has the benefit of\n  operating with typically less than 20 parameters, which allows you to use optimizers that otherwise might not scale.\n* Both model classes are subclasses of `torch.nn.Module`, hence able to process batched data and run on GPUs.\n* This repository is a spin-off from [SimuRLacra](https://github.com/famura/SimuRLacra) where the neural fields have\n  been used as the backbone for control policies. In `SimuRLacra`, the focus is on reinforcement learning for\n  sim-to-real transfer. However, the goal of this repository is to make the implementation **as general as possible**,\n  such that it could for example be used as generative model.\n\n## Getting Started\n\nTo install this package, simply run\n\n```sh\npip install neuralfields\n```\n\nFor further information, please have a look at the [getting started guide][docs-getting-started].\nIn the documentation, you can also find the [complete reference of the source code][docs-code-reference].\n\n---\n[1] Shun-ichi Amari. _Dynamics of pattern formation in lateral-inhibition type neural fields_. Biological Cybernetics, 27(2):77–87, 1977.<br />\n[2] K. Kishimoto and Shun-ichi Amari. _Existence and stability of local excitations in homogeneous neural fields_. Journal of Mathematical Biology, 7(4):303–318, 1979.<br />\n[3] Wolfram Erlhagen and Gregor Schöner. _Dynamic field theory of movement preparation_. Psychological Review, 109(3):545–572, 2002.<br />\n[4] Shun-ichi Amari, Hyeyoung Park, and Tomoko Ozeki. _Singularities affect dynamics of learning in neuromanifolds_. Neural Computation, 18(5):1007–1065, 2006.<br />\n[5] T. Luksch, M. Gineger, M. Mühlig, T. Yoshiike, _Adaptive Movement Sequences and Predictive Decisions based on Hierarchical Dynamical Systems_. International Conference on Intelligent Robots and Systems, 2012.\n\n\n<!-- URLs -->\n[bandit-badge]: https://img.shields.io/badge/security-bandit-green.svg\n[bandit-hp]: https://github.com/PyCQA/bandit\n[black-badge]: https://img.shields.io/badge/code%20style-black-000000.svg\n[black]: https://github.com/psf/black\n[ci-badge]: https://github.com/famura/neuralfields/actions/workflows/ci.yaml/badge.svg\n[ci]: https://github.com/famura/neuralfields/actions/workflows/ci.yaml\n[coverage-badge]: https://famura.github.io/neuralfields/latest/exported/coverage/badge.svg\n[coverage]: https://famura.github.io/neuralfields/latest/exported/coverage/report\n[docs-stable-badge]: https://img.shields.io/badge/docs-stable-informational\n[docs-latest-badge]: https://img.shields.io/badge/docs-latest-informational\n[docs-code-reference]: https://famura.github.io/neuralfields/stable/reference\n[docs-getting-started]: https://famura.github.io/neuralfields/stable/getting_started\n[docs-stable]: https://famura.github.io/neuralfields/stable\n[docs-latest]: https://famura.github.io/neuralfields/latest\n[isort-badge]: https://img.shields.io/badge/imports-isort-green\n[isort-hp]: https://pycqa.github.io/isort/\n[license-badge]: https://img.shields.io/badge/license-MIT--v4-informational\n[license]: https://github.com/famura/neuralfields/LICENSE.txt\n[pre-commit-badge]: https://img.shields.io/badge/pre--commit-enabled-green\n[pre-commit]: https://github.com/pre-commit/pre-commit\n[tests-badge]: https://famura.github.io/neuralfields/latest/exported/tests/badge.svg\n[tests]: https://famura.github.io/neuralfields/latest/exported/tests/report\n",
    'author': 'Fabio Muratore',
    'author_email': 'robot-learning@famura.net',
    'maintainer': 'Fabio Muratore',
    'maintainer_email': 'robot-learning@famura.net',
    'url': 'https://github.com/famura/neuralfields',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
