r"""
Copyright &copy; 2022 NetApp Inc.
All rights reserved.

This file has been automatically generated based on the ONTAP REST API documentation.


"""

from marshmallow import EXCLUDE, fields  # type: ignore
from netapp_ontap.resource import Resource, ResourceSchema, ResourceSchemaMeta, ImpreciseDateTime, Size


__all__ = ["ZappNvmeComponentsSubsystem", "ZappNvmeComponentsSubsystemSchema"]
__pdoc__ = {
    "ZappNvmeComponentsSubsystemSchema.resource": False,
    "ZappNvmeComponentsSubsystemSchema.opts": False,
    "ZappNvmeComponentsSubsystem": False,
}


class ZappNvmeComponentsSubsystemSchema(ResourceSchema, metaclass=ResourceSchemaMeta):
    """The fields of the ZappNvmeComponentsSubsystem object"""

    hosts = fields.List(fields.Nested("netapp_ontap.models.zapp_nvme_components_subsystem_hosts.ZappNvmeComponentsSubsystemHostsSchema", unknown=EXCLUDE), data_key="hosts")
    r""" The hosts field of the zapp_nvme_components_subsystem. """

    name = fields.Str(data_key="name")
    r""" The name of the subsystem accessing the component. If neither the name nor the UUID is provided, the name defaults to &lt;application-name&gt;_&lt;component-name&gt;, whether that subsystem already exists or not. """

    os_type = fields.Str(data_key="os_type")
    r""" The name of the host OS accessing the component. The default value is the host OS that is running the application.

Valid choices:

* aix
* linux
* vmware
* windows """

    uuid = fields.Str(data_key="uuid")
    r""" The UUID of an existing subsystem to be granted access to the component. Usage: &lt;UUID&gt; """

    @property
    def resource(self):
        return ZappNvmeComponentsSubsystem

    gettable_fields = [
        "hosts",
        "name",
        "os_type",
        "uuid",
    ]
    """hosts,name,os_type,uuid,"""

    patchable_fields = [
        "hosts",
        "name",
        "os_type",
        "uuid",
    ]
    """hosts,name,os_type,uuid,"""

    postable_fields = [
        "hosts",
        "name",
        "os_type",
        "uuid",
    ]
    """hosts,name,os_type,uuid,"""


class ZappNvmeComponentsSubsystem(Resource):

    _schema = ZappNvmeComponentsSubsystemSchema
