r"""
Copyright &copy; 2022 NetApp Inc.
All rights reserved.

This file has been automatically generated based on the ONTAP REST API documentation.


"""

from marshmallow import EXCLUDE, fields  # type: ignore
from netapp_ontap.resource import Resource, ResourceSchema, ResourceSchemaMeta, ImpreciseDateTime, Size


__all__ = ["S3Log", "S3LogSchema"]
__pdoc__ = {
    "S3LogSchema.resource": False,
    "S3LogSchema.opts": False,
    "S3Log": False,
}


class S3LogSchema(ResourceSchema, metaclass=ResourceSchemaMeta):
    """The fields of the S3Log object"""

    links = fields.Nested("netapp_ontap.models.self_link.SelfLinkSchema", unknown=EXCLUDE, data_key="_links")
    r""" The links field of the s3_log. """

    format = fields.Str(data_key="format")
    r""" Format in which the logs are generated by the consolidation process.
  Possible values are:

  * json  - ONTAP-specific Json log format.


Valid choices:

* json """

    retention = fields.Nested("netapp_ontap.models.s3_log_retention.S3LogRetentionSchema", unknown=EXCLUDE, data_key="retention")
    r""" The retention field of the s3_log. """

    rotation = fields.Nested("netapp_ontap.models.rotation.RotationSchema", unknown=EXCLUDE, data_key="rotation")
    r""" The rotation field of the s3_log. """

    @property
    def resource(self):
        return S3Log

    gettable_fields = [
        "links",
        "format",
        "retention",
        "rotation",
    ]
    """links,format,retention,rotation,"""

    patchable_fields = [
        "format",
        "retention",
        "rotation",
    ]
    """format,retention,rotation,"""

    postable_fields = [
        "format",
        "retention",
        "rotation",
    ]
    """format,retention,rotation,"""


class S3Log(Resource):

    _schema = S3LogSchema
