/*
 * Decompiled with CFR 0.152.
 */
package neqsim.util.database;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import neqsim.util.util.FileSystemSettings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NeqSimBlobDatabase
implements FileSystemSettings,
Serializable {
    private static final long serialVersionUID = 1000L;
    public static String dataBasePath = "";
    static Logger logger = LogManager.getLogger(NeqSimBlobDatabase.class);
    private static boolean createTemporaryTables = true;
    private static String dataBaseType = "";
    private static String connectionString = "";
    private static String username = "";
    private static String password = "";
    private Statement statement = null;
    protected Connection databaseConnection = null;

    public boolean createTemporaryTables() {
        return createTemporaryTables;
    }

    public void setCreateTemporaryTables(boolean createTemporaryTables) {
        NeqSimBlobDatabase.createTemporaryTables = createTemporaryTables;
    }

    public NeqSimBlobDatabase() {
        NeqSimBlobDatabase.setDataBaseType(dataBaseType);
        try {
            this.databaseConnection = this.openConnection();
            this.statement = this.databaseConnection.createStatement();
        }
        catch (Exception ex) {
            logger.error("SQLException " + ex.getMessage());
            throw new RuntimeException(ex);
        }
    }

    public Connection openConnection() throws SQLException, ClassNotFoundException {
        InitialContext ctx = null;
        DataSource ds = null;
        try {
            if (System.getenv("NEQSIMBLOBDB_CS") != null) {
                Connection connection = DriverManager.getConnection(System.getenv("NEQSIMBLOBDB_CS"), System.getenv("MYSQL_USER"), System.getenv("MYSQL_PASSWORD"));
                return connection;
            }
            if (dataBaseType.equals("MSAccess")) {
                String dir = "";
                dir = System.getProperty("NeqSim.home") == null ? "c:\\programming\\NeqSimSourceCode\\java\\neqsim" : System.getProperty("NeqSim.home");
                Connection e = DriverManager.getConnection("jdbc:odbc:DRIVER={Microsoft Access Driver (*.mdb)};DBQ=" + dir + "\\data\\NeqSimDatabase");
                return e;
            }
            if (dataBaseType.equals("H2") || dataBaseType.equals("H2RT")) {
                Connection dir = DriverManager.getConnection(connectionString, "sa", "");
                return dir;
            }
            if (dataBaseType.equals("MSAccessUCanAccess")) {
                Connection dir = DriverManager.getConnection(NeqSimBlobDatabase.getConnectionString());
                return dir;
            }
            if (dataBaseType.equals("mySQL") || dataBaseType.equals("mySQLNTNU") || dataBaseType.equals("Derby")) {
                Connection dir = DriverManager.getConnection(NeqSimBlobDatabase.getConnectionString(), username, password);
                return dir;
            }
            if (dataBaseType.equals("mySQLNeqSimWeb")) {
                ctx = new InitialContext();
                ds = (DataSource)ctx.lookup("java:comp/env/jdbc/NeqsimThermoDatabase");
                Connection dir = ds.getConnection();
                return dir;
            }
            Connection dir = DriverManager.getConnection(NeqSimBlobDatabase.getConnectionString(), username, password);
            return dir;
        }
        catch (Exception ex) {
            logger.error("error loading NeqSimDataBase... " + ex.toString());
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Exception e) {
                logger.error("error", (Throwable)e);
            }
        }
    }

    public Connection getConnection() {
        return this.databaseConnection;
    }

    public ResultSet getResultSet(String sqlString) {
        try {
            ResultSet result = this.getStatement().executeQuery(sqlString);
            return result;
        }
        catch (Exception e) {
            logger.error("error loading NeqSimbataBase " + e.toString());
            throw new RuntimeException(e);
        }
    }

    public void execute(String sqlString) {
        try {
            if (this.databaseConnection == null) {
                this.databaseConnection = this.openConnection();
                this.setStatement(this.databaseConnection.createStatement());
            }
            this.getStatement().execute(sqlString);
        }
        catch (Exception e) {
            logger.error("error in NeqSimDataBase " + e.toString(), (Throwable)e);
            logger.error("The database must be rgistered on the local DBMS to work.");
            throw new RuntimeException(e);
        }
    }

    public static String getDataBaseType() {
        return dataBaseType;
    }

    public static void setDataBaseType(String aDataBaseType) {
        NeqSimBlobDatabase.setDataBaseType(aDataBaseType, null);
    }

    public static void setDataBaseType(String aDataBaseType, String connectionString) {
        dataBaseType = aDataBaseType;
        if (connectionString != null) {
            NeqSimBlobDatabase.connectionString = connectionString;
        }
        try {
            if (dataBaseType.equals("mySQL")) {
                Class.forName("com.mysql.cj.jdbc.Driver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            }
        }
        catch (Exception ex) {
            logger.error("error loading database driver.. " + ex.toString());
            throw new RuntimeException(ex);
        }
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public static void setUsername(String aUsername) {
        username = aUsername;
    }

    public static void setPassword(String aPassword) {
        password = aPassword;
    }

    public static String getConnectionString() {
        return connectionString;
    }

    public static void setConnectionString(String aConnectionString) {
        connectionString = aConnectionString;
    }
}

