/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.phaseEnvelopeOps.multicomponentEnvelopeOps;

import java.text.DecimalFormat;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import neqsim.dataPresentation.JFreeChart.graph2b;
import neqsim.dataPresentation.fileHandeling.createNetCDF.netCDF2D.NetCdf2D;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.BaseOperation;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import neqsim.thermodynamicOperations.phaseEnvelopeOps.multicomponentEnvelopeOps.sysNewtonRhapsonPhaseEnvelope;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.chart.JFreeChart;

public class pTphaseEnvelope
extends BaseOperation {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(pTphaseEnvelope.class);
    double maxPressure = 1000.0;
    double minPressure = 1.0;
    double[][] copiedPoints = null;
    graph2b graph2 = null;
    SystemInterface system;
    boolean bubblePointFirst = true;
    boolean hascopiedPoints = false;
    double[] cricondenTherm = new double[3];
    double[] cricondenBar = new double[3];
    double[] cricondenThermX = new double[100];
    double[] cricondenThermY = new double[100];
    double[] cricondenBarX = new double[100];
    double[] cricondenBarY = new double[100];
    double phaseFraction = 1.0E-10;
    NetCdf2D file1;
    NetCdf2D file2;
    int i;
    int j = 0;
    int nummer = 0;
    int iterations = 0;
    int maxNumberOfIterations = 10000;
    double gibbsEnergy = 0.0;
    double gibbsEnergyOld = 0.0;
    double Kold;
    double deviation = 0.0;
    double g0 = 0.0;
    double g1 = 0.0;
    double lowPres = 1.0;
    double[] lnOldOldK;
    double[] lnK;
    boolean outputToFile = false;
    double[] lnOldK;
    double[] lnKwil;
    double[] oldDeltalnK;
    double[] deltalnK;
    double[] tm = new double[]{1.0, 1.0};
    double beta = 1.0E-5;
    int lowestGibbsEnergyPhase = 0;
    JProgressBar monitor;
    JFrame mainFrame;
    String fileName = "c:/file";
    JPanel mainPanel;
    double temp = 0.0;
    double pres = 0.0;
    double startPres = 0.0;
    double[][] points = new double[2][];
    double[] pointsH;
    double[][] pointsH2 = new double[4][];
    double[] pointsV;
    double[][] pointsV2 = new double[4][];
    double[] pointsS;
    double[][] pointsS2 = new double[4][];
    public double[][] points2 = new double[4][];
    double[][] points3 = new double[8][];
    boolean moreLines = false;
    boolean restart = true;
    int np = 0;
    int speceq = 0;
    String[] navn = new String[]{"bubble point", "dew point", "bubble point", "dew point", "dew points"};
    int npfirst;
    int ncrfirst;
    double Tcfirst;
    double Pcfirst;
    double Tmin = 0.0;
    double[] cricondenThermfirst = new double[3];
    double[] cricondenBarfirst = new double[3];
    double[] cricondenThermXfirst = new double[100];
    double[] cricondenThermYfirst = new double[100];
    double[] cricondenBarXfirst = new double[100];
    double[] cricondenBarYfirst = new double[100];

    public pTphaseEnvelope() {
    }

    public pTphaseEnvelope(SystemInterface system, String name, double phaseFraction, double lowPres, boolean bubfirst) {
        this.bubblePointFirst = bubfirst;
        if (name != null) {
            this.outputToFile = true;
            this.fileName = name;
        }
        this.system = system;
        this.phaseFraction = phaseFraction;
        this.lnOldOldK = new double[system.getPhase(0).getNumberOfComponents()];
        this.lnOldK = new double[system.getPhase(0).getNumberOfComponents()];
        this.lnK = new double[system.getPhase(0).getNumberOfComponents()];
        this.lowPres = lowPres;
        this.oldDeltalnK = new double[system.getPhase(0).getNumberOfComponents()];
        this.deltalnK = new double[system.getPhase(0).getNumberOfComponents()];
    }

    @Override
    public void run() {
        this.speceq = 0;
        try {
            this.points[0] = new double[10000];
            this.points[1] = new double[10000];
            this.pointsH = new double[10000];
            this.pointsV = new double[10000];
            this.pointsS = new double[10000];
            this.system.init(0);
            for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
                if (this.system.getComponent(i).getz() < 1.0E-10 || this.system.getPhase(0).getComponent(i).getIonicCharge() != 0.0) continue;
                if (this.bubblePointFirst && this.system.getPhase(0).getComponents()[this.speceq].getTC() > this.system.getPhase(0).getComponents()[i].getTC()) {
                    this.speceq = this.system.getPhase(0).getComponent(i).getComponentNumber();
                }
                if (this.bubblePointFirst || !(this.system.getPhase(0).getComponents()[this.speceq].getTC() < this.system.getPhase(0).getComponents()[i].getTC())) continue;
                this.speceq = this.system.getPhase(0).getComponent(i).getComponentNumber();
            }
            this.pres = this.lowPres;
            this.temp = this.tempKWilson(this.phaseFraction, this.pres);
            if (Double.isNaN(this.temp)) {
                this.temp = this.system.getPhase(0).getComponent(this.speceq).getTC() - 20.0;
            }
            this.system.setTemperature(this.temp);
            this.system.setPressure(this.pres);
            ThermodynamicOperations testOps = new ThermodynamicOperations(this.system);
            for (int i = 0; i < 5; ++i) {
                try {
                    if (this.phaseFraction < 0.5) {
                        this.temp += (double)(i * 2);
                        this.system.setTemperature(this.temp);
                        testOps.bubblePointTemperatureFlash();
                    } else {
                        this.temp += (double)(i * 2);
                        this.system.setTemperature(this.temp);
                        testOps.dewPointTemperatureFlash();
                    }
                }
                catch (Exception e) {
                    e.toString();
                }
                double tempNy = this.system.getTemperature();
                if (Double.isNaN(tempNy)) continue;
                this.temp = tempNy;
                break;
            }
            this.system.setBeta(this.phaseFraction);
            this.system.setPressure(this.pres);
            this.system.setTemperature(this.temp);
            sysNewtonRhapsonPhaseEnvelope nonLinSolver = new sysNewtonRhapsonPhaseEnvelope(this.system, 2, this.system.getPhase(0).getNumberOfComponents());
            this.startPres = this.system.getPressure();
            nonLinSolver.setu();
            this.np = 1;
            while (this.np < 9980) {
                int ii;
                try {
                    nonLinSolver.calcInc(this.np);
                    nonLinSolver.solve(this.np);
                }
                catch (Exception e0) {
                    if (this.restart) {
                        this.restart = false;
                        this.Tmin = this.points[0][this.np - 2];
                        this.npfirst = this.np - 1;
                        this.ncrfirst = nonLinSolver.getNpCrit();
                        if (this.ncrfirst == 0) {
                            this.ncrfirst = this.npfirst;
                        }
                        this.Tcfirst = this.system.getTC();
                        this.Pcfirst = this.system.getPC();
                        this.cricondenBarfirst = this.cricondenBar;
                        this.cricondenBarXfirst = this.cricondenBarX;
                        this.cricondenBarYfirst = this.cricondenBarY;
                        this.cricondenThermfirst = this.cricondenTherm;
                        this.cricondenThermXfirst = this.cricondenThermX;
                        this.cricondenThermYfirst = this.cricondenThermY;
                        this.hascopiedPoints = true;
                        this.copiedPoints = new double[5][this.np - 1];
                        for (int i = 0; i < this.np - 1; ++i) {
                            this.copiedPoints[0][i] = this.points[0][i];
                            this.copiedPoints[1][i] = this.points[1][i];
                            this.copiedPoints[2][i] = this.pointsH[i];
                            this.copiedPoints[3][i] = this.pointsS[i];
                            this.copiedPoints[4][i] = this.pointsV[i];
                        }
                        this.phaseFraction = 1.0 - this.phaseFraction;
                        this.bubblePointFirst = !this.bubblePointFirst;
                        this.run();
                        break;
                    }
                    --this.np;
                    break;
                }
                double Kvallc = this.system.getPhase(0).getComponent(nonLinSolver.lc).getx() / this.system.getPhase(1).getComponent(nonLinSolver.lc).getx();
                double Kvalhc = this.system.getPhase(0).getComponent(nonLinSolver.hc).getx() / this.system.getPhase(1).getComponent(nonLinSolver.hc).getx();
                if (!nonLinSolver.etterCP && Kvallc < 1.05 && Kvalhc > 0.95) {
                    nonLinSolver.npCrit = this.np;
                    this.system.invertPhaseTypes();
                    nonLinSolver.etterCP = true;
                    nonLinSolver.calcCrit();
                }
                if (nonLinSolver.calcCP) {
                    nonLinSolver.calcCP = false;
                    nonLinSolver.npCrit = this.np;
                    nonLinSolver.calcCrit();
                }
                if (this.system.getTemperature() > this.cricondenTherm[0]) {
                    this.cricondenTherm[1] = this.system.getPressure();
                    this.cricondenTherm[0] = this.system.getTemperature();
                    for (ii = 0; ii < nonLinSolver.numberOfComponents; ++ii) {
                        this.cricondenThermX[ii] = this.system.getPhase(1).getComponent(ii).getx();
                        this.cricondenThermY[ii] = this.system.getPhase(0).getComponent(ii).getx();
                    }
                } else {
                    nonLinSolver.ettercricoT = true;
                }
                if (this.system.getPressure() > this.cricondenBar[1]) {
                    this.cricondenBar[0] = this.system.getTemperature();
                    this.cricondenBar[1] = this.system.getPressure();
                    for (ii = 0; ii < nonLinSolver.numberOfComponents; ++ii) {
                        this.cricondenBarX[ii] = this.system.getPhase(1).getComponent(ii).getx();
                        this.cricondenBarY[ii] = this.system.getPhase(0).getComponent(ii).getx();
                    }
                }
                if (this.system.getPressure() < this.minPressure && nonLinSolver.ettercricoT || this.system.getPressure() > this.maxPressure || this.system.getTemperature() > this.Tmin && !this.restart) break;
                this.points[0][this.np - 1] = this.system.getTemperature();
                this.points[1][this.np - 1] = this.system.getPressure();
                this.pointsH[this.np - 1] = this.system.getPhase(1).getEnthalpy() / this.system.getPhase(1).getNumberOfMolesInPhase() / this.system.getPhase(1).getMolarMass() / 1000.0;
                this.pointsV[this.np - 1] = this.system.getPhase(1).getDensity();
                this.pointsS[this.np - 1] = this.system.getPhase(1).getEntropy() / this.system.getPhase(1).getNumberOfMolesInPhase() / this.system.getPhase(1).getMolarMass() / 1000.0;
                ++this.np;
            }
            try {
                int i;
                int ncr = nonLinSolver.getNpCrit();
                if (ncr == 0) {
                    ncr = this.np;
                }
                int ncr2 = this.np - ncr;
                if (this.hascopiedPoints) {
                    this.points2 = new double[8][];
                    this.pointsH2 = new double[8][];
                    this.pointsS2 = new double[8][];
                    this.pointsV2 = new double[8][];
                }
                this.points2[0] = new double[ncr + 1];
                this.points2[1] = new double[ncr + 1];
                this.pointsH2[0] = new double[ncr + 1];
                this.pointsH2[1] = new double[ncr + 1];
                this.pointsS2[0] = new double[ncr + 1];
                this.pointsS2[1] = new double[ncr + 1];
                this.pointsV2[0] = new double[ncr + 1];
                this.pointsV2[1] = new double[ncr + 1];
                if (ncr2 > 2) {
                    this.points2[2] = new double[ncr2 - 2];
                    this.points2[3] = new double[ncr2 - 2];
                    this.pointsH2[2] = new double[ncr2 - 2];
                    this.pointsH2[3] = new double[ncr2 - 2];
                    this.pointsS2[2] = new double[ncr2 - 2];
                    this.pointsS2[3] = new double[ncr2 - 2];
                    this.pointsV2[2] = new double[ncr2 - 2];
                    this.pointsV2[3] = new double[ncr2 - 2];
                } else {
                    this.points2[2] = new double[0];
                    this.points2[3] = new double[0];
                    this.pointsH2[2] = new double[0];
                    this.pointsH2[3] = new double[0];
                    this.pointsS2[2] = new double[0];
                    this.pointsS2[3] = new double[0];
                    this.pointsV2[2] = new double[0];
                    this.pointsV2[3] = new double[0];
                }
                for (i = 0; i < ncr; ++i) {
                    this.points2[0][i] = this.points[0][i];
                    this.points2[1][i] = this.points[1][i];
                    this.pointsH2[1][i] = this.points[1][i];
                    this.pointsH2[0][i] = this.pointsH[i];
                    this.pointsS2[1][i] = this.points[1][i];
                    this.pointsS2[0][i] = this.pointsS[i];
                    this.pointsV2[1][i] = this.points[1][i];
                    this.pointsV2[0][i] = this.pointsV[i];
                }
                if (ncr2 > 2) {
                    for (i = 1; i < ncr2 - 2; ++i) {
                        this.points2[2][i] = this.points[0][i + ncr - 1];
                        this.points2[3][i] = this.points[1][i + ncr - 1];
                        this.pointsH2[3][i] = this.points[1][i + ncr - 1];
                        this.pointsH2[2][i] = this.pointsH[i + ncr - 1];
                        this.pointsS2[3][i] = this.points[1][i + ncr - 1];
                        this.pointsS2[2][i] = this.pointsS[i + ncr - 1];
                        this.pointsV2[3][i] = this.points[1][i + ncr - 1];
                        this.pointsV2[2][i] = this.pointsV[i + ncr - 1];
                    }
                }
                if (this.hascopiedPoints) {
                    if (this.ncrfirst > this.npfirst) {
                        ncr = this.copiedPoints[0].length - 1;
                        ncr2 = this.npfirst - ncr;
                        --this.npfirst;
                    } else {
                        ncr = this.ncrfirst;
                        ncr2 = this.npfirst - ncr;
                    }
                    this.points2[4] = new double[ncr + 1];
                    this.points2[5] = new double[ncr + 1];
                    this.pointsH2[4] = new double[ncr + 1];
                    this.pointsH2[5] = new double[ncr + 1];
                    this.pointsS2[4] = new double[ncr + 1];
                    this.pointsS2[5] = new double[ncr + 1];
                    this.pointsV2[4] = new double[ncr + 1];
                    this.pointsV2[5] = new double[ncr + 1];
                    if (ncr2 > 2) {
                        this.points2[6] = new double[ncr2 - 2];
                        this.points2[7] = new double[ncr2 - 2];
                        this.pointsH2[6] = new double[ncr2 - 2];
                        this.pointsH2[7] = new double[ncr2 - 2];
                        this.pointsS2[6] = new double[ncr2 - 2];
                        this.pointsS2[7] = new double[ncr2 - 2];
                        this.pointsV2[6] = new double[ncr2 - 2];
                        this.pointsV2[7] = new double[ncr2 - 2];
                    } else {
                        this.points2[6] = new double[0];
                        this.points2[7] = new double[0];
                        this.pointsH2[6] = new double[0];
                        this.pointsH2[7] = new double[0];
                        this.pointsS2[6] = new double[0];
                        this.pointsS2[7] = new double[0];
                        this.pointsV2[6] = new double[0];
                        this.pointsV2[7] = new double[0];
                    }
                    for (i = 0; i < ncr; ++i) {
                        this.points2[4][i] = this.copiedPoints[0][i];
                        this.points2[5][i] = this.copiedPoints[1][i];
                        this.pointsH2[5][i] = this.copiedPoints[1][i];
                        this.pointsH2[4][i] = this.copiedPoints[2][i];
                        this.pointsS2[5][i] = this.copiedPoints[1][i];
                        this.pointsS2[4][i] = this.copiedPoints[3][i];
                        this.pointsV2[5][i] = this.copiedPoints[1][i];
                        this.pointsV2[4][i] = this.copiedPoints[4][i];
                    }
                    if (ncr2 > 2) {
                        for (i = 1; i < ncr2 - 2; ++i) {
                            this.points2[6][i] = this.copiedPoints[0][i + ncr - 1];
                            this.points2[7][i] = this.copiedPoints[1][i + ncr - 1];
                            this.pointsH2[7][i] = this.copiedPoints[1][i + ncr - 1];
                            this.pointsH2[6][i] = this.copiedPoints[2][i + ncr - 1];
                            this.pointsS2[7][i] = this.copiedPoints[1][i + ncr - 1];
                            this.pointsS2[6][i] = this.copiedPoints[3][i + ncr - 1];
                            this.pointsV2[7][i] = this.copiedPoints[1][i + ncr - 1];
                            this.pointsV2[6][i] = this.copiedPoints[4][i + ncr - 1];
                        }
                    }
                }
                this.system.setTemperature(this.system.getTC());
                this.system.setPressure(this.system.getPC());
                this.points2[0][ncr] = this.system.getTC();
                this.points2[1][ncr] = this.system.getPC();
                if (ncr2 > 2) {
                    this.points2[2][0] = this.system.getTC();
                    this.points2[3][0] = this.system.getPC();
                }
            }
            catch (Exception ncr) {
                // empty catch block
            }
            try {
                if (this.outputToFile) {
                    String name1 = new String();
                    name1 = this.fileName + "Dew.nc";
                    this.file1 = new NetCdf2D();
                    this.file1.setOutputFileName(name1);
                    this.file1.setXvalues(this.points2[2], "temp", "sec");
                    this.file1.setYvalues(this.points2[3], "pres", "meter");
                    this.file1.createFile();
                    String name2 = new String();
                    name2 = this.fileName + "Bub.nc";
                    this.file2 = new NetCdf2D();
                    this.file2.setOutputFileName(name2);
                    this.file2.setXvalues(this.points2[0], "temp", "sec");
                    this.file2.setYvalues(this.points2[1], "pres", "meter");
                    this.file2.createFile();
                }
            }
            catch (Exception e3) {
                logger.error("error", (Throwable)e3);
            }
        }
        catch (Exception e4) {
            logger.error("error", (Throwable)e4);
        }
    }

    public void calcHydrateLine() {
        ThermodynamicOperations opsHyd = new ThermodynamicOperations(this.system);
        try {
            opsHyd.hydrateEquilibriumLine(10.0, 300.0);
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
        }
    }

    @Override
    public void displayResult() {
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(1);
        nf.applyPattern("####.#");
        if (this.bubblePointFirst) {
            this.navn[0] = "bubble point 2";
            this.navn[1] = "dew point 2";
            this.navn[2] = "dew point 1";
            this.navn[3] = "bubble point 1";
        } else {
            this.navn[0] = "dew point 2";
            this.navn[1] = "bubble point 2";
            this.navn[2] = "dew point 1";
            this.navn[3] = "bubbl point 1";
        }
        double TC = this.system.getTC();
        double PC = this.system.getPC();
        String title = "PT-graph  TC=" + String.valueOf(nf.format(TC)) + " PC=" + String.valueOf(nf.format(PC));
        String title3 = "PH-graph  TC=" + String.valueOf(nf.format(TC)) + " PC=" + String.valueOf(nf.format(PC));
        String title4 = "Density-graph  TC=" + String.valueOf(nf.format(TC)) + " PC=" + String.valueOf(nf.format(PC));
        String title5 = "PS-graph  TC=" + String.valueOf(nf.format(TC)) + " PC=" + String.valueOf(nf.format(PC));
        graph2b graph3 = new graph2b(this.pointsH2, this.navn, title3, "Enthalpy [kJ/kg]", "Pressure [bara]");
        graph3.setVisible(true);
        graph2b graph4 = new graph2b(this.pointsV2, this.navn, title4, "Density [kg/m^3]", "Pressure [bara]");
        graph4.setVisible(true);
        graph2b graph5 = new graph2b(this.pointsS2, this.navn, title5, "Entropy [kJ/kg*K]", "Pressure [bara]");
        graph5.setVisible(true);
        this.graph2 = new graph2b(this.points2, this.navn, title, "Temperature [K]", "Pressure [bara]");
        this.graph2.setVisible(true);
    }

    @Override
    public void printToFile(String name) {
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(1);
        nf.applyPattern("####.#");
        if (this.bubblePointFirst) {
            this.navn[0] = "bubble point 2";
            this.navn[1] = "dew point 2";
            this.navn[2] = "dew point 1";
            this.navn[3] = "bubble point 1";
        } else {
            this.navn[0] = "dew point";
            this.navn[1] = "bubble point";
            this.navn[2] = "dew point";
            this.navn[3] = "bubbl point";
        }
        double TC = this.system.getTC();
        double PC = this.system.getPC();
        String title = "PT-graph  TC=" + String.valueOf(nf.format(TC)) + " PC=" + String.valueOf(nf.format(PC));
        this.graph2 = new graph2b(this.points2, this.navn, title, "Temperature [K]", "Pressure [bara]");
        return this.graph2.getChart();
    }

    @Override
    public double[][] getPoints(int i) {
        return this.points2;
    }

    @Override
    public void addData(String name, double[][] data) {
        double[][] localPoints = new double[this.points2.length + data.length][];
        this.navn[localPoints.length / 2 - 1] = name;
        System.arraycopy(this.points2, 0, localPoints, 0, this.points2.length);
        System.arraycopy(data, 0, localPoints, this.points2.length, data.length);
        this.points2 = localPoints;
    }

    @Override
    public double[] get(String name) {
        if (name.equals("dewT")) {
            return this.points2[0];
        }
        if (name.equals("dewP")) {
            return this.points2[1];
        }
        if (name.equals("bubT")) {
            return this.points2[2];
        }
        if (name.equals("bubP")) {
            return this.points2[3];
        }
        if (name.equals("dewT2")) {
            return this.points2[4];
        }
        if (name.equals("dewP2")) {
            return this.points2[5];
        }
        if (name.equals("bubT2")) {
            return this.points2[6];
        }
        if (name.equals("bubP2")) {
            return this.points2[7];
        }
        if (name.equals("dewH")) {
            return this.pointsH2[2];
        }
        if (name.equals("dewDens")) {
            return this.pointsV2[2];
        }
        if (name.equals("dewS")) {
            return this.pointsS2[2];
        }
        if (name.equals("bubH")) {
            return this.pointsH2[0];
        }
        if (name.equals("bubDens")) {
            return this.pointsV2[0];
        }
        if (name.equals("bubS")) {
            return this.pointsS2[0];
        }
        if (name.equals("cricondentherm")) {
            return this.cricondenTherm;
        }
        if (name.equals("cricondenthermX")) {
            return this.cricondenThermX;
        }
        if (name.equals("cricondenthermY")) {
            return this.cricondenThermY;
        }
        if (name.equals("cricondenbar")) {
            return this.cricondenBar;
        }
        if (name.equals("cricondenbarX")) {
            return this.cricondenBarX;
        }
        if (name.equals("cricondenbarY")) {
            return this.cricondenBarY;
        }
        if (name.equals("criticalPoint1")) {
            return new double[]{this.system.getTC(), this.system.getPC()};
        }
        if (name.equals("criticalPoint2")) {
            return new double[]{0.0, 0.0};
        }
        return null;
    }

    @Override
    public void createNetCdfFile(String name) {
        this.fileName = name;
    }

    public boolean isBubblePointFirst() {
        return this.bubblePointFirst;
    }

    public void setBubblePointFirst(boolean bubblePointFirst) {
        this.bubblePointFirst = bubblePointFirst;
    }

    @Override
    public String[][] getResultTable() {
        return null;
    }

    public double tempKWilson(double beta, double P) {
        int i;
        double initTc = 0.0;
        double initPc = 0.0;
        double initAc = 0.0;
        double Tstart = 0.0;
        double Tstartold = 0.0;
        double initT = 0.0;
        double dinitT = 0.0;
        int numberOfComponents = this.system.getPhase(0).getNumberOfComponents();
        int lc = 0;
        int hc = 0;
        double[] Kwil = new double[numberOfComponents];
        double min = 100000.0;
        double max = 0.0;
        for (i = 0; i < numberOfComponents; ++i) {
            if (this.system.getPhase(0).getComponents()[i].getTC() > max) {
                max = this.system.getPhase(0).getComponents()[i].getTC();
                hc = i;
            }
            if (!(this.system.getPhase(0).getComponents()[i].getTC() < min)) continue;
            min = this.system.getPhase(0).getComponents()[i].getTC();
            lc = i;
        }
        try {
            if (beta <= 0.5) {
                initTc = this.system.getPhase(0).getComponents()[lc].getTC();
                initPc = this.system.getPhase(0).getComponents()[lc].getPC();
                initAc = this.system.getPhase(0).getComponents()[lc].getAcentricFactor();
            } else if (beta > 0.5) {
                initTc = this.system.getPhase(0).getComponents()[hc].getTC();
                initPc = this.system.getPhase(0).getComponents()[hc].getPC();
                initAc = this.system.getPhase(0).getComponents()[hc].getAcentricFactor();
            }
            Tstart = initTc * 5.373 * (1.0 + initAc) / (5.373 * (1.0 + initAc) - Math.log(P / initPc));
            for (i = 0; i < 1000; ++i) {
                int j;
                initT = 0.0;
                dinitT = 0.0;
                for (j = 0; j < numberOfComponents; ++j) {
                    Kwil[j] = this.system.getPhase(0).getComponents()[j].getPC() / P * Math.exp(5.373 * (1.0 + this.system.getPhase(0).getComponents()[j].getAcentricFactor()) * (1.0 - this.system.getPhase(0).getComponents()[j].getTC() / Tstart));
                }
                for (j = 0; j < numberOfComponents; ++j) {
                    if (beta < 0.5) {
                        initT += this.system.getPhase(0).getComponents()[j].getz() * Kwil[j];
                        dinitT += this.system.getPhase(0).getComponents()[j].getz() * Kwil[j] * 5.373 * (1.0 + this.system.getPhase(0).getComponents()[j].getAcentricFactor()) * this.system.getPhase(0).getComponents()[j].getTC() / (Tstart * Tstart);
                        continue;
                    }
                    initT += this.system.getPhase(0).getComponents()[j].getz() / Kwil[j];
                    dinitT -= this.system.getPhase(0).getComponents()[j].getz() / Kwil[j] * 5.373 * (1.0 + this.system.getPhase(0).getComponents()[j].getAcentricFactor()) * this.system.getPhase(0).getComponents()[j].getTC() / (Tstart * Tstart);
                }
                Tstart = Math.abs((initT -= 1.0) / dinitT) > 0.1 * Tstart ? (Tstart -= 0.001 * initT / dinitT) : (Tstart -= initT / dinitT);
                if (Math.abs(Tstart - Tstartold) < 1.0E-5) {
                    return Tstart;
                }
                Tstartold = Tstart;
            }
        }
        catch (Exception e) {
            Tstart = initTc * 5.373 * (1.0 + initAc) / (5.373 * (1.0 + initAc) - Math.log(P / initPc));
        }
        if (Double.isNaN(Tstart) || Double.isInfinite(Tstart)) {
            Tstart = initTc * 5.373 * (1.0 + initAc) / (5.373 * (1.0 + initAc) - Math.log(P / initPc));
        }
        return Tstart;
    }
}

