/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps.saturationOps;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.flashOps.saturationOps.constantDutyFlash;
import org.jfree.chart.JFreeChart;

public class constantDutyTemperatureFlash
extends constantDutyFlash {
    private static final long serialVersionUID = 1000L;

    public constantDutyTemperatureFlash() {
    }

    public constantDutyTemperatureFlash(SystemInterface system) {
        super(system);
    }

    @Override
    public void run() {
        this.system.init(0);
        this.system.init(2);
        int iterations = 0;
        double deriv = 0.0;
        double funk = 0.0;
        double dkidt = 0.0;
        double dyidt = 0.0;
        double dxidt = 0.0;
        double Told = 0.0;
        do {
            int i;
            ++iterations;
            this.system.init(2);
            for (i = 0; i < this.system.getPhases()[0].getNumberOfComponents(); ++i) {
                this.system.getPhases()[0].getComponents()[i].setK(this.system.getPhases()[0].getComponents()[i].getFugacityCoefficient() / this.system.getPhases()[1].getComponents()[i].getFugacityCoefficient());
                this.system.getPhases()[1].getComponents()[i].setK(this.system.getPhases()[0].getComponents()[i].getFugacityCoefficient() / this.system.getPhases()[1].getComponents()[i].getFugacityCoefficient());
            }
            this.system.calc_x_y_nonorm();
            funk = 0.0;
            deriv = 0.0;
            for (i = 0; i < this.system.getPhases()[0].getNumberOfComponents(); ++i) {
                dkidt = (this.system.getPhases()[0].getComponents()[i].getdfugdt() - this.system.getPhases()[1].getComponents()[i].getdfugdt()) * this.system.getPhases()[0].getComponents()[i].getK();
                dxidt = -this.system.getPhases()[0].getComponents()[i].getz() * this.system.getBeta() * dkidt / Math.pow(1.0 - this.system.getBeta() + this.system.getBeta() * this.system.getPhases()[0].getComponents()[i].getK(), 2.0);
                dyidt = dkidt * this.system.getPhases()[0].getComponents()[i].getx() + this.system.getPhases()[0].getComponents()[i].getK() * dxidt;
                funk = funk + this.system.getPhases()[1].getComponents()[i].getx() - this.system.getPhases()[0].getComponents()[i].getx();
                deriv = deriv + dyidt - dxidt;
            }
            Told = this.system.getTemperature();
            this.system.setTemperature(Told - funk / deriv * 0.7);
        } while (Math.abs((this.system.getTemperature() - Told) / this.system.getTemperature()) > 1.0E-7 && iterations < 300 || iterations < 3);
    }

    @Override
    public void printToFile(String name) {
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        return null;
    }

    @Override
    public SystemInterface getThermoSystem() {
        return this.system;
    }
}

