/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps.saturationOps;

import java.sql.ResultSet;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.flashOps.saturationOps.constantDutyTemperatureFlash;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class checkScalePotential
extends constantDutyTemperatureFlash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(checkScalePotential.class);
    String saltName;
    int phaseNumber = 1;
    String[][] resultTable = null;

    public checkScalePotential() {
    }

    public checkScalePotential(SystemInterface system, int phaseNumber) {
        super(system);
        this.phaseNumber = phaseNumber;
        logger.info("ok ");
    }

    @Override
    public void run() {
        block9: {
            double ksp = 0.0;
            NeqSimDataBase database = new NeqSimDataBase();
            ResultSet dataSet = database.getResultSet("SELECT * FROM compsalt");
            this.resultTable = new String[10][3];
            double stoc1 = 1.0E-20;
            double stoc2 = 1.0E-20;
            String saltName = "";
            String name1 = "";
            String name2 = "";
            int numb = 0;
            for (int i = 0; i < 10; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.resultTable[i][j] = "";
                }
            }
            this.resultTable[0][0] = "Salt";
            this.resultTable[0][1] = "relative solubility";
            this.resultTable[0][2] = "";
            double numberOfMolesMEG = 0.0;
            try {
                if (this.system.getPhase(this.phaseNumber).hasComponent("MEG")) {
                    numberOfMolesMEG = this.system.getPhase(this.phaseNumber).getComponent("MEG").getNumberOfMolesInPhase();
                    this.system.addComponent("MEG", -numberOfMolesMEG * 0.9999, this.phaseNumber);
                    this.system.addComponent("water", numberOfMolesMEG, this.phaseNumber);
                    this.system.init(1);
                    this.system.getChemicalReactionOperations().solveChemEq(this.phaseNumber, 1);
                }
                while (dataSet.next()) {
                    saltName = dataSet.getString("SaltName").trim();
                    name1 = dataSet.getString("ion1").trim();
                    name2 = dataSet.getString("ion2").trim();
                    stoc1 = Double.parseDouble(dataSet.getString("stoc1"));
                    stoc2 = Double.parseDouble(dataSet.getString("stoc2"));
                    double temperatureC = this.system.getPhase(this.phaseNumber).getTemperature();
                    double lnKsp = Double.parseDouble(dataSet.getString("Kspwater")) / temperatureC + Double.parseDouble(dataSet.getString("Kspwater2")) + Math.log(temperatureC) * Double.parseDouble(dataSet.getString("Kspwater3")) + temperatureC * Double.parseDouble(dataSet.getString("Kspwater4")) + Double.parseDouble(dataSet.getString("Kspwater5")) / (temperatureC * temperatureC);
                    ksp = Math.exp(lnKsp);
                    if (saltName.equals("NaCl")) {
                        ksp = -814.18 + 7.4685 * temperatureC - 0.023262 * temperatureC * temperatureC + 3.0536E-5 * Math.pow(temperatureC, 3.0) - 1.4573E-8 * Math.pow(temperatureC, 4.0);
                    }
                    if (saltName.equals("FeS")) {
                        int waterompNumb = this.system.getPhase(this.phaseNumber).getComponent("water").getComponentNumber();
                        double h3ox = this.system.getPhase(this.phaseNumber).getComponent("H3O+").getx() / (this.system.getPhase(this.phaseNumber).getComponent(waterompNumb).getx() * this.system.getPhase(this.phaseNumber).getComponent(waterompNumb).getMolarMass());
                        ksp *= h3ox;
                    }
                    if (!this.system.getPhase(this.phaseNumber).hasComponent(name1) || !this.system.getPhase(this.phaseNumber).hasComponent(name2)) continue;
                    ++numb;
                    logger.info("reaction added: " + name1 + " " + name2);
                    logger.info("theoretic Ksp = " + ksp);
                    logger.info("theoretic lnKsp = " + Math.log(ksp));
                    int compNumb1 = this.system.getPhase(this.phaseNumber).getComponent(name1).getComponentNumber();
                    int compNumb2 = this.system.getPhase(this.phaseNumber).getComponent(name2).getComponentNumber();
                    int waterompNumb = this.system.getPhase(this.phaseNumber).getComponent("water").getComponentNumber();
                    double x1 = this.system.getPhase(this.phaseNumber).getComponent(name1).getx() / (this.system.getPhase(this.phaseNumber).getComponent(waterompNumb).getx() * this.system.getPhase(this.phaseNumber).getComponent(waterompNumb).getMolarMass());
                    double x2 = this.system.getPhase(this.phaseNumber).getComponent(name2).getx() / (this.system.getPhase(this.phaseNumber).getComponent(waterompNumb).getx() * this.system.getPhase(this.phaseNumber).getComponent(waterompNumb).getMolarMass());
                    double kspReac = Math.pow(this.system.getPhase(this.phaseNumber).getActivityCoefficient(compNumb1, waterompNumb) * x1, stoc1) * Math.pow(x2 * this.system.getPhase(this.phaseNumber).getActivityCoefficient(compNumb2, waterompNumb), stoc2);
                    double stocKsp = Math.pow(x1, stoc1) * Math.pow(x2, stoc2);
                    if (saltName.contains("hydromagnesite (3MgCO3-Mg(OH)2-3H2O)")) {
                        x1 = this.system.getPhase(this.phaseNumber).getComponent(name1).getx() / (this.system.getPhase(this.phaseNumber).getComponent(waterompNumb).getx() * this.system.getPhase(this.phaseNumber).getComponent(waterompNumb).getMolarMass());
                        x2 = this.system.getPhase(this.phaseNumber).getComponent(name2).getx() / (this.system.getPhase(this.phaseNumber).getComponent(waterompNumb).getx() * this.system.getPhase(this.phaseNumber).getComponent(waterompNumb).getMolarMass());
                        double x3 = this.system.getPhase(this.phaseNumber).getComponent(waterompNumb).getx() / (this.system.getPhase(this.phaseNumber).getComponent(waterompNumb).getx() * this.system.getPhase(this.phaseNumber).getComponent(waterompNumb).getMolarMass());
                        double x4 = this.system.getPhase(this.phaseNumber).getComponent("OH-").getx() / (this.system.getPhase(this.phaseNumber).getComponent(waterompNumb).getx() * this.system.getPhase(this.phaseNumber).getComponent(waterompNumb).getMolarMass());
                        kspReac = Math.pow(this.system.getPhase(this.phaseNumber).getActivityCoefficient(compNumb1, waterompNumb) * x1, stoc1) * Math.pow(x2 * this.system.getPhase(this.phaseNumber).getActivityCoefficient(compNumb2, waterompNumb), stoc2) * Math.pow(x3 * this.system.getPhase(this.phaseNumber).getActivityCoefficient(waterompNumb, waterompNumb), 3.0) * Math.pow(x4 * this.system.getPhase(this.phaseNumber).getActivityCoefficient(this.system.getPhase(this.phaseNumber).getComponent("OH-").getComponentNumber(), waterompNumb), 2.0);
                        stocKsp = Math.pow(x1, stoc1) * Math.pow(x2, stoc2) * Math.pow(x3, 3.0) * Math.pow(x4, 2.0);
                    }
                    logger.info("calc Ksp " + kspReac);
                    logger.info("stoc Ksp " + stocKsp);
                    logger.info("activity " + kspReac / stocKsp);
                    logger.info("mol/kg " + x1);
                    double scalePotentialFactor = kspReac / ksp;
                    logger.info("Scale potential factor " + scalePotentialFactor);
                    this.resultTable[numb][0] = saltName;
                    this.resultTable[numb][1] = Double.toString(scalePotentialFactor);
                    this.resultTable[numb][2] = "";
                }
            }
            catch (Exception e) {
                logger.error("failed " + e.toString());
                if (!this.system.getPhase(this.phaseNumber).hasComponent("MEG")) break block9;
                this.system.addComponent("MEG", numberOfMolesMEG * 0.9999, this.phaseNumber);
                this.system.addComponent("water", -numberOfMolesMEG, this.phaseNumber);
                this.system.init(1);
                this.system.getChemicalReactionOperations().solveChemEq(this.phaseNumber, 1);
            }
        }
    }

    @Override
    public void printToFile(String name) {
    }

    @Override
    public String[][] getResultTable() {
        logger.info("checking table...scale " + this.resultTable[0][0]);
        logger.info("checking table...scale " + this.resultTable[0][1]);
        logger.info("checking table...scale " + this.resultTable[0][2]);
        logger.info("checking table...scale " + this.resultTable[1][0]);
        logger.info("checking table...scale " + this.resultTable[1][1]);
        logger.info("checking table...scale " + this.resultTable[1][2]);
        return this.resultTable;
    }
}

