/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps.saturationOps;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.flashOps.saturationOps.constantDutyPressureFlash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class bubblePointPressureFlashDer
extends constantDutyPressureFlash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(bubblePointPressureFlashDer.class);

    public bubblePointPressureFlashDer() {
    }

    public bubblePointPressureFlashDer(SystemInterface system) {
        super(system);
    }

    @Override
    public void run() {
        int i;
        if (this.system.getPhase(0).getNumberOfComponents() == 1 && this.system.getTemperature() > this.system.getPhase(0).getComponent(0).getTC()) {
            this.setSuperCritical(true);
        }
        int iterations = 0;
        int maxNumberOfIterations = 500;
        double yold = 0.0;
        double ytotal = 1.0;
        double deriv = 0.0;
        double funk = 0.0;
        boolean chemSolved = true;
        this.system.init(0);
        this.system.setNumberOfPhases(2);
        this.system.setBeta(1, 0.9999999999);
        this.system.setBeta(0, 1.0E-10);
        double oldPres = 0.0;
        double oldChemPres = 1.0;
        if (this.system.isChemicalSystem()) {
            this.system.getChemicalReactionOperations().solveChemEq(1, 0);
        }
        for (i = 0; i < this.system.getPhases()[1].getNumberOfComponents(); ++i) {
            this.system.getPhases()[1].getComponents()[i].setx(this.system.getPhases()[0].getComponents()[i].getz());
            if (this.system.getPhases()[0].getComponents()[i].getIonicCharge() != 0.0) {
                this.system.getPhases()[0].getComponents()[i].setx(1.0E-40);
                continue;
            }
            this.system.getPhases()[0].getComponents()[i].setx(this.system.getPhases()[0].getComponents()[i].getK() * this.system.getPhases()[1].getComponents()[i].getz());
        }
        ytotal = 0.0;
        for (i = 0; i < this.system.getPhases()[0].getNumberOfComponents(); ++i) {
            ytotal += this.system.getPhases()[0].getComponents()[i].getx();
        }
        double ktot = 0.0;
        int chemIter = 0;
        do {
            ++chemIter;
            oldChemPres = this.system.getPressure();
            iterations = 0;
            do {
                int i2;
                ++iterations;
                for (i2 = 0; i2 < this.system.getPhases()[0].getNumberOfComponents(); ++i2) {
                    this.system.getPhases()[0].getComponents()[i2].setx(this.system.getPhases()[0].getComponents()[i2].getx() / ytotal);
                }
                this.system.init(1);
                oldPres = this.system.getPressure();
                ktot = 0.0;
                for (i2 = 0; i2 < this.system.getPhases()[1].getNumberOfComponents(); ++i2) {
                    do {
                        yold = this.system.getPhases()[0].getComponents()[i2].getx();
                        if (!Double.isNaN(Math.exp(Math.log(this.system.getPhases()[1].getComponents()[i2].getFugacityCoefficient()) - Math.log(this.system.getPhases()[0].getComponents()[i2].getFugacityCoefficient())))) {
                            if (this.system.getPhase(0).getComponent(i2).getIonicCharge() != 0.0) {
                                this.system.getPhases()[0].getComponents()[i2].setK(1.0E-40);
                            } else {
                                this.system.getPhases()[0].getComponents()[i2].setK(Math.exp(Math.log(this.system.getPhases()[1].getComponents()[i2].getFugacityCoefficient()) - Math.log(this.system.getPhases()[0].getComponents()[i2].getFugacityCoefficient())));
                            }
                        }
                        this.system.getPhases()[1].getComponents()[i2].setK(this.system.getPhases()[0].getComponents()[i2].getK());
                        this.system.getPhases()[0].getComponents()[i2].setx(this.system.getPhases()[0].getComponents()[i2].getK() * this.system.getPhases()[1].getComponents()[i2].getz());
                    } while (Math.abs(this.system.getPhases()[0].getComponents()[i2].getx() - yold) / yold > 1.0E-8);
                    ktot += Math.abs(this.system.getPhases()[1].getComponents()[i2].getK() - 1.0);
                }
                for (i2 = 0; i2 < this.system.getPhases()[0].getNumberOfComponents(); ++i2) {
                    if (!Double.isNaN(this.system.getPhases()[0].getComponents()[i2].getK())) {
                        this.system.getPhases()[0].getComponents()[i2].setx(this.system.getPhases()[0].getComponents()[i2].getK() * this.system.getPhases()[1].getComponents()[i2].getz());
                        continue;
                    }
                    this.system.init(0);
                    logger.error("K error : nan");
                }
                ytotal = 0.0;
                deriv = 0.0;
                funk = 0.0;
                for (i2 = 0; i2 < this.system.getPhases()[0].getNumberOfComponents(); ++i2) {
                    ytotal += this.system.getPhases()[0].getComponents()[i2].getx();
                    funk += this.system.getPhases()[1].getComponents()[i2].getx() * this.system.getPhases()[1].getComponents()[i2].getK();
                    deriv += this.system.getPhases()[1].getComponents()[i2].getx() * this.system.getPhases()[1].getComponents()[i2].getK() * (this.system.getPhases()[1].getComponents()[i2].logfugcoefdP(this.system.getPhase(1)) - this.system.getPhases()[0].getComponents()[i2].logfugcoefdP(this.system.getPhase(0)));
                }
                if (ytotal > 1.5) {
                    ytotal = 1.5;
                }
                if (ytotal < 0.5) {
                    ytotal = 0.5;
                }
                this.system.setPressure(this.system.getPressure() - (funk - 1.0) / deriv);
                if (this.system.getPressure() < 0.0) {
                    this.system.setPressure(oldChemPres / 2.0);
                    this.run();
                    return;
                }
                if (!(this.system.getPressure() > 5.0 * oldChemPres)) continue;
                this.system.setPressure(oldChemPres * 5.0);
                this.run();
                return;
            } while ((Math.abs(ytotal - 1.0) > 1.0E-7 || Math.abs(oldPres - this.system.getPressure()) / oldPres > 1.0E-6) && iterations < maxNumberOfIterations || iterations < 5);
            if (!this.system.isChemicalSystem()) continue;
            chemSolved = this.system.getChemicalReactionOperations().solveChemEq(1, 0);
            this.system.setBeta(1, 0.9999999999);
            this.system.setBeta(0, 1.0E-10);
        } while ((Math.abs(oldChemPres - this.system.getPressure()) / oldChemPres > 1.0E-6 || chemIter < 2 || !chemSolved) && chemIter < 20);
        this.system.init(1);
        if (Math.abs(ytotal - 1.0) > 1.0E-4 || ktot < 0.001 && this.system.getPhase(0).getNumberOfComponents() > 1) {
            logger.info("ytot " + Math.abs(ytotal - 1.0));
            logger.info("Supercritical vapor phase !!");
            this.setSuperCritical(true);
        }
    }

    @Override
    public void printToFile(String name) {
    }
}

