/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import neqsim.thermodynamicOperations.flashOps.Flash;
import neqsim.thermodynamicOperations.flashOps.QfuncFlash;
import neqsim.thermodynamicOperations.flashOps.TPflash;

public class TSFlash
extends QfuncFlash {
    private static final long serialVersionUID = 1000L;
    double Sspec = 0.0;
    Flash tpFlash;

    public TSFlash() {
    }

    public TSFlash(SystemInterface system, double Sspec) {
        this.system = system;
        this.tpFlash = new TPflash(system);
        this.Sspec = Sspec;
    }

    @Override
    public double calcdQdTT() {
        if (this.system.getNumberOfPhases() == 1) {
            return -this.system.getPhase(0).getCp() / this.system.getTemperature();
        }
        double dQdTT = 0.0;
        for (int i = 0; i < this.system.getNumberOfPhases(); ++i) {
            dQdTT -= this.system.getPhase(i).getCp() / this.system.getPhase(i).getTemperature();
        }
        return dQdTT;
    }

    @Override
    public double calcdQdT() {
        double dQ = -this.system.getEntropy() + this.Sspec;
        return dQ;
    }

    @Override
    public double solveQ() {
        double oldTemp = this.system.getPressure();
        double nyTemp = this.system.getPressure();
        int iterations = 1;
        double error = 1.0;
        double erorOld = 1.0E11;
        do {
            ++iterations;
            oldTemp = this.system.getPressure();
            this.system.init(2);
            nyTemp = oldTemp - this.calcdQdT() / 10.0;
            this.system.setPressure(nyTemp);
            this.tpFlash.run();
            erorOld = error;
        } while (((error = Math.abs(this.calcdQdT())) + erorOld > 1.0E-8 || iterations < 3) && iterations < 200);
        return nyTemp;
    }

    public void onPhaseSolve() {
    }

    @Override
    public void run() {
        this.tpFlash.run();
        this.solveQ();
    }

    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(373.15, 45.551793);
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        testSystem.addComponent("methane", 9.4935);
        testSystem.addComponent("ethane", 5.06499);
        testSystem.addComponent("n-heptane", 0.2);
        testSystem.init(0);
        try {
            testOps.TPflash();
            testSystem.display();
            double Sspec = testSystem.getEntropy("kJ/kgK");
            System.out.println("S spec " + Sspec);
            testSystem.setTemperature(293.15);
            testOps.TSflash(Sspec, "kJ/kgK");
            testSystem.display();
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
    }
}

