/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps;

import Jama.Matrix;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.flashOps.Flash;
import org.jfree.chart.JFreeChart;

public class TPgradientFlash
extends Flash {
    private static final long serialVersionUID = 1000L;
    SystemInterface localSystem = null;
    SystemInterface tempSystem = null;
    double temperature = 0.0;
    double height = 0.0;
    double deltaHeight = 0.0;
    double deltaT = 0.0;
    Matrix Jac;
    Matrix fvec;
    Matrix u;
    Matrix dx;
    Matrix uold;

    public TPgradientFlash() {
    }

    public TPgradientFlash(SystemInterface system, double height, double temperature) {
        this.system = system;
        this.temperature = temperature;
        this.height = height;
        this.Jac = new Matrix(system.getPhase(0).getNumberOfComponents(), system.getPhase(0).getNumberOfComponents());
        this.fvec = new Matrix(system.getPhase(0).getNumberOfComponents(), 1);
    }

    public void setfvec() {
        for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            this.fvec.set(i, 0, Math.log(this.localSystem.getPhases()[0].getComponents()[i].getFugacityCoefficient() * this.localSystem.getPhases()[0].getComponents()[i].getx() * this.localSystem.getPressure()) - Math.log(this.tempSystem.getPhases()[0].getComponents()[i].getFugacityCoefficient() * this.tempSystem.getPhases()[0].getComponents()[i].getx() * this.tempSystem.getPressure()) - this.tempSystem.getPhases()[0].getComponents()[i].getMolarMass() * 9.80665 * this.deltaHeight / 8.3144621 / this.tempSystem.getPhase(0).getTemperature() + this.tempSystem.getPhases()[0].getComponents()[i].getMolarMass() * (this.tempSystem.getPhases()[0].getEnthalpy() / this.tempSystem.getPhases()[0].getNumberOfMolesInPhase() / this.tempSystem.getPhase(0).getMolarMass() - this.tempSystem.getPhases()[0].getComponents()[i].getEnthalpy(this.tempSystem.getPhase(0).getTemperature()) / this.tempSystem.getPhases()[0].getComponent(i).getNumberOfMolesInPhase() / this.tempSystem.getPhase(0).getComponent(i).getMolarMass()) * this.deltaT / this.tempSystem.getPhase(0).getTemperature() / 8.3144621 / this.tempSystem.getPhase(0).getTemperature());
        }
    }

    public void setJac() {
        this.Jac.timesEquals(0.0);
        double dij = 0.0;
        double tempJ = 0.0;
        for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            for (int j = 0; j < this.system.getPhase(0).getNumberOfComponents(); ++j) {
                dij = i == j ? 1.0 : 0.0;
                tempJ = 1.0 / (this.localSystem.getPhases()[0].getComponents()[i].getFugacityCoefficient() * this.localSystem.getPhases()[0].getComponents()[i].getx() * this.localSystem.getPressure()) * (this.localSystem.getPhases()[0].getComponents()[i].getFugacityCoefficient() * dij * this.localSystem.getPressure() + this.localSystem.getPhases()[0].getComponents()[i].getdfugdx(j) * this.localSystem.getPhases()[0].getComponents()[i].getx() * this.localSystem.getPressure());
                this.Jac.set(i, j, tempJ);
            }
        }
    }

    public void setNewX() {
        for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            this.localSystem.getPhase(0).getComponent(i).setx(this.localSystem.getPhase(0).getComponent(i).getx() - 0.5 * this.dx.get(i, 0));
        }
        this.localSystem.getPhase(0).normalize();
    }

    @Override
    public void run() {
        this.tempSystem = this.system.clone();
        this.tempSystem.init(0);
        this.tempSystem.init(3);
        this.localSystem = this.system.clone();
        this.deltaT = (this.temperature - this.system.getTemperature()) / 20.0;
        this.deltaHeight = this.height / 20.0;
        for (int i = 0; i < 20; ++i) {
            this.localSystem.setTemperature(this.localSystem.getTemperature() + this.deltaT);
            for (int o = 0; o < 15; ++o) {
                this.localSystem.init(3);
                this.setfvec();
                this.setJac();
                this.dx = this.Jac.solve(this.fvec);
                this.dx.print(10, 10);
                this.setNewX();
            }
            this.tempSystem = this.localSystem.clone();
            this.tempSystem.init(3);
        }
    }

    @Override
    public SystemInterface getThermoSystem() {
        return this.localSystem;
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        return null;
    }
}

