/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import neqsim.thermodynamicOperations.flashOps.Flash;
import neqsim.thermodynamicOperations.flashOps.TPmultiflash;
import neqsim.thermodynamicOperations.flashOps.TPmultiflashWAX;
import neqsim.thermodynamicOperations.flashOps.sysNewtonRhapsonTPflash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.chart.JFreeChart;

public class TPflash
extends Flash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(TPflash.class);
    SystemInterface clonedSystem;
    double betaTolerance = 1.0E-12;
    double presdiff = 1.0;

    public TPflash() {
    }

    public TPflash(SystemInterface system) {
        this.system = system;
        this.lnOldOldOldK = new double[system.getPhases()[0].getNumberOfComponents()];
        this.lnOldOldK = new double[system.getPhases()[0].getNumberOfComponents()];
        this.lnOldK = new double[system.getPhases()[0].getNumberOfComponents()];
        this.lnK = new double[system.getPhases()[0].getNumberOfComponents()];
        this.oldoldDeltalnK = new double[system.getPhases()[0].getNumberOfComponents()];
        this.oldDeltalnK = new double[system.getPhases()[0].getNumberOfComponents()];
        this.deltalnK = new double[system.getPhases()[0].getNumberOfComponents()];
    }

    public TPflash(SystemInterface system, boolean solCheck) {
        this(system);
        this.solidCheck = solCheck;
    }

    public void sucsSubs() {
        this.deviation = 0.0;
        this.i = 0;
        while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
            if (this.system.getPhase(0).getComponent(this.i).getIonicCharge() != 0.0) {
                this.Kold = this.system.getPhase(0).getComponent(this.i).getK();
                this.system.getPhase(0).getComponent(this.i).setK(1.0E-40);
                this.system.getPhase(1).getComponent(this.i).setK(this.system.getPhase(0).getComponent(this.i).getK());
            } else {
                this.Kold = this.system.getPhase(0).getComponent(this.i).getK();
                this.system.getPhase(0).getComponent(this.i).setK(this.system.getPhase(1).getComponent(this.i).getFugacityCoefficient() / this.system.getPhase(0).getComponent(this.i).getFugacityCoefficient() * this.presdiff);
                if (Double.isNaN(this.system.getPhase(0).getComponent(this.i).getK())) {
                    this.system.getPhase(0).getComponent(this.i).setK(this.Kold);
                    this.system.init(1);
                }
                this.system.getPhase(1).getComponent(this.i).setK(this.system.getPhase(0).getComponent(this.i).getK());
                this.deviation += Math.abs(Math.log(this.system.getPhase(0).getComponent(this.i).getK()) - Math.log(this.Kold));
            }
            ++this.i;
        }
        double oldBeta = this.system.getBeta();
        try {
            this.system.calcBeta();
        }
        catch (Exception e) {
            logger.error("error in beta calc" + e.toString());
            this.system.setBeta(oldBeta);
        }
        if (this.system.getBeta() > 1.0 - this.betaTolerance) {
            this.system.setBeta(1.0 - this.betaTolerance);
        }
        if (this.system.getBeta() < this.betaTolerance) {
            this.system.setBeta(this.betaTolerance);
        }
        this.system.calc_x_y();
        this.system.init(1);
    }

    public void accselerateSucsSubs() {
        double prod1 = 0.0;
        double prod2 = 0.0;
        this.i = 0;
        while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
            prod1 += this.oldDeltalnK[this.i] * this.oldoldDeltalnK[this.i];
            prod2 += this.oldoldDeltalnK[this.i] * this.oldoldDeltalnK[this.i];
            ++this.i;
        }
        double lambda = prod1 / prod2;
        this.i = 0;
        while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
            int n = this.i;
            this.lnK[n] = this.lnK[n] + lambda / (1.0 - lambda) * this.deltalnK[this.i];
            this.system.getPhase(0).getComponent(this.i).setK(Math.exp(this.lnK[this.i]));
            this.system.getPhase(1).getComponent(this.i).setK(Math.exp(this.lnK[this.i]));
            ++this.i;
        }
        double oldBeta = this.system.getBeta();
        try {
            this.system.calcBeta();
        }
        catch (Exception e) {
            if (this.system.getBeta() > 1.0 - this.betaTolerance || this.system.getBeta() < this.betaTolerance) {
                this.system.setBeta(oldBeta);
            }
            logger.info("temperature " + this.system.getTemperature() + " pressure " + this.system.getPressure());
            logger.error("error", (Throwable)e);
        }
        this.system.calc_x_y();
        this.system.init(1);
    }

    public void setNewK() {
        this.i = 0;
        while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
            this.lnOldOldOldK[this.i] = this.lnOldOldK[this.i];
            this.lnOldOldK[this.i] = this.lnOldK[this.i];
            this.lnOldK[this.i] = this.lnK[this.i];
            this.lnK[this.i] = Math.log(this.system.getPhase(1).getComponent(this.i).getFugacityCoefficient()) - Math.log(this.system.getPhase(0).getComponents()[this.i].getFugacityCoefficient());
            this.oldoldDeltalnK[this.i] = this.lnOldOldK[this.i] - this.lnOldOldOldK[this.i];
            this.oldDeltalnK[this.i] = this.lnOldK[this.i] - this.lnOldOldK[this.i];
            this.deltalnK[this.i] = this.lnK[this.i] - this.lnOldK[this.i];
            ++this.i;
        }
    }

    public void resetK() {
        this.i = 0;
        while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
            this.lnK[this.i] = this.lnOldK[this.i];
            this.system.getPhase(0).getComponents()[this.i].setK(Math.exp(this.lnK[this.i]));
            this.system.getPhase(1).getComponents()[this.i].setK(Math.exp(this.lnK[this.i]));
            ++this.i;
        }
        try {
            this.system.calcBeta();
            this.system.calc_x_y();
            this.system.init(1);
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
        }
    }

    @Override
    public void run() {
        TPflash operation;
        if (this.system.isForcePhaseTypes() && this.system.getMaxNumberOfPhases() == 1) {
            this.system.setNumberOfPhases(1);
            return;
        }
        this.findLowesGibsPhaseIsChecked = false;
        int minGibbsPhase = 0;
        double minimumGibbsEnergy = 0.0;
        this.system.init(0);
        this.system.init(1);
        if (this.system.getPhase(0).getGibbsEnergy() < this.system.getPhase(1).getGibbsEnergy()) {
            minimumGibbsEnergy = this.system.getPhase(0).getGibbsEnergy();
        } else {
            minGibbsPhase = 1;
            minimumGibbsEnergy = this.system.getPhase(1).getGibbsEnergy();
        }
        if (this.system.getPhase(0).getNumberOfComponents() == 1 || this.system.getMaxNumberOfPhases() == 1) {
            this.system.setNumberOfPhases(1);
            if (minGibbsPhase == 0) {
                this.system.setPhaseIndex(0, 0);
            } else {
                this.system.setPhaseIndex(0, 1);
            }
            if (this.solidCheck) {
                ThermodynamicOperations operation2 = new ThermodynamicOperations(this.system);
                operation2.TPSolidflash();
            }
            return;
        }
        this.minGibsPhaseLogZ = new double[this.system.getPhase(0).getNumberOfComponents()];
        this.minGibsLogFugCoef = new double[this.system.getPhase(0).getNumberOfComponents()];
        for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            this.minGibsPhaseLogZ[i] = Math.log(this.system.getPhase(minGibbsPhase).getComponent(i).getz());
            this.minGibsLogFugCoef[i] = this.system.getPhase(minGibbsPhase).getComponent(i).getLogFugacityCoefficient();
        }
        this.presdiff = this.system.getPhase(1).getPressure() / this.system.getPhase(0).getPressure();
        if (Math.abs(this.system.getPhase(0).getPressure() - this.system.getPhase(1).getPressure()) > 1.0E-12) {
            this.i = 0;
            while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
                this.system.getPhase(0).getComponent(this.i).setK(this.system.getPhase(0).getComponent(this.i).getK() * this.presdiff);
                this.system.getPhase(1).getComponent(this.i).setK(this.system.getPhase(0).getComponent(this.i).getK());
                ++this.i;
            }
        }
        if (this.system.isChemicalSystem()) {
            this.system.getChemicalReactionOperations().solveChemEq(1, 0);
            this.system.getChemicalReactionOperations().solveChemEq(1, 1);
        }
        try {
            this.system.calcBeta();
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
        }
        this.system.calc_x_y();
        this.system.init(1);
        if (this.system.getBeta() > 1.0 - this.betaTolerance * 1.1 || this.system.getBeta() < this.betaTolerance * 1.1) {
            this.system.setBeta(0.5);
            this.sucsSubs();
        }
        for (int k = 0; k < 3; ++k) {
            if (!(this.system.getBeta() < 1.0 - this.betaTolerance * 1.1) || !(this.system.getBeta() > this.betaTolerance * 1.1)) continue;
            this.sucsSubs();
            if ((this.system.getGibbsEnergy() - minimumGibbsEnergy) / Math.abs(minimumGibbsEnergy) < -1.0E-12) break;
        }
        int totiter = 0;
        double tpdx = 1.0;
        double tpdy = 1.0;
        double dgonRT = 1.0;
        boolean passedTests = false;
        if (this.system.getBeta() > 1.0 - 1.1 * this.betaTolerance || this.system.getBeta() < 1.1 * this.betaTolerance) {
            tpdx = 1.0;
            tpdy = 1.0;
            dgonRT = 1.0;
        } else if (this.system.getGibbsEnergy() < minimumGibbsEnergy * 0.999999999999) {
            tpdx = -1.0;
            tpdy = -1.0;
            dgonRT = -1.0;
        } else {
            this.i = 0;
            while (this.i < this.system.getPhases()[0].getNumberOfComponents()) {
                tpdy += this.system.getPhase(0).getComponent(this.i).getx() * (Math.log(this.system.getPhase(0).getComponent(this.i).getFugacityCoefficient()) + Math.log(this.system.getPhase(0).getComponents()[this.i].getx()) - this.minGibsPhaseLogZ[this.i] - this.minGibsLogFugCoef[this.i]);
                tpdx += this.system.getPhase(1).getComponent(this.i).getx() * (Math.log(this.system.getPhase(1).getComponent(this.i).getFugacityCoefficient()) + Math.log(this.system.getPhase(1).getComponents()[this.i].getx()) - this.minGibsPhaseLogZ[this.i] - this.minGibsLogFugCoef[this.i]);
                ++this.i;
            }
            dgonRT = this.system.getPhase(0).getBeta() * tpdy + (1.0 - this.system.getPhase(0).getBeta()) * tpdx;
            if (dgonRT > 0.0) {
                if (tpdx < 0.0) {
                    this.i = 0;
                    while (this.i < this.system.getPhases()[0].getNumberOfComponents()) {
                        this.system.getPhase(0).getComponent(this.i).setK(Math.exp(Math.log(this.system.getPhase(1).getComponent(this.i).getFugacityCoefficient()) - this.minGibsLogFugCoef[this.i]) * this.presdiff);
                        this.system.getPhase(1).getComponent(this.i).setK(this.system.getPhase(0).getComponent(this.i).getK());
                        ++this.i;
                    }
                } else if (tpdy < 0.0) {
                    this.i = 0;
                    while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
                        this.system.getPhase(0).getComponents()[this.i].setK(Math.exp(this.minGibsLogFugCoef[this.i] - Math.log(this.system.getPhase(0).getComponent(this.i).getFugacityCoefficient())) * this.presdiff);
                        this.system.getPhase(1).getComponent(this.i).setK(this.system.getPhase(0).getComponent(this.i).getK());
                        ++this.i;
                    }
                } else {
                    passedTests = true;
                }
            }
        }
        if ((passedTests || dgonRT > 0.0 && tpdx > 0.0 && tpdy > 0.0 || Double.isNaN(this.system.getBeta())) && this.system.checkStability() && this.stabilityCheck()) {
            TPflash operation3;
            if (this.system.doMultiPhaseCheck()) {
                operation3 = new TPmultiflash(this.system, true);
                ((TPmultiflash)operation3).run();
            }
            if (this.solidCheck) {
                this.solidPhaseFlash();
            }
            if (this.system.isMultiphaseWaxCheck()) {
                operation3 = new TPmultiflashWAX(this.system, true);
                ((TPmultiflashWAX)operation3).run();
            }
            this.system.orderByDensity();
            this.system.init(1);
            return;
        }
        this.setNewK();
        this.gibbsEnergyOld = this.gibbsEnergy = this.system.getGibbsEnergy();
        double gasgib = this.system.getPhase(0).getGibbsEnergy();
        this.system.setPhaseType(0, 0);
        this.system.init(1, 0);
        double liqgib = this.system.getPhase(0).getGibbsEnergy();
        if (gasgib * (1.0 - Math.signum(gasgib) * 1.0E-8) < liqgib) {
            this.system.setPhaseType(0, 1);
        }
        this.system.init(1);
        int accelerateInterval = 7;
        int newtonLimit = 20;
        int timeFromLastGibbsFail = 0;
        double chemdev = 0.0;
        double oldChemDiff = 1.0;
        double diffChem = 1.0;
        do {
            this.iterations = 0;
            do {
                ++this.iterations;
                if (this.iterations < newtonLimit || this.system.isChemicalSystem() || !this.system.isImplementedCompositionDeriativesofFugacity()) {
                    if (timeFromLastGibbsFail > 6 && this.iterations % accelerateInterval == 0 && !this.system.isChemicalSystem() && !this.system.doSolidPhaseCheck()) {
                        this.accselerateSucsSubs();
                    } else {
                        this.sucsSubs();
                    }
                } else if (this.iterations >= newtonLimit && Math.abs(this.system.getPhase(0).getPressure() - this.system.getPhase(1).getPressure()) < 1.0E-5) {
                    if (this.iterations == newtonLimit) {
                        this.secondOrderSolver = new sysNewtonRhapsonTPflash(this.system, 2, this.system.getPhases()[0].getNumberOfComponents());
                    }
                    try {
                        this.deviation = this.secondOrderSolver.solve();
                    }
                    catch (Exception e) {
                        this.sucsSubs();
                    }
                } else {
                    this.sucsSubs();
                }
                this.gibbsEnergyOld = this.gibbsEnergy;
                this.gibbsEnergy = this.system.getGibbsEnergy();
                if ((this.gibbsEnergy - this.gibbsEnergyOld) / Math.abs(this.gibbsEnergyOld) > 0.001 && !this.system.isChemicalSystem()) {
                    this.resetK();
                    timeFromLastGibbsFail = 0;
                    continue;
                }
                ++timeFromLastGibbsFail;
                this.setNewK();
            } while (this.deviation > 1.0E-10 && this.iterations < this.maxNumberOfIterations);
            if (!this.system.isChemicalSystem()) continue;
            oldChemDiff = chemdev;
            chemdev = 0.0;
            double[] xchem = new double[this.system.getPhase(0).getNumberOfComponents()];
            for (int phase = 1; phase < this.system.getNumberOfPhases(); ++phase) {
                this.i = 0;
                while (this.i < this.system.getPhases()[phase].getNumberOfComponents()) {
                    xchem[this.i] = this.system.getPhase(phase).getComponent(this.i).getx();
                    ++this.i;
                }
                this.system.init(1);
                this.system.getChemicalReactionOperations().solveChemEq(phase, 1);
                this.i = 0;
                while (this.i < this.system.getPhases()[phase].getNumberOfComponents()) {
                    chemdev += Math.abs(xchem[this.i] - this.system.getPhase(phase).getComponent(this.i).getx()) / xchem[this.i];
                    ++this.i;
                }
            }
            diffChem = Math.abs(oldChemDiff - chemdev);
        } while (diffChem > 1.0E-6 && chemdev > 1.0E-6 && ++totiter < 300 || this.system.isChemicalSystem() && totiter < 2);
        if (this.system.isChemicalSystem()) {
            this.sucsSubs();
        }
        if (this.system.getPhase(0).getPhaseType() == 1) {
            gasgib = this.system.getPhase(0).getGibbsEnergy();
            this.system.setPhaseType(0, 0);
            this.system.init(1, 0);
            liqgib = this.system.getPhase(0).getGibbsEnergy();
        } else {
            liqgib = this.system.getPhase(0).getGibbsEnergy();
            this.system.setPhaseType(0, 1);
            this.system.init(1, 0);
            gasgib = this.system.getPhase(0).getGibbsEnergy();
        }
        if (gasgib * (1.0 - Math.signum(gasgib) * 1.0E-8) < liqgib) {
            this.system.setPhaseType(0, 1);
        }
        this.system.init(1);
        if (this.system.doMultiPhaseCheck()) {
            operation = new TPmultiflash(this.system, true);
            ((TPmultiflash)operation).run();
        }
        if (this.solidCheck) {
            this.solidPhaseFlash();
        }
        if (this.system.isMultiphaseWaxCheck()) {
            operation = new TPmultiflashWAX(this.system, true);
            ((TPmultiflashWAX)operation).run();
        }
        for (int i = 0; i < this.system.getNumberOfPhases(); ++i) {
            if (!(this.system.getBeta(i) < this.betaTolerance * 1.01)) continue;
            this.system.removePhase(i);
        }
        this.system.orderByDensity();
        this.system.init(1);
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        return null;
    }
}

