/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.flashOps.Flash;
import neqsim.thermodynamicOperations.flashOps.TPflash;
import org.jfree.chart.JFreeChart;

public class PUflash
extends Flash {
    private static final long serialVersionUID = 1000L;
    double Uspec = 0.0;
    Flash tpFlash;

    public PUflash() {
    }

    public PUflash(SystemInterface system, double Uspec) {
        this.system = system;
        this.tpFlash = new TPflash(system);
        this.Uspec = Uspec;
    }

    public double calcdQdTT() {
        double dQdTT = -this.system.getTemperature() * this.system.getTemperature() * this.system.getCv();
        return dQdTT;
    }

    public double calcdQdT() {
        double dQ = this.system.getInternalEnergy() - this.Uspec;
        return dQ;
    }

    public double solveQ() {
        double oldTemp = 1.0 / this.system.getTemperature();
        double nyTemp = 1.0 / this.system.getTemperature();
        double iterations = 1.0;
        double error = 1.0;
        double erorOld = 1.0E11;
        double factor = 0.8;
        do {
            if (error > erorOld) {
                factor /= 2.0;
            } else if (error < erorOld && factor < 0.8) {
                factor *= 1.1;
            }
            iterations += 1.0;
            oldTemp = nyTemp;
            this.system.init(2);
            nyTemp = oldTemp - factor * this.calcdQdT() / this.calcdQdTT();
            if (Double.isNaN(nyTemp)) {
                nyTemp = oldTemp + 1.0;
            }
            this.system.setTemperature(1.0 / nyTemp);
            this.tpFlash.run();
            erorOld = error;
        } while ((error = Math.abs((1.0 / nyTemp - 1.0 / oldTemp) / (1.0 / oldTemp))) > 1.0E-8 && iterations < 500.0);
        return 1.0 / nyTemp;
    }

    @Override
    public void run() {
        this.tpFlash.run();
        this.solveQ();
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        return null;
    }
}

