/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.flashOps.Flash;
import neqsim.thermodynamicOperations.flashOps.QfuncFlash;
import neqsim.thermodynamicOperations.flashOps.TPflash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PSFlashGERG2008
extends QfuncFlash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(PSFlashGERG2008.class);
    double Sspec = 0.0;
    Flash tpFlash;
    double entropy_GERG2008 = 0.0;
    double cP_GERG2008 = 0.0;

    public PSFlashGERG2008() {
    }

    public PSFlashGERG2008(SystemInterface system, double Sspec) {
        this.system = system;
        this.tpFlash = new TPflash(system);
        this.Sspec = Sspec;
    }

    @Override
    public double calcdQdTT() {
        return -this.cP_GERG2008 / this.system.getTemperature();
    }

    @Override
    public double calcdQdT() {
        return -this.entropy_GERG2008 + this.Sspec;
    }

    @Override
    public double solveQ() {
        double oldTemp = this.system.getTemperature();
        double nyTemp = this.system.getTemperature();
        int iterations = 1;
        double error = 1.0;
        double erorOld = 1.0E11;
        double factor = 0.8;
        boolean correctFactor = true;
        double newCorr = 1.0;
        do {
            if (error > erorOld && factor > 0.1 && correctFactor) {
                factor *= 0.5;
            } else if (error < erorOld && correctFactor) {
                factor = 1.0;
            }
            ++iterations;
            oldTemp = this.system.getTemperature();
            double[] gergProps = this.system.getPhase(0).getProperties_GERG2008();
            this.entropy_GERG2008 = gergProps[8] * this.system.getPhase(0).getNumberOfMolesInPhase();
            this.cP_GERG2008 = gergProps[10] * this.system.getPhase(0).getNumberOfMolesInPhase();
            newCorr = factor * this.calcdQdT() / this.calcdQdTT();
            nyTemp = oldTemp - newCorr;
            if (Math.abs(this.system.getTemperature() - nyTemp) > 10.0) {
                nyTemp = this.system.getTemperature() - Math.signum(this.system.getTemperature() - nyTemp) * 10.0;
                correctFactor = false;
            } else if (nyTemp < 0.0) {
                nyTemp = Math.abs(this.system.getTemperature() - 10.0);
                correctFactor = false;
            } else if (Double.isNaN(nyTemp)) {
                nyTemp = oldTemp + 1.0;
                correctFactor = false;
            } else {
                correctFactor = true;
            }
            this.system.setTemperature(nyTemp);
            erorOld = error;
        } while (((error = Math.abs(this.calcdQdT())) + erorOld > 1.0E-8 || iterations < 3) && iterations < 200);
        return nyTemp;
    }

    @Override
    public void run() {
        this.tpFlash.run();
        if (this.system.getNumberOfPhases() > 1) {
            logger.error("PSFlashGERG2008 only supprt single phase gas calculations");
            return;
        }
        this.solveQ();
        this.system.init(3);
    }
}

