/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.flashOps.Flash;
import neqsim.thermodynamicOperations.flashOps.TPflash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.chart.JFreeChart;

public class PHsolidFlash
extends Flash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(PHsolidFlash.class);
    Flash tpFlash;
    int refluxPhase = 0;
    double enthalpyspec = 0.5;

    public PHsolidFlash() {
    }

    public PHsolidFlash(SystemInterface system, double ent) {
        this.system = system;
        this.tpFlash = new TPflash(this.system, true);
        this.enthalpyspec = ent;
    }

    @Override
    public void run() {
        double err = 0.0;
        int iter = 0;
        double f_func = 0.0;
        double f_func_old = 0.0;
        double df_func_dt = 0.0;
        double t_old = 0.0;
        double t_oldold = 0.0;
        this.tpFlash.run();
        double dt = 10.0;
        do {
            ++iter;
            f_func_old = f_func;
            t_oldold = t_old;
            t_old = this.system.getTemperature();
            this.system.init(3);
            f_func = this.enthalpyspec - this.system.getEnthalpy();
            logger.info("entalp diff " + f_func);
            df_func_dt = (f_func - f_func_old) / (t_old - t_oldold);
            err = Math.abs(f_func);
            if (iter < 2) {
                if (f_func > 0.0) {
                    this.system.setTemperature(this.system.getTemperature() + 0.1);
                } else if (f_func < 0.0) {
                    this.system.setTemperature(this.system.getTemperature() - 0.1);
                }
            } else {
                dt = f_func / df_func_dt;
                if (Math.abs(dt) > 2.0) {
                    dt = Math.signum(dt) * 2.0;
                }
                this.system.setTemperature(this.system.getTemperature() - 0.8 * dt);
            }
            this.tpFlash.run();
            logger.info("temp " + this.system.getTemperature() + " err " + err);
        } while (Math.abs(dt) > 1.0E-8 && iter < 200);
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        return null;
    }
}

