/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.flashOps.Flash;
import neqsim.thermodynamicOperations.flashOps.TPflash;
import neqsim.thermodynamicOperations.flashOps.sysNewtonRhapsonPHflash;
import org.jfree.chart.JFreeChart;

public class PHflash
extends Flash {
    private static final long serialVersionUID = 1000L;
    double Hspec = 0.0;
    Flash tpFlash;
    int type = 0;

    public PHflash() {
    }

    public PHflash(SystemInterface system, double Hspec, int type) {
        this.system = system;
        this.tpFlash = new TPflash(system);
        this.Hspec = Hspec;
        this.type = type;
    }

    public double calcdQdTT() {
        double dQdTT = -this.system.getTemperature() * this.system.getTemperature() * this.system.getCp();
        return dQdTT / Math.abs(this.Hspec);
    }

    public double calcdQdT() {
        double dQ = (this.system.getEnthalpy() - this.Hspec) / Math.abs(this.Hspec);
        return dQ;
    }

    public double solveQ() {
        double oldTemp = 1.0 / this.system.getTemperature();
        double nyTemp = 1.0 / this.system.getTemperature();
        double iterations = 1.0;
        double error = 1.0;
        double erorOld = 1.0E10;
        double factor = 0.8;
        double newCorr = 1.0;
        this.system.init(2);
        boolean correctFactor = true;
        double maxTemperature = 1.0E10;
        double minTemperature = 0.0;
        do {
            if (Math.abs(error) > Math.abs(erorOld) && factor > 0.1 && correctFactor) {
                factor *= 0.5;
            } else if (Math.abs(error) < Math.abs(erorOld) && correctFactor) {
                factor = iterations / (iterations + 1.0) * 1.0;
            }
            iterations += 1.0;
            oldTemp = nyTemp;
            newCorr = factor * this.calcdQdT() / this.calcdQdTT();
            nyTemp = oldTemp - newCorr;
            if (iterations > 150.0 && Math.abs(error) < 10.0) {
                nyTemp = 1.0 / (this.system.getTemperature() - Math.signum(this.system.getTemperature() - 1.0 / nyTemp) * Math.abs(error));
                correctFactor = false;
            } else if (Math.abs(this.system.getTemperature() - 1.0 / nyTemp) > 10.0) {
                nyTemp = 1.0 / (this.system.getTemperature() - Math.signum(this.system.getTemperature() - 1.0 / nyTemp) * 10.0);
                correctFactor = false;
            } else if (nyTemp < 0.0) {
                nyTemp = Math.abs(1.0 / (this.system.getTemperature() + 10.0));
                correctFactor = false;
            } else if (Double.isNaN(nyTemp)) {
                nyTemp = oldTemp + 0.1;
                correctFactor = false;
            } else {
                correctFactor = true;
            }
            this.system.setTemperature(1.0 / nyTemp);
            if (this.system.getTemperature() > maxTemperature) {
                this.system.setTemperature(maxTemperature - 0.1);
            } else if (this.system.getTemperature() < minTemperature) {
                this.system.setTemperature(minTemperature + 0.1);
            }
            this.tpFlash.run();
            this.system.init(2);
            erorOld = error;
            error = this.calcdQdT();
            if (error > 0.0 && this.system.getTemperature() > maxTemperature) {
                maxTemperature = this.system.getTemperature();
                continue;
            }
            if (!(error < 0.0) || !(this.system.getTemperature() < minTemperature)) continue;
            minTemperature = this.system.getTemperature();
        } while ((Math.abs(error) + Math.abs(erorOld) > 1.0E-8 || iterations < 3.0) && iterations < 200.0);
        return 1.0 / nyTemp;
    }

    public double solveQ2() {
        double oldTemp = 1.0 / this.system.getTemperature();
        double nyTemp = 1.0 / this.system.getTemperature();
        double iterations = 1.0;
        double error = 1.0;
        double erorOld = 1.0E10;
        double factor = 0.8;
        double newCorr = 1.0;
        this.system.init(2);
        boolean correctFactor = true;
        do {
            if (error > erorOld && factor > 0.1 && correctFactor) {
                factor *= 0.5;
            } else if (error < erorOld && correctFactor) {
                factor = iterations / (iterations + 1.0) * 1.0;
            }
            iterations += 1.0;
            oldTemp = nyTemp;
            newCorr = factor * this.calcdQdT() / this.calcdQdTT();
            nyTemp = oldTemp - newCorr;
            if (Math.abs(this.system.getTemperature() - 1.0 / nyTemp) > 10.0) {
                nyTemp = 1.0 / (this.system.getTemperature() - Math.signum(this.system.getTemperature() - 1.0 / nyTemp) * 10.0);
                correctFactor = false;
            } else if (nyTemp < 0.0) {
                nyTemp = Math.abs(1.0 / (this.system.getTemperature() + 10.0));
                correctFactor = false;
            } else if (Double.isNaN(nyTemp)) {
                nyTemp = oldTemp + 0.1;
                correctFactor = false;
            } else {
                correctFactor = true;
            }
            this.system.setTemperature(1.0 / nyTemp);
            this.tpFlash.run();
            this.system.init(2);
            erorOld = error;
        } while (((error = Math.abs(this.calcdQdT())) + erorOld > 1.0E-8 || iterations < 3.0) && iterations < 200.0);
        return 1.0 / nyTemp;
    }

    @Override
    public void run() {
        this.tpFlash.run();
        if (this.type == 0) {
            this.solveQ();
        } else {
            sysNewtonRhapsonPHflash secondOrderSolver = new sysNewtonRhapsonPHflash(this.system, 2, this.system.getPhases()[0].getNumberOfComponents(), 0);
            secondOrderSolver.setSpec(this.Hspec);
            secondOrderSolver.solve(1);
        }
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        return null;
    }
}

