/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.furstIonicParameters;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardtFunction;
import neqsim.thermo.system.SystemElectrolyteCPAstatoil;
import neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.furstIonicParameters.FurstIonicParameterFunction;
import neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.furstIonicParameters.FurstIonicParameterFunction_Activity;
import neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.furstIonicParameters.FurstIonicParameterFunction_Density;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestFurstIonicParameterFunction {
    static Logger logger = LogManager.getLogger(TestFurstIonicParameterFunction.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        double[] guess = new double[]{7.52E-8, 3.7242E-6, 2.50998E-5, 1.98635E-5, -3.11E-8, -6.63E-7};
        ResultSet dataSet = database.getResultSet("SELECT * FROM ionicData WHERE ion1<>'H3Oplus2' ORDER BY ion1,ion2,x2");
        try {
            SampleValue sample;
            double[] standardDeviation1;
            double[] sample1;
            SystemElectrolyteCPAstatoil testSystem;
            double x2;
            LevenbergMarquardtFunction function;
            logger.info("adding....");
            for (int numb = 0; dataSet.next() && numb < 22265; ++numb) {
                function = new FurstIonicParameterFunction();
                function.setInitialGuess(guess);
                x2 = Double.parseDouble(dataSet.getString("x2"));
                testSystem = new SystemElectrolyteCPAstatoil(280.0, 1.0);
                testSystem.addComponent("water", Double.parseDouble(dataSet.getString("x1")));
                testSystem.addComponent(dataSet.getString("Ion1"), x2);
                testSystem.addComponent(dataSet.getString("Ion2"), Double.parseDouble(dataSet.getString("x3")));
                testSystem.createDatabase(true);
                testSystem.setMixingRule(10);
                testSystem.setTemperature(Double.parseDouble(dataSet.getString("Temperature")));
                testSystem.setPressure(Double.parseDouble(dataSet.getString("Pressure")));
                testSystem.init(0);
                sample1 = new double[]{x2 / 0.01802};
                standardDeviation1 = new double[]{0.01};
                double osmcoef = Double.parseDouble(dataSet.getString("OsmoticCoefficient"));
                testSystem.init(1);
                sample = new SampleValue(osmcoef, osmcoef / 100.0, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(dataSet.getString("Reference"));
                sample.setDescription(dataSet.getString("Description"));
                sampleList.add(sample);
            }
            dataSet = database.getResultSet("SELECT * FROM ionicData WHERE ion1='Na+' AND ion2='Cl-'");
            logger.info("setting new for activity");
            while (!dataSet.next()) {
                function = new FurstIonicParameterFunction_Activity();
                function.setInitialGuess(guess);
                x2 = Double.parseDouble(dataSet.getString("x2"));
                testSystem = new SystemElectrolyteCPAstatoil(280.0, 1.0);
                testSystem.addComponent(dataSet.getString("ComponentSolvent"), Double.parseDouble(dataSet.getString("x1")));
                testSystem.addComponent(dataSet.getString("Ion1"), x2);
                testSystem.addComponent(dataSet.getString("Ion2"), Double.parseDouble(dataSet.getString("x3")));
                testSystem.createDatabase(true);
                testSystem.setMixingRule(10);
                testSystem.setTemperature(Double.parseDouble(dataSet.getString("Temperature")));
                testSystem.setPressure(Double.parseDouble(dataSet.getString("Pressure")));
                testSystem.init(0);
                sample1 = new double[]{x2 / 0.01802};
                standardDeviation1 = new double[]{0.01};
                double ionact = Double.parseDouble(dataSet.getString("IonicActivity"));
                sample = new SampleValue(ionact, ionact, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(dataSet.getString("Reference"));
                sample.setDescription(dataSet.getString("Description"));
                sampleList.add(sample);
            }
            dataSet = database.getResultSet("SELECT * FROM saltdens WHERE ion1='Na+' AND ion2='Cl-'");
            logger.info("fitting to ionic density");
            while (!dataSet.next()) {
                function = new FurstIonicParameterFunction_Density();
                function.setInitialGuess(guess);
                x2 = Double.parseDouble(dataSet.getString("molfrac1"));
                double x3 = Double.parseDouble(dataSet.getString("molfrac2"));
                double x1 = 1.0 - x2 - x3;
                SystemElectrolyteCPAstatoil testSystem2 = new SystemElectrolyteCPAstatoil(280.0, 1.0);
                testSystem2.addComponent(dataSet.getString("solvent"), x1);
                testSystem2.addComponent(dataSet.getString("Ion1"), x2);
                testSystem2.addComponent(dataSet.getString("Ion2"), x3);
                testSystem2.setTemperature(Double.parseDouble(dataSet.getString("temperature")));
                testSystem2.setPressure(Double.parseDouble(dataSet.getString("pressure")));
                testSystem2.createDatabase(true);
                testSystem2.setMixingRule(7);
                testSystem2.init(0);
                double[] sample12 = new double[]{x2 / 0.01802};
                double[] standardDeviation12 = new double[]{0.01};
                double density2 = Double.parseDouble(dataSet.getString("density")) * 1000.0;
                SampleValue sample2 = new SampleValue(density2, density2 / 100.0, sample12, standardDeviation12);
                sample2.setFunction(function);
                sample2.setThermodynamicSystem(testSystem2);
                sampleList.add(sample2);
            }
        }
        catch (Exception e) {
            logger.error("database error: ", (Throwable)e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayResult();
        optim.displayCurveFit();
        optim.writeToCdfFile("c:/testFit.nc");
        optim.writeToTextFile("c:/testFit.txt");
    }
}

