/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.acentricFactorFitting;

import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkMathiasCopeman;
import neqsim.thermo.system.SystemSrkTwuCoonEos;
import neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.acentricFactorFitting.MathiasCopeman;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestMathiasCopeman {
    static Logger logger = LogManager.getLogger(TestMathiasCopeman.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        String ComponentName = "methane";
        try {
            MathiasCopeman function = new MathiasCopeman();
            double[] guess = new double[]{0.5379142011507664, -0.3219393792621987, 0.4361033659755846};
            function.setInitialGuess(guess);
            SystemSrkMathiasCopeman testSystem = new SystemSrkMathiasCopeman(280.0, 5.0);
            testSystem.addComponent(ComponentName, 100.0);
            testSystem.setMixingRule(2);
            testSystem.createDatabase(true);
            SystemSrkTwuCoonEos System2 = new SystemSrkTwuCoonEos(280.0, 5.0);
            System2.addComponent(ComponentName, 100.0);
            System2.setMixingRule(2);
            ThermodynamicOperations Ops = new ThermodynamicOperations(System2);
            double Ttp = testSystem.getPhase(0).getComponent(0).getTriplePointTemperature();
            double TC = testSystem.getPhase(0).getComponent(0).getTC();
            for (int i = 0; i < 30; ++i) {
                double temperature = Ttp + (TC - Ttp) / 30.0 * (double)i;
                System2.setTemperature(temperature);
                Ops.dewPointPressureFlash();
                double pressure = System2.getPressure();
                double[] sample1 = new double[]{temperature};
                double[] standardDeviation1 = new double[]{0.1, 0.1, 0.1};
                double val = Math.log(pressure);
                SampleValue sample = new SampleValue(val, val / 100.0, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setReference("NIST");
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.displayCurveFit();
    }
}

