/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.acentricFactorFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkTwuCoonParamEos;
import neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.acentricFactorFitting.TwuCoon;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestAcentricSchwartzentruber {
    static Logger logger = LogManager.getLogger(TestAcentricSchwartzentruber.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM PureComponentVapourPressures WHERE ComponentName='mercury' AND VapourPressure<40 ORDER BY Reference,Temperature");
        try {
            while (dataSet.next()) {
                TwuCoon function = new TwuCoon();
                double[] guess = new double[]{0.09245, 0.9784, 2.244};
                function.setInitialGuess(guess);
                SystemSrkTwuCoonParamEos testSystem = new SystemSrkTwuCoonParamEos(280.0, 0.01);
                testSystem.addComponent(dataSet.getString("ComponentName"), 100.0);
                double[] sample1 = new double[]{Double.parseDouble(dataSet.getString("Temperature"))};
                double[] standardDeviation1 = new double[]{0.1, 0.1, 0.1};
                double val = Math.log(Double.parseDouble(dataSet.getString("VapourPressure")));
                SampleValue sample = new SampleValue(val, val / 100.0, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setReference(dataSet.getString("Reference"));
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.runMonteCarloSimulation();
        optim.displayCurveFit();
    }
}

