/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.AntoineParameter;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.AntoineParameter.AntoineSolidFunctionS8;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestSolidAntoine_S8 {
    static Logger logger = LogManager.getLogger(TestSolidAntoine_S8.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM PureComponentVapourPressures WHERE ComponentName='S8' AND VapourPressure<100");
        try {
            while (dataSet.next()) {
                AntoineSolidFunctionS8 function = new AntoineSolidFunctionS8();
                double[] guess = new double[]{11.81, -8356.0};
                function.setInitialGuess(guess);
                SystemSrkEos testSystem = new SystemSrkEos(280.0, 0.001);
                testSystem.addComponent(dataSet.getString("ComponentName"), 100.0);
                double[] sample1 = new double[]{Double.parseDouble(dataSet.getString("Temperature"))};
                double vappres = Double.parseDouble(dataSet.getString("VapourPressure"));
                double[] standardDeviation1 = new double[]{0.15};
                SampleValue sample = new SampleValue(vappres, Double.parseDouble(dataSet.getString("StandardDeviation")), sample1, standardDeviation1);
                sample.setFunction(function);
                function.setInitialGuess(guess);
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
        optim.writeToCdfFile("c:/testFit.nc");
        optim.writeToTextFile("c:/testFit.txt");
    }
}

