/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.ionicInteractionCoefficientFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemFurstElectrolyteEos;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.ionicInteractionCoefficientFitting.IonicInteractionParameterFittingFunction_Sleipnernoacid;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestIonicInteractionParameterFitting_Sleipnernoacid {
    static Logger logger = LogManager.getLogger(TestIonicInteractionParameterFitting_Sleipnernoacid.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM Sleipner");
        try {
            int i = 0;
            while (dataSet.next()) {
                ++i;
                IonicInteractionParameterFittingFunction_Sleipnernoacid function = new IonicInteractionParameterFittingFunction_Sleipnernoacid();
                double[] guess = new double[]{-2.2E-5};
                double ID = Double.parseDouble(dataSet.getString("ID"));
                double x1 = Double.parseDouble(dataSet.getString("x1"));
                double x2 = Double.parseDouble(dataSet.getString("x2"));
                double x3 = Double.parseDouble(dataSet.getString("x3"));
                double x4 = Double.parseDouble(dataSet.getString("x4"));
                double temperature = Double.parseDouble(dataSet.getString("Temperature"));
                double pressure = Double.parseDouble(dataSet.getString("Pressure"));
                SystemFurstElectrolyteEos testSystem = new SystemFurstElectrolyteEos(temperature, pressure);
                testSystem.addComponent("CO2", x1);
                testSystem.addComponent("water", x2);
                testSystem.addComponent("MDEA", x4 - x3);
                testSystem.addComponent("Ac-", x3);
                testSystem.addComponent("MDEA+", x3);
                testSystem.chemicalReactionInit();
                testSystem.createDatabase(true);
                testSystem.setMixingRule(4);
                testSystem.init(0);
                double[] sample1 = new double[]{temperature, x1 / (x4 - x3)};
                double[] standardDeviation1 = new double[]{0.01};
                double stddev = 0.01;
                SampleValue sample = new SampleValue(pressure, stddev, sample1, standardDeviation1);
                function.setInitialGuess(guess);
                sample.setFunction(function);
                sample.setDescription(Double.toString(ID));
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.displayCurveFit();
    }
}

