/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.ionicInteractionCoefficientFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemFurstElectrolyteEos;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.ionicInteractionCoefficientFitting.IonicInteractionParameterFittingFunction;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestIonicInteractionParameterFittingPiperazine {
    static Logger logger = LogManager.getLogger(TestIonicInteractionParameterFittingPiperazine.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        double[] guess = new double[]{-1.86849E-4, -6.868943E-4, -2.10224E-5, -2.324934E-4, 5.0E-4};
        ResultSet dataSet = database.getResultSet("SELECT * FROM CO2waterMDEAPiperazine");
        try {
            for (int i = 0; dataSet.next() && i < 16; ++i) {
                IonicInteractionParameterFittingFunction function = new IonicInteractionParameterFittingFunction();
                SystemFurstElectrolyteEos testSystem = new SystemFurstElectrolyteEos(298.15, 1.0);
                testSystem.addComponent("CO2", Double.parseDouble(dataSet.getString("x1")));
                testSystem.addComponent("MDEA", Double.parseDouble(dataSet.getString("x3")));
                testSystem.addComponent("piperazine", Double.parseDouble(dataSet.getString("x4")));
                testSystem.addComponent("water", Double.parseDouble(dataSet.getString("x2")));
                double temperature = Double.parseDouble(dataSet.getString("Temperature"));
                double pressure = Double.parseDouble(dataSet.getString("PressureCO2"));
                testSystem.setTemperature(temperature);
                testSystem.setPressure(pressure + 1.0);
                testSystem.chemicalReactionInit();
                testSystem.createDatabase(true);
                testSystem.setMixingRule(4);
                testSystem.init(0);
                double[] sample1 = new double[]{testSystem.getPhase(0).getComponent(0).getNumberOfmoles() / testSystem.getPhase(0).getComponent(1).getNumberOfmoles()};
                double[] standardDeviation1 = new double[]{0.01};
                double stddev = pressure;
                SampleValue sample = new SampleValue(pressure, stddev, sample1, standardDeviation1);
                function.setInitialGuess(guess);
                sample.setFunction(function);
                sample.setReference(dataSet.getString("Reference"));
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.displayCurveFit();
        optim.writeToCdfFile("c:/testFit.nc");
        optim.writeToTextFile("c:/testFit.txt");
    }
}

