/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.ionicInteractionCoefficientFitting;

import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardtFunction;
import neqsim.thermo.mixingRule.HVmixingRuleInterface;
import neqsim.thermo.phase.PhaseEosInterface;
import neqsim.thermo.phase.PhaseModifiedFurstElectrolyteEos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IonicInteractionParameterFittingFunctionCH4
extends LevenbergMarquardtFunction {
    static Logger logger = LogManager.getLogger(IonicInteractionParameterFittingFunctionCH4.class);

    @Override
    public double calcValue(double[] dependentValues) {
        try {
            this.thermoOps.bubblePointPressureFlash(false);
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
        return this.system.getPressure();
    }

    @Override
    public double calcTrueValue(double val) {
        return val;
    }

    @Override
    public void setFittingParams(int i, double value) {
        this.params[i] = value;
        int MDEAplusNumb = 0;
        int MDEANumb = 0;
        int methanenumb = 0;
        int CO2Numb = 0;
        int HCO3numb = 0;
        int Waternumb = 0;
        int methane = 0;
        int j = 0;
        do {
            MDEAplusNumb = j++;
        } while (!this.system.getPhases()[0].getComponents()[j - 1].getComponentName().equals("MDEA+"));
        j = 0;
        do {
            MDEANumb = j++;
        } while (!this.system.getPhases()[0].getComponents()[j - 1].getComponentName().equals("MDEA"));
        j = 0;
        do {
            CO2Numb = j++;
        } while (!this.system.getPhases()[0].getComponents()[j - 1].getComponentName().equals("CO2"));
        j = 0;
        do {
            HCO3numb = j++;
        } while (!this.system.getPhases()[0].getComponents()[j - 1].getComponentName().equals("HCO3-"));
        j = 0;
        do {
            Waternumb = j++;
        } while (!this.system.getPhases()[0].getComponents()[j - 1].getComponentName().equals("water"));
        j = 0;
        do {
            methanenumb = j++;
        } while (!this.system.getPhases()[0].getComponents()[j - 1].getComponentName().equals("methane"));
        if (i == 10) {
            ((PhaseEosInterface)this.system.getPhases()[0]).getMixingRule().setBinaryInteractionParameter(methane, CO2Numb, value);
            ((PhaseEosInterface)this.system.getPhases()[1]).getMixingRule().setBinaryInteractionParameter(methane, CO2Numb, value);
        }
        if (i == 1) {
            ((PhaseEosInterface)this.system.getPhases()[0]).getMixingRule().setBinaryInteractionParameter(methane, MDEANumb, value * 1000.0);
            ((PhaseEosInterface)this.system.getPhases()[1]).getMixingRule().setBinaryInteractionParameter(methane, MDEANumb, value * 1000.0);
        }
        if (i == 2) {
            ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[0]).getElectrolyteMixingRule().setWijT1Parameter(MDEAplusNumb, methane, value);
            ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[1]).getElectrolyteMixingRule().setWijT1Parameter(MDEAplusNumb, methane, value);
        }
        if (i == 0) {
            ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[0]).getElectrolyteMixingRule().setWijParameter(MDEAplusNumb, methane, value);
            ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[1]).getElectrolyteMixingRule().setWijParameter(MDEAplusNumb, methane, value);
        }
        if (i == 11) {
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[0]).getMixingRule()).setHVDijParameter(methane, MDEANumb, value * 10000.0);
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[1]).getMixingRule()).setHVDijParameter(methane, MDEANumb, value * 10000.0);
        }
        if (i == 21) {
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[0]).getMixingRule()).setHVDijParameter(MDEANumb, methane, value * 10000.0);
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[1]).getMixingRule()).setHVDijParameter(MDEANumb, methane, value * 10000.0);
        }
        if (i == 61) {
            ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[0]).getElectrolyteMixingRule().setWijParameter(MDEAplusNumb, CO2Numb, value);
            ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[1]).getElectrolyteMixingRule().setWijParameter(MDEAplusNumb, CO2Numb, value);
        }
        if (i == 22) {
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[0]).getMixingRule()).setHVDijParameter(CO2Numb, MDEANumb, value);
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[1]).getMixingRule()).setHVDijParameter(CO2Numb, MDEANumb, value);
        }
        if (i == 32) {
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[0]).getMixingRule()).setHVDijParameter(MDEANumb, CO2Numb, value);
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[1]).getMixingRule()).setHVDijParameter(MDEANumb, CO2Numb, value);
        }
    }
}

