/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.HuronVidalParameterFitting;

import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemEos;
import neqsim.thermo.system.SystemPrEos;
import neqsim.thermo.system.SystemSrkCPAs;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.HuronVidalParameterFitting.BinaryHVparameterFitToActivityCoefficientFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestBinaryHVfitToActivityCPA
implements Cloneable {
    static Logger logger = LogManager.getLogger(TestBinaryHVfitToActivityCPA.class);

    public static void main(String[] args) {
        SampleValue sample;
        double[] standardDeviation1;
        double[] sample1;
        double activ;
        SystemSrkCPAs testSystem2;
        SystemEos testSystem;
        BinaryHVparameterFitToActivityCoefficientFunction function;
        int j;
        int i;
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        double[] parameterGuess = new double[]{-359.2, 351.7, -1.31, 2.44, 0.25};
        int numb = 0;
        for (i = 0; i < 1; ++i) {
            ++numb;
            for (j = 0; j < 10; ++j) {
                function = new BinaryHVparameterFitToActivityCoefficientFunction();
                testSystem = new SystemSrkEos(268.15 + 10.0 * (double)i, 1.0);
                testSystem.addComponent("water", 100.0 - (double)(j * j));
                testSystem.addComponent("methanolPVTsim", 1.0 + (double)(j * j));
                testSystem.createDatabase(true);
                testSystem.setMixingRule(4);
                testSystem.init(0);
                testSystem2 = new SystemSrkCPAs(268.15 + 10.0 * (double)i, 1.0);
                testSystem2.addComponent("water", 100.0 - (double)(j * j));
                testSystem2.addComponent("methanol", 1.0 + (double)(j * j));
                testSystem2.createDatabase(true);
                testSystem2.setMixingRule(9);
                testSystem2.init(0);
                testSystem2.init(2);
                activ = testSystem2.getPhase(1).getActivityCoefficient(0);
                logger.info("activity " + activ + " molfraction MEG " + testSystem2.getPhase(1).getComponent("methanol").getx());
                function.setInitialGuess(parameterGuess);
                sample1 = new double[]{testSystem2.getPhase(1).getComponent("methanol").getx(), testSystem.getTemperature()};
                standardDeviation1 = new double[]{1.0};
                sample = new SampleValue(activ, activ / 100.0, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        for (i = 0; i < 0; ++i) {
            ++numb;
            for (j = 0; j < 10; ++j) {
                function = new BinaryHVparameterFitToActivityCoefficientFunction();
                testSystem = new SystemPrEos(300.0 + 20.0 * (double)i, 1.0);
                testSystem.addComponent("water", 100.0 - (double)(j * j));
                testSystem.addComponent("methanolPVTsim", 1.0 + (double)(j * j));
                testSystem.createDatabase(true);
                testSystem.setMixingRule(4);
                testSystem.init(0);
                testSystem2 = new SystemSrkCPAs(300.0 + 20.0 * (double)i, 1.0);
                testSystem2.addComponent("water", 100.0 - (double)(j * j));
                testSystem.addComponent("methanolPVTsim", 1.0 + (double)(j * j));
                testSystem2.setMixingRule(7);
                testSystem2.init(0);
                testSystem2.init(2);
                activ = testSystem2.getPhase(1).getActivityCoefficient(0);
                logger.info("activity " + activ + " molfraction MEG " + testSystem2.getPhase(1).getComponent("MEG").getx());
                function.setInitialGuess(parameterGuess);
                sample1 = new double[]{(double)numb / 1000.0, testSystem.getTemperature()};
                standardDeviation1 = new double[]{1.0};
                sample = new SampleValue(activ, activ / 100.0, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        for (i = 0; i < 0; ++i) {
            ++numb;
            for (j = 0; j < 0; ++j) {
                function = new BinaryHVparameterFitToActivityCoefficientFunction();
                testSystem = new SystemPrEos(253.0 + 20.0 * (double)i, 1.0);
                testSystem.addComponent("methanolPVTsim", 1.0 + (double)(j * j));
                testSystem.addComponent("water", 100.0 - (double)(j * 10));
                testSystem.createDatabase(true);
                testSystem.setMixingRule(4);
                testSystem.init(0);
                testSystem2 = new SystemSrkCPAs(253.0 + 20.0 * (double)i, 1.0);
                testSystem.addComponent("methanolPVTsim", 1.0 + (double)(j * j));
                testSystem2.addComponent("water", 100.0 - (double)(j * 10));
                testSystem2.setMixingRule(7);
                testSystem2.init(0);
                testSystem2.init(2);
                activ = testSystem2.getPhase(1).getActivityCoefficient(0);
                logger.info("activity " + activ + " molfraction MEG " + testSystem2.getPhase(1).getComponent("MEG").getx());
                function.setInitialGuess(parameterGuess);
                sample1 = new double[]{(double)numb / 1000.0, testSystem.getTemperature()};
                standardDeviation1 = new double[]{1.0};
                sample = new SampleValue(activ, activ / 100.0, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.displayCurveFit();
        optim.writeToTextFile("c:/testFit.txt");
    }
}

