/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.HuronVidalParameterFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkSchwartzentruberEos;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.HuronVidalParameterFitting.BinaryHVParameterFittingToSolubilityData;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestBinaryHVParameterFittingToSolubilityDatawaterCO2 {
    static Logger logger = LogManager.getLogger(TestBinaryHVParameterFittingToSolubilityDatawaterCO2.class);

    public static void main(String[] args) {
        SystemSrkSchwartzentruberEos testSystem;
        BinaryHVParameterFittingToSolubilityData function;
        int p;
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM CO2watersolubility WHERE pressureMPA<5 AND reference IN ('[18]', '[35]', '[36]', '[37]', '[38]', '[39]', '[40]', '[41]','[42]', '[32]', '[33]', '[34]')");
        try {
            for (p = 0; dataSet.next() && p < 550; ++p) {
                function = new BinaryHVParameterFittingToSolubilityData(1, 10);
                testSystem = new SystemSrkSchwartzentruberEos(Double.parseDouble(dataSet.getString("temperatureC")) + 273.15, 10.0 * Double.parseDouble(dataSet.getString("pressureMPA")));
                double valCO2 = Double.parseDouble(dataSet.getString("xCO2"));
                testSystem.addComponent("CO2", valCO2);
                testSystem.addComponent("water", 100.0 - valCO2);
                testSystem.createDatabase(true);
                testSystem.setMixingRule("HV");
                testSystem.init(0);
                double[] sample1 = new double[]{testSystem.getPressure(), testSystem.getTemperature()};
                double[] standardDeviation1 = new double[]{0.01};
                double val = testSystem.getPressure();
                double sdev = val / 100.0;
                SampleValue sample = new SampleValue(val, sdev, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(Double.toString(testSystem.getTemperature()));
                sample.setDescription(dataSet.getString("reference"));
                double[] parameterGuess = new double[]{5251.7374371982, -3121.2788585048, -0.8420253536, -0.5123316046};
                function.setInitialGuess(parameterGuess);
                sampleList.add(sample);
                logger.info("liq points " + p);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        dataSet = database.getResultSet("SELECT * FROM LuciaData8 WHERE Component='CO2' AND ID<3000 AND Temperature>250 AND Pressure<700000000 AND Temperature<420 AND Y<>NULL AND Y>0.0000000001 ORDER BY Temperature,Pressure");
        try {
            for (p = 0; !dataSet.next() && p < 100; ++p) {
                function = new BinaryHVParameterFittingToSolubilityData(0, 0);
                testSystem = new SystemSrkSchwartzentruberEos(Double.parseDouble(dataSet.getString("Temperature")), Double.parseDouble(dataSet.getString("Pressure")) / 100000.0);
                testSystem.addComponent("CO2", 1.0);
                testSystem.addComponent("water", 10.0);
                testSystem.setMixingRule("HV");
                testSystem.init(0);
                double[] sample1 = new double[]{testSystem.getPressure(), testSystem.getTemperature()};
                double[] standardDeviation1 = new double[]{0.01};
                double val = 1.0 - Double.parseDouble(dataSet.getString("Y"));
                double sdev = val / 100.0;
                SampleValue sample = new SampleValue(val, sdev, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(Double.toString(testSystem.getTemperature()));
                double[] parameterGuess = new double[]{3626.0, -2241.0, 3.91, -3.16};
                function.setInitialGuess(parameterGuess);
                sample.setDescription(Double.toString(testSystem.getTemperature()));
                sampleList.add(sample);
                logger.info("gas points " + p);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.displayCurveFit();
    }
}

