/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.HuronVidalParameterFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkSchwartzentruberEos;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.HuronVidalParameterFitting.BinaryHVParameterFittingToSolubilityData;
import neqsim.util.database.NeqSimExperimentDatabase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestBinaryHVParameterFittingToSolubilityData_LuciaPropane {
    static Logger logger = LogManager.getLogger(TestBinaryHVParameterFittingToSolubilityData_LuciaPropane.class);

    public static void main(String[] args) {
        double[] parameterGuess;
        SampleValue sample;
        double sdev;
        double val;
        double[] standardDeviation1;
        double[] sample1;
        SystemSrkSchwartzentruberEos testSystem;
        BinaryHVParameterFittingToSolubilityData function;
        int p;
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimExperimentDatabase database = new NeqSimExperimentDatabase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM LuciaData8 WHERE Component='nitrogen' AND Temperature>270.0 AND L2>0.000000001");
        try {
            logger.info("adding....");
            for (p = 0; dataSet.next() && p < 80; ++p) {
                function = new BinaryHVParameterFittingToSolubilityData();
                testSystem = new SystemSrkSchwartzentruberEos(Double.parseDouble(dataSet.getString("Temperature")), Double.parseDouble(dataSet.getString("Pressure")) / 100000.0);
                testSystem.addComponent("nitrogen", 10.0);
                testSystem.addComponent("water", 10.0);
                testSystem.createDatabase(true);
                testSystem.setMixingRule("HV");
                testSystem.init(0);
                sample1 = new double[]{testSystem.getPressure(), testSystem.getTemperature()};
                standardDeviation1 = new double[]{0.01};
                val = Double.parseDouble(dataSet.getString("L2"));
                sdev = val / 100.0;
                sample = new SampleValue(val, sdev, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(Double.toString(testSystem.getTemperature()));
                parameterGuess = new double[]{4898.64, -111.76};
                function.setInitialGuess(parameterGuess);
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        dataSet = database.getResultSet("SELECT * FROM LuciaData8 WHERE Component='nitrogen' AND ID>=1014 AND ID<=1045 AND Temperature<373.0");
        try {
            logger.info("adding....");
            for (p = 0; dataSet.next() && p < 100; ++p) {
                function = new BinaryHVParameterFittingToSolubilityData(0, 0);
                testSystem = new SystemSrkSchwartzentruberEos(Double.parseDouble(dataSet.getString("Temperature")), Double.parseDouble(dataSet.getString("Pressure")) / 100000.0);
                testSystem.addComponent("nitrogen", 10.0);
                testSystem.addComponent("water", 1000.0);
                testSystem.setMixingRule("HV");
                testSystem.init(0);
                sample1 = new double[]{testSystem.getPressure(), testSystem.getTemperature()};
                standardDeviation1 = new double[]{0.01};
                val = 1.0 - Double.parseDouble(dataSet.getString("Y"));
                sdev = val / 100.0;
                sample = new SampleValue(val, sdev, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(Double.toString(testSystem.getTemperature()));
                parameterGuess = new double[]{4898.64, -111.76};
                function.setInitialGuess(parameterGuess);
                sample.setDescription(Double.toString(testSystem.getTemperature()));
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayResult();
    }
}

