/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.HuronVidalParameterFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkSchwartzentruberEos;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.HuronVidalParameterFitting.BinaryHVParameterFittingToSolubilityData;
import neqsim.util.database.NeqSimExperimentDatabase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestBinaryHVParameterFittingToSolubilityData {
    static Logger logger = LogManager.getLogger(TestBinaryHVParameterFittingToSolubilityData.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimExperimentDatabase database = new NeqSimExperimentDatabase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM binarySolubilityData WHERE ComponentSolute='oxygen' AND ComponentSolvent='water' ORDER BY Temperature,Pressure");
        try {
            logger.info("adding....");
            for (int p = 0; dataSet.next() && p < 22; ++p) {
                BinaryHVParameterFittingToSolubilityData function = new BinaryHVParameterFittingToSolubilityData();
                SystemSrkSchwartzentruberEos testSystem = new SystemSrkSchwartzentruberEos(290.0, 1.0);
                testSystem.addComponent(dataSet.getString("ComponentSolute"), 1.0);
                testSystem.addComponent(dataSet.getString("ComponentSolvent"), 100.0);
                testSystem.createDatabase(true);
                testSystem.setMixingRule(4);
                testSystem.setTemperature(Double.parseDouble(dataSet.getString("Temperature")));
                testSystem.setPressure(Double.parseDouble(dataSet.getString("Pressure")));
                logger.error("pressure " + testSystem.getPressure());
                testSystem.init(0);
                double[] sample1 = new double[]{testSystem.getPressure(), testSystem.getTemperature()};
                double[] standardDeviation1 = new double[]{0.01};
                SampleValue sample = new SampleValue(Double.parseDouble(dataSet.getString("x1")), Double.parseDouble(dataSet.getString("StandardDeviation")), sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(Double.toString(testSystem.getTemperature()));
                double[] parameterGuess = new double[]{2423.6600682957, -2136.4306560594, 1.9812435921, 1.4579901393};
                function.setInitialGuess(parameterGuess);
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
    }
}

