/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.EosInteractionParameterFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemPrEos;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.EosInteractionParameterFitting.CPAParameterFittingToSolubilityData;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestParameterFittingToSolubilityDataEinar {
    static Logger logger = LogManager.getLogger(TestParameterFittingToSolubilityDataEinar.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM binarysolubilitydataeinar WHERE ComponentSolute='methane' AND ComponentSolvent='Water'");
        try {
            logger.info("adding....");
            for (int p = 0; dataSet.next() && p < 4000; ++p) {
                CPAParameterFittingToSolubilityData function = new CPAParameterFittingToSolubilityData();
                SystemPrEos testSystem = new SystemPrEos(290.0, 1.0);
                testSystem.addComponent("methane", 1.0);
                testSystem.addComponent("water", 10.0);
                testSystem.createDatabase(true);
                testSystem.setTemperature(Double.parseDouble(dataSet.getString("Temperature")));
                testSystem.setPressure(Double.parseDouble(dataSet.getString("Pressure")) / 100000.0);
                testSystem.setMixingRule(2);
                testSystem.init(0);
                double[] sample1 = new double[]{testSystem.getPressure(), testSystem.getTemperature()};
                double[] standardDeviation1 = new double[]{testSystem.getPressure() / 100.0, testSystem.getTemperature() / 100.0};
                SampleValue sample = new SampleValue(Double.parseDouble(dataSet.getString("x1")), Double.parseDouble(dataSet.getString("StandardDeviation")), sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(Double.toString(testSystem.getTemperature()));
                double[] parameterGuess = new double[]{1.0E-7};
                function.setInitialGuess(parameterGuess);
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
        optim.writeToCdfFile("c:/testFit.nc");
        optim.writeToTextFile("c:/testFit.txt");
    }
}

