/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.EosInteractionParameterFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.EosInteractionParameterFitting.CPAParameterFittingToSolubilityData;
import neqsim.util.database.NeqSimExperimentDatabase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestEosParameterFittingToMercurySolubility {
    static Logger logger = LogManager.getLogger(TestEosParameterFittingToMercurySolubility.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimExperimentDatabase database = new NeqSimExperimentDatabase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM binarysolubilitydata WHERE ComponentSolute='mercury' AND ComponentSolvent='n-hexane'");
        double[] parameterGuess = new double[]{-0.03310000498911416};
        try {
            logger.info("adding....");
            for (int p = 0; dataSet.next() && p < 40; ++p) {
                CPAParameterFittingToSolubilityData function = new CPAParameterFittingToSolubilityData(0, 0);
                SystemSrkEos testSystem = new SystemSrkEos(290.0, 1.0);
                testSystem.addComponent("mercury", 10.0);
                testSystem.addComponent("n-hexane", 10.0);
                testSystem.getPhase(0).getComponent("mercury").setAttractiveTerm(12);
                testSystem.getPhase(1).getComponent("mercury").setAttractiveTerm(12);
                testSystem.createDatabase(true);
                testSystem.setMultiPhaseCheck(true);
                testSystem.setTemperature(Double.parseDouble(dataSet.getString("Temperature")));
                testSystem.setPressure(Double.parseDouble(dataSet.getString("Pressure")) + 2.0);
                testSystem.setMixingRule(2);
                testSystem.init(0);
                double[] sample1 = new double[]{testSystem.getPressure(), testSystem.getTemperature()};
                double[] standardDeviation1 = new double[]{0.13};
                double x1 = Double.parseDouble(dataSet.getString("x1"));
                SampleValue sample = new SampleValue(x1, x1 / 100.0, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                function.setInitialGuess(parameterGuess);
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
    }
}

