/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.EosInteractionParameterFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardtFunction;
import neqsim.thermo.system.SystemSrkCPA;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.EosInteractionParameterFitting.CPAParameterFittingToSolubilityData;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.EosInteractionParameterFitting.CPAParameterFittingToSolubilityData_Vap;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestCPAParameterFittingToSolubilityData_Lucia {
    static Logger logger = LogManager.getLogger(TestCPAParameterFittingToSolubilityData_Lucia.class);

    public static void main(String[] args) {
        double[] parameterGuess;
        SampleValue sample;
        double sdev;
        double val;
        double[] standardDeviation1;
        double[] sample1;
        SystemSrkCPA testSystem;
        LevenbergMarquardtFunction function;
        int p;
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM luciadata8 WHERE Component='methane' AND Temperature>410.15 AND Pressure<100000000 AND L2<>NULL AND L2>0.00000001 ORDER BY Temperature,Pressure");
        try {
            logger.info("adding....");
            for (p = 0; !dataSet.next() && p < 50; ++p) {
                function = new CPAParameterFittingToSolubilityData();
                testSystem = new SystemSrkCPA(Double.parseDouble(dataSet.getString("Temperature")), Double.parseDouble(dataSet.getString("Pressure")) / 100000.0);
                testSystem.addComponent("methane", 1.0);
                testSystem.addComponent("water", 10.0);
                testSystem.setMixingRule(7);
                testSystem.init(0);
                sample1 = new double[]{testSystem.getPressure(), testSystem.getTemperature()};
                standardDeviation1 = new double[]{0.01};
                val = Double.parseDouble(dataSet.getString("L2"));
                sdev = val / 100.0;
                sample = new SampleValue(val, sdev, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(Double.toString(testSystem.getTemperature()));
                parameterGuess = new double[]{0.0459393339};
                function.setInitialGuess(parameterGuess);
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error", (Throwable)e);
        }
        dataSet = database.getResultSet("SELECT * FROM LuciaData8 WHERE Component='methane' AND Temperature>273.15 AND Pressure<153000000 AND Y<>NULL AND Y>0.000000001 ORDER BY Temperature,Pressure");
        try {
            logger.info("adding....");
            for (p = 0; dataSet.next() && p < 150; ++p) {
                function = new CPAParameterFittingToSolubilityData_Vap();
                testSystem = new SystemSrkCPA(Double.parseDouble(dataSet.getString("Temperature")), Double.parseDouble(dataSet.getString("Pressure")) / 100000.0);
                testSystem.addComponent("methane", 1.0);
                testSystem.addComponent("water", 10.0);
                testSystem.init(0);
                testSystem.setMixingRule(7);
                sample1 = new double[]{testSystem.getPressure(), testSystem.getTemperature()};
                standardDeviation1 = new double[]{0.01};
                val = 1.0 - Double.parseDouble(dataSet.getString("Y"));
                sdev = val / 100.0;
                sample = new SampleValue(val, sdev, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(Double.toString(testSystem.getTemperature()));
                parameterGuess = new double[]{0.0459393339};
                function.setInitialGuess(parameterGuess);
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error", (Throwable)e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.displayCurveFit();
        optim.writeToCdfFile("c:/testFit.nc");
        optim.writeToTextFile("c:/testFit.txt");
    }
}

