/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.EosInteractionParameterFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemGERGwaterEos;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.EosInteractionParameterFitting.CPAParameterFittingToDewPointData;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestCPAParameterFittingToDewPointData {
    static Logger logger = LogManager.getLogger(TestCPAParameterFittingToDewPointData.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM waterdewpointpaper WHERE gascomponent='nitrogen' AND reference='Gil'");
        try {
            logger.info("adding....");
            for (int p = 0; dataSet.next() && p < 500; ++p) {
                CPAParameterFittingToDewPointData function = new CPAParameterFittingToDewPointData();
                SystemGERGwaterEos testSystem = new SystemGERGwaterEos(Double.parseDouble(dataSet.getString("temperature")), Double.parseDouble(dataSet.getString("Pressure")) * 10.0);
                double valueppm = Double.parseDouble(dataSet.getString("ywater")) * 1000.0;
                testSystem.addComponent(dataSet.getString("gascomponent"), 1.0 - valueppm / 1000000.0);
                testSystem.addComponent("water", valueppm / 1000000.0);
                testSystem.createDatabase(true);
                testSystem.setMixingRule(8);
                testSystem.init(0);
                double[] sample1 = new double[]{testSystem.getPressure(), testSystem.getTemperature()};
                double[] standardDeviation1 = new double[]{0.13};
                SampleValue sample = new SampleValue(testSystem.getTemperature(), 1.0, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setDescription(Double.toString(valueppm));
                sample.setReference(dataSet.getString("reference"));
                double[] parameterGuess = new double[]{0.001};
                function.setInitialGuess(parameterGuess);
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.displayCurveFit();
    }
}

