/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.EosInteractionParameterFitting;

import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardtFunction;
import neqsim.thermo.mixingRule.HVmixingRuleInterface;
import neqsim.thermo.phase.PhaseEosInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CPAParameterFittingToDewPointData
extends LevenbergMarquardtFunction {
    static Logger logger = LogManager.getLogger(CPAParameterFittingToDewPointData.class);

    public CPAParameterFittingToDewPointData() {
        this.params = new double[1];
    }

    @Override
    public double calcValue(double[] dependentValues) {
        try {
            this.thermoOps.waterPrecipitationTemperature();
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
        }
        return this.system.getTemperature();
    }

    @Override
    public void setFittingParams(int i, double value) {
        this.params[i] = value;
        if (i == 0) {
            // empty if block
        }
        if (i == 2) {
            this.system.getPhases()[0].getComponents()[1].seta(value * 10000.0);
            this.system.getPhases()[1].getComponents()[1].seta(value * 10000.0);
        }
        if (i == 1) {
            this.system.getPhases()[0].getComponents()[1].setb(value);
            this.system.getPhases()[1].getComponents()[1].setb(value);
        }
        if (i == 3) {
            this.system.getPhase(0).getComponent(1).getAttractiveTerm().setm(value);
            this.system.getPhases()[1].getComponents()[1].getAttractiveTerm().setm(value);
        }
        if (i == 5) {
            this.system.getPhase(0).getComponent(1).setAssociationEnergy(value);
            this.system.getPhase(1).getComponent(1).setAssociationEnergy(value);
        }
        if (i == 4) {
            this.system.getPhase(0).getComponent(1).setAssociationVolume(value);
            this.system.getPhase(1).getComponent(1).setAssociationVolume(value);
        }
    }

    public void setFittingParams2(int i, double value) {
        this.params[i] = value;
        if (i == 0) {
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[0]).getMixingRule()).setHVDijParameter(0, 1, value);
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[1]).getMixingRule()).setHVDijParameter(0, 1, value);
        }
        if (i == 1) {
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[0]).getMixingRule()).setHVDijParameter(1, 0, value);
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[1]).getMixingRule()).setHVDijParameter(1, 0, value);
        }
        if (i == 2) {
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[0]).getMixingRule()).setHVDijTParameter(0, 1, value);
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[1]).getMixingRule()).setHVDijTParameter(0, 1, value);
        }
        if (i == 3) {
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[0]).getMixingRule()).setHVDijTParameter(1, 0, value);
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[1]).getMixingRule()).setHVDijTParameter(1, 0, value);
        }
        if (i == 4) {
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[0]).getMixingRule()).setHValphaParameter(1, 0, value);
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[1]).getMixingRule()).setHValphaParameter(1, 0, value);
        }
    }
}

