/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.Procede.WaterMDEA;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import neqsim.thermo.system.SystemSrkSchwartzentruberEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Water_MDEA1 {
    static Logger logger = LogManager.getLogger(Water_MDEA1.class);

    public static void main(String[] args) {
        double temperature = 313.16;
        double pressure = 1.0;
        double x = 0.0;
        for (x = 0.85; x <= 1.0; x += 0.01) {
            SystemSrkSchwartzentruberEos testSystem = new SystemSrkSchwartzentruberEos(temperature, pressure);
            testSystem.addComponent("water", x);
            testSystem.addComponent("MDEA", 1.0 - x);
            testSystem.createDatabase(true);
            testSystem.setMixingRule(4);
            testSystem.init(0);
            testSystem.init(1);
            ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
            try {
                testOps.bubblePointPressureFlash(false);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
            logger.info("pressure " + testSystem.getPressure());
            try (PrintStream p = new PrintStream(new FileOutputStream("C:/java/NeqSimSource/Patrick.txt", true));){
                p.println(x + " " + testSystem.getPhase(0).getComponent(1).getx() + " " + testSystem.getPressure() + " " + testSystem.getPhase(0).getComponent(1).getFugacityCoefficient());
                continue;
            }
            catch (FileNotFoundException e) {
                logger.error("Could not find file" + e.getMessage());
            }
        }
        logger.info("Finished");
    }
}

