/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.Procede.Density;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import neqsim.thermo.system.SystemFurstElectrolyteEos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class density {
    static Logger logger = LogManager.getLogger(density.class);

    public static void main(String[] args) {
        double MDEAwt = 0.44;
        double loading = 0.0;
        double temperature = 293.16;
        double pressure = 0.01;
        for (loading = 0.0; loading <= 1.0; loading += 0.1) {
            double n3 = MDEAwt / 119.16;
            double n2 = (1.0 - MDEAwt) / 18.015;
            double n1 = n3 * loading;
            double total = n1 + n2 + n3;
            double x1 = n1 / total;
            double x2 = n2 / total;
            double x3 = n3 / total;
            SystemFurstElectrolyteEos testSystem = new SystemFurstElectrolyteEos(298.0, 1.0);
            testSystem.addComponent("CO2", x1);
            testSystem.addComponent("MDEA", x3);
            testSystem.addComponent("water", x2);
            testSystem.chemicalReactionInit();
            testSystem.createDatabase(true);
            testSystem.useVolumeCorrection(true);
            testSystem.setMixingRule(4);
            testSystem.init(0);
            testSystem.init(1);
            testSystem.initPhysicalProperties();
            try (PrintStream p = new PrintStream(new FileOutputStream("C:/java/NeqSimSource/Patrick.txt", true));){
                p.println(loading + " " + testSystem.getPhase(1).getPhysicalProperties().getDensity() / 1000.0);
                continue;
            }
            catch (FileNotFoundException e) {
                logger.error("Could not find file");
                logger.error("Could not write to Patrick.txt" + e.getMessage());
            }
        }
    }
}

