/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.Procede.CH4CO2WaterMDEA;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.ResultSet;
import neqsim.thermo.system.SystemFurstElectrolyteEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CO2_MDEA_methane {
    static Logger logger = LogManager.getLogger(CO2_MDEA_methane.class);

    public static void main(String[] args) {
        int i = 0;
        int CH4Numb = 0;
        int CO2Numb = 0;
        int WaterNumb = 0;
        int MDEANumb = 0;
        int HCO3Numb = 0;
        int MDEAHpNumb = 0;
        int iter = 0;
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM PatrickCO2");
        block13: while (true) {
            try {
                while (dataSet.next()) {
                    logger.info("Adding.... " + ++i);
                    double ID = Double.parseDouble(dataSet.getString("ID"));
                    double pressureCO2 = Double.parseDouble(dataSet.getString("PressureCO2"));
                    double pressure = Double.parseDouble(dataSet.getString("Pressure"));
                    double temperature = Double.parseDouble(dataSet.getString("Temperature"));
                    double n1 = Double.parseDouble(dataSet.getString("x1"));
                    double n2 = Double.parseDouble(dataSet.getString("x2"));
                    double n3 = Double.parseDouble(dataSet.getString("x3"));
                    double guess = n1 / 20.0;
                    SystemFurstElectrolyteEos testSystem = new SystemFurstElectrolyteEos(temperature, pressure);
                    testSystem.addComponent("CO2", n1);
                    testSystem.addComponent("water", n2);
                    testSystem.addComponent("methane", guess);
                    testSystem.addComponent("MDEA", n3);
                    testSystem.chemicalReactionInit();
                    testSystem.createDatabase(true);
                    testSystem.setMixingRule(4);
                    testSystem.init(0);
                    int j = 0;
                    do {
                        CO2Numb = j++;
                    } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("CO2"));
                    j = 0;
                    do {
                        CH4Numb = j++;
                    } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("methane"));
                    j = 0;
                    do {
                        MDEANumb = j++;
                    } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("MDEA"));
                    j = 0;
                    do {
                        WaterNumb = j++;
                    } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("water"));
                    j = 0;
                    do {
                        HCO3Numb = j++;
                    } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("HCO3-"));
                    j = 0;
                    do {
                        MDEAHpNumb = j++;
                    } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("MDEA+"));
                    ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
                    double error = 1.0E10;
                    double dx = 1.0E-6;
                    iter = 0;
                    double newValue = guess;
                    double oldValue = guess;
                    do {
                        ++iter;
                        oldValue = newValue;
                        try {
                            testOps.bubblePointPressureFlash(false);
                        }
                        catch (Exception e) {
                            logger.error(e.toString());
                        }
                        double Pold = testSystem.getPressure();
                        testSystem.addComponent("methane", -testSystem.getPhase(1).getComponent(CH4Numb).getNumberOfmoles());
                        testSystem.addComponent("methane", oldValue + dx);
                        try {
                            testOps.bubblePointPressureFlash(false);
                        }
                        catch (Exception e) {
                            logger.error(e.toString());
                        }
                        double Pnew = testSystem.getPressure();
                        double dP = (Pnew - Pold) / dx;
                        newValue = oldValue - (Pold - pressure) / dP;
                        error = newValue - oldValue;
                        testSystem.addComponent("methane", -testSystem.getPhase(1).getComponent(CH4Numb).getNumberOfmoles());
                        testSystem.addComponent("methane", newValue);
                    } while (Math.abs(error) > 1.0E-9 && iter < 50);
                    j = 0;
                    do {
                        CO2Numb = j++;
                    } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("CO2"));
                    double aad = (pressureCO2 - testSystem.getPressure() * testSystem.getPhase(0).getComponent(CO2Numb).getx()) / pressureCO2 * 100.0;
                    logger.info(ID + " " + testSystem.getPressure() * testSystem.getPhase(0).getComponent(CO2Numb).getx() + " " + pressureCO2 + " " + aad);
                    try {
                        PrintStream p = new PrintStream(new FileOutputStream("C:/java/NeqSimSource/Patrick.txt", true));
                        try {
                            p.println(ID + " " + pressure + " " + pressureCO2 + " " + testSystem.getPressure() + " " + testSystem.getPressure() * testSystem.getPhase(0).getComponent(CO2Numb).getx());
                            continue block13;
                        }
                        finally {
                            p.close();
                            continue block13;
                        }
                    }
                    catch (FileNotFoundException e) {
                        logger.error("Could not find file" + e.getMessage());
                        logger.error("Could not read from Patrick.txt" + e.getMessage());
                    }
                }
                break;
            }
            catch (Exception e) {
                logger.error("database error " + e);
                break;
            }
        }
        logger.info("Finished");
    }
}

