/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.empiric;

import neqsim.thermo.system.SystemElectrolyteCPAstatoil;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class DuanSun {
    double[] c = new double[]{0.1, 0.2, 0.3, 0.4, 0.5};
    double[] d = new double[]{0.1, 0.2, 0.3, 0.4, 0.5};

    public double bublePointPressure(double temperature, double x_CO2, double salinity) {
        double P = 9.0;
        double Pold = 9.0;
        double Poldold = 9.0;
        double[] y = new double[]{0.9, 0.1};
        double[] x = new double[]{x_CO2, 1.0 - x_CO2};
        double error = 1.0E10;
        double errorOld = 1.0E10;
        int iter = 1;
        do {
            int i;
            ++iter;
            double[] Tc = new double[]{304.2, 647.3};
            double[] Pc = new double[]{72.8, 217.6};
            double[] w = new double[]{0.225, 0.344};
            double[][] K12 = new double[][]{{0.0, 0.2}, {0.2, 0.0}};
            double T = temperature;
            double S = salinity;
            double SUMY = 0.0;
            for (i = 0; i < 2; ++i) {
                SUMY += y[i];
            }
            for (i = 0; i < 2; ++i) {
                y[i] = y[i] / SUMY;
            }
            double R = 8.314 * Math.pow(10.0, -2.0);
            double[] Tr = new double[]{0.0, 0.0};
            double ac = 0.45724;
            double bc = 0.0778;
            double[] d = new double[]{0.384401, 1.52276, -0.213808, 0.034616, -0.001976};
            double[] dm = new double[]{0.0, 0.0};
            double[] ag = new double[]{0.0, 0.0};
            double[] asmal = new double[]{0.0, 0.0};
            double[] bsmal = new double[]{0.0, 0.0};
            double[] a = new double[]{0.0, 0.0};
            double[] b = new double[]{0.0, 0.0};
            for (int i2 = 0; i2 < 2; ++i2) {
                Tr[i2] = T / Tc[i2];
                dm[i2] = d[0] + w[i2] * (d[1] + w[i2] * (d[2] + w[i2] * (d[3] + w[i2] * d[4])));
                ag[i2] = Math.pow(1.0 + dm[i2] * (1.0 - Math.pow(Tr[i2], 0.5)), 2.0);
                asmal[i2] = ag[i2] * ac * (Math.pow(R * Tc[i2], 2.0) / Pc[i2]);
                bsmal[i2] = bc * (R * Tc[i2]) / Pc[i2];
                a[i2] = asmal[i2] * P / Math.pow(R * T, 2.0);
                b[i2] = bsmal[i2] * P / (R * T);
            }
            double av = 0.0;
            double bv = 0.0;
            double[] sumav = new double[]{0.0, 0.0};
            double aij = 0.0;
            for (int i3 = 0; i3 < 2; ++i3) {
                sumav[i3] = 0.0;
                for (int j = 0; j < 2; ++j) {
                    aij = Math.sqrt(a[i3] * a[j]) * (1.0 - K12[i3][j]);
                    av += y[i3] * y[j] * aij;
                    sumav[i3] = sumav[i3] + y[j] * aij;
                }
                bv += y[i3] * b[i3];
            }
            double c0 = 0.0;
            double c1 = 0.0;
            double c2 = 0.0;
            double c3 = 0.0;
            c0 = -(av * bv - Math.pow(bv, 2.0) - Math.pow(bv, 3.0));
            c1 = av - 3.0 * Math.pow(bv, 2.0) - 2.0 * bv;
            c2 = -(1.0 - bv);
            c3 = 1.0;
            double OMEGA = 0.0;
            double[] ROOT = new double[]{0.0, 0.0, 0.0};
            double[] W = new double[]{0.0, 0.0, 0.0};
            double k = 0.0;
            double NRR = 0.0;
            double PHI = 0.0;
            double A0 = c0 / c3;
            double A1 = c1 / c3;
            double A2 = c2 / c3;
            double p = (3.0 * A1 - Math.pow(A2, 2.0)) / 3.0;
            double Q = (27.0 * A0 - 9.0 * A1 * A2 + 2.0 * Math.pow(A2, 3.0)) / 27.0;
            double D = Math.pow(Q, 2.0) / 4.0 + Math.pow(p, 3.0) / 27.0;
            double r = Math.sqrt(Math.pow(Math.abs(p), 3.0) / 27.0);
            double PI = Math.acos(-1.0);
            if (D < Math.pow(10.0, -16.0)) {
                NRR = 3.0;
                PHI = Math.acos(-Q / (2.0 * r));
                for (int i4 = 0; i4 < 3; ++i4) {
                    k = (double)i4 - 1.0;
                    W[i4] = 2.0 * Math.pow(r, 0.3333333333333333) * Math.cos((PHI + 2.0 * PI * k) / 3.0);
                    ROOT[i4] = W[i4] - A2 / 3.0;
                }
            } else {
                NRR = 1.0;
                if (p < 0.0) {
                    OMEGA = Math.asin(2.0 * r / Q);
                    PHI = Math.atan(Math.pow(Math.tan(Math.abs(OMEGA) / 2.0), 0.3333333333333333));
                    if (OMEGA < 0.0) {
                        PHI = -PHI;
                        W[0] = -2.0 * Math.sqrt(-p / 3.0) / Math.sin(2.0 * PHI);
                    }
                } else {
                    OMEGA = Math.atan(2.0 * r / Q);
                    PHI = Math.atan(Math.pow(Math.tan(Math.abs(OMEGA) / 2.0), 0.3333333333333333));
                    if (OMEGA < 0.0) {
                        PHI = -PHI;
                    }
                    W[0] = -2.0 * Math.sqrt(p / 3.0) / Math.tan(2.0 * PHI);
                }
                ROOT[0] = W[0] - A2 / 3.0;
                ROOT[1] = 0.0;
                ROOT[2] = 0.0;
            }
            double zv = 0.0;
            zv = NRR == 1.0 ? ROOT[0] : Math.max(Math.max(ROOT[0], ROOT[1]), ROOT[2]);
            if (zv < Math.pow(10.0, -19.0)) {
                // empty if block
            }
            double VV = 0.0;
            VV = zv * R * T / P;
            double[] trans = new double[]{0.0, 0.0};
            double[] bh = new double[]{0.0, 0.0};
            double[] t0 = new double[]{0.0, 0.0};
            double[] ti = new double[]{0.0, 0.0};
            double[] zc = new double[]{0.0, 0.0};
            double TEV = 0.0;
            double zceos = 0.3074;
            double dk0 = -0.014471;
            double dk1 = 0.067498;
            double dk2 = -0.084852;
            double dk3 = 0.067298;
            double dk4 = -0.017366;
            double dl0 = -10.2447;
            double dl1 = -28.6312;
            double dl2 = 0.0;
            for (int i5 = 0; i5 < 2; ++i5) {
                zc[i5] = 0.289 + w[i5] * (-0.0701 - 0.0207 * w[i5]);
                ti[i5] = R * Tc[i5] / Pc[i5] * (zceos - zc[i5]);
                t0[i5] = R * Tc[i5] / Pc[i5] * (dk0 + w[i5] * (dk1 + w[i5] * (dk2 + w[i5] * (dk3 + w[i5] * dk4))));
                bh[i5] = dl0 + w[i5] * (dl1 + w[i5] * dl2);
                trans[i5] = t0[i5] + (ti[i5] - t0[i5]) * Math.exp(bh[i5] * Math.abs(1.0 - Tr[i5]));
                TEV += y[i5] * trans[i5];
            }
            VV -= TEV;
            double[] dlnfc = new double[]{0.0, 0.0};
            double[] fcv = new double[]{0.0, 0.0};
            for (int i6 = 0; i6 < 2; ++i6) {
                dlnfc[i6] = b[i6] / bv * (zv - 1.0) - Math.log(zv - bv) - av / (2.0 * Math.sqrt(2.0) * bv) * (2.0 * sumav[i6] / av - b[i6] / bv) * Math.log((zv + 2.414 * bv) / (zv - 0.414 * bv));
                fcv[i6] = Math.exp(dlnfc[i6]);
            }
            double[] fv = new double[]{0.0, 0.0};
            for (int i7 = 0; i7 < 2; ++i7) {
                fv[i7] = fcv[i7] * y[i7] * P;
            }
            double VCO2INF = 0.0;
            VCO2INF = -1.59751499972988E8 * Math.pow(10.0, -10.0) + 1.01831855926854E8 * Math.pow(10.0, -10.0) * S + 1.8075168978622E7 * Math.pow(10.0, -11.0) * T - 7.87538191939352E8 * Math.pow(10.0, -13.0) * S * T - 1.92886808345857E8 * Math.pow(10.0, -11.0) * Math.pow(S, 2.0) + 1.42830810095592E8 * Math.pow(10.0, -15.0) * S * Math.pow(T, 2.0) + 1.23450785102997E8 * Math.pow(10.0, -13.0) * T * Math.pow(S, 2.0) - 2.20053285910771E8 * Math.pow(10.0, -16.0) * Math.pow(S, 2.0) * Math.pow(T, 2.0) - 3.5351000350961E7 * Math.pow(10.0, -17.0) * Math.pow(T, 3.0);
            double HCO2AST = 0.0;
            HCO2AST = 5.47703618010975E8 * Math.pow(10.0, -3.0) - 2.37824440424155E8 * Math.pow(10.0, -4.0) * T - 1.08668654561957E8 * Math.pow(10.0, -7.0) * Math.pow(T, 2.0) + 1.0492428477532E7 * Math.pow(10.0, -8.0) * S * Math.pow(T, 2.0) + 4.26241410644264E8 * Math.pow(10.0, -11.0) * Math.pow(T, 3.0) - 1.24268021223715E8 * Math.pow(10.0, -12.0) * S * Math.pow(T, 3.0) + 4.35491737902085E8 * Math.pow(10.0, -5.0) * T * Math.log(T) + 1.9224323617885E7 * Math.pow(10.0, -8.0) * Math.pow(S, 3.0) * T - 4.86711042327079E8 * Math.pow(10.0, -9.0) * T * Math.exp(S) + 5.93013871824553E8 * Math.pow(10.0, -10.0) * S * T * Math.exp(S) - 1.86057141990893E8 * Math.pow(10.0, -7.0) * S * T + 1.3867353798785E7 * Math.pow(10.0, -7.0) * Math.exp(S) * Math.log(T);
            double HCO2 = 0.0;
            HCO2 = Math.exp(Math.log(HCO2AST) + VCO2INF * P / (R * T));
            double[] fl = new double[]{0.0, 0.0};
            fl[0] = x[0] * HCO2;
            double PHIWSAT = 0.0;
            PHIWSAT = 1.8 * T - 459.67 > 90.0 ? 0.9958 + 9.6833 * Math.pow(10.0, -5.0) * (1.8 * T - 459.67) - 6.1705 * Math.pow(10.0, -7.0) * Math.pow(1.8 * T - 459.67, 2.0) - 3.08333 * Math.pow(10.0, -10.0) * Math.pow(1.8 * T - 459.67, 3.0) : 1.0;
            double Densliq = 0.0;
            double VW = 0.0;
            Densliq = 4.6137 / Math.pow(0.26214, 1.0 + Math.pow(1.0 - T / 647.29, 0.23072));
            VW = 1.0 / Densliq;
            double PWSAT = 0.0;
            PWSAT = Math.exp(73.649 - 7258.2 / T - 7.3037 * Math.log(T) + 4.1653E-6 * Math.pow(T, 2.0)) / Math.pow(10.0, 5.0);
            double Poyntef = 0.0;
            Poyntef = Math.exp(VW * (P - PWSAT) / (R * T));
            fl[1] = x[1] * PHIWSAT * PWSAT * Poyntef;
            double SUMY1 = 0.0;
            for (int i8 = 0; i8 < 2; ++i8) {
                y[i8] = y[i8] * fl[i8] / fv[i8];
                SUMY1 += y[i8];
            }
            double G = 0.0;
            G = SUMY1 - 1.0;
            if (Math.abs(fl[0] - fv[0]) < Math.pow(10.0, -5.0) && Math.abs(fl[1] - fv[1]) < Math.pow(10.0, -5.0) && Math.abs(G) < Math.pow(10.0, -5.0)) {
                System.out.println("fl0 = " + fl[0]);
                System.out.println("fl1 = " + fl[1]);
                System.out.println("fv0 = " + fv[0]);
                System.out.println("fv1 = " + fv[1]);
                System.out.println("y0 = " + y[0]);
                System.out.println("y1 = " + y[1]);
                System.out.println("P = " + P + " bar ");
                break;
            }
            errorOld = error;
            error = Math.abs(fl[0] - fv[0]) + Math.abs(fl[1] - fv[1]) + Math.abs(G);
            Poldold = Pold;
            Pold = P;
            P = iter < 5 ? (P += Math.pow(10.0, -7.0) * P) : (P -= 0.1 * (error - errorOld) / (Pold - Poldold));
            System.out.println("P = " + P + " bar  error " + error);
        } while (Math.abs(error) > 1.0E-6);
        return P;
    }

    public double calcCO2solubility(double temperature, double pressure, double salinity) {
        double T = temperature;
        double P = pressure;
        double S = salinity;
        double Tc2 = 647.29;
        double Pc2 = 220.85;
        double c1 = 0.0;
        double c2 = 0.0;
        double c3 = 0.0;
        double c4 = 0.0;
        double c5 = 0.0;
        double c6 = 0.0;
        double c7 = 0.0;
        double c8 = 0.0;
        double c9 = 0.0;
        double c10 = 0.0;
        double c11 = 0.0;
        double c12 = 0.0;
        double c13 = 0.0;
        double c14 = 0.0;
        double c15 = 0.0;
        double[] parcdpsat = new double[]{85.53, -3481.3, -11.336, 0.021505, 1.0};
        double PCO2sat = 0.0;
        PCO2sat = Math.exp(parcdpsat[0] + parcdpsat[1] / T + parcdpsat[2] * Math.log(T) + parcdpsat[3] * Math.pow(T, parcdpsat[4])) / 100000.0;
        if (T >= 273.0 && T < 305.0 && P <= PCO2sat) {
            c1 = 1.0;
            c2 = 4.7586835 * Math.pow(10.0, -3.0);
            c3 = -3.3569963 * Math.pow(10.0, -6.0);
            c4 = 0.0;
            c5 = -1.3179396;
            c6 = -3.8389101 * Math.pow(10.0, -6.0);
            c7 = 0.0;
            c8 = 2.2815104 * Math.pow(10.0, -3.0);
            c9 = 0.0;
            c10 = 0.0;
            c11 = 0.0;
            c12 = 0.0;
            c13 = 0.0;
            c14 = 0.0;
            c15 = 0.0;
        } else if (T >= 305.0 && T <= 405.0 && P <= 75.0 + (T - 305.0) * 1.25) {
            c1 = 1.0;
            c2 = 4.7586835 * Math.pow(10.0, -3.0);
            c3 = -3.3569963 * Math.pow(10.0, -6.0);
            c4 = 0.0;
            c5 = -1.3179396;
            c6 = -3.8389101 * Math.pow(10.0, -6.0);
            c7 = 0.0;
            c8 = 2.2815104 * Math.pow(10.0, -3.0);
            c9 = 0.0;
            c10 = 0.0;
            c11 = 0.0;
            c12 = 0.0;
            c13 = 0.0;
            c14 = 0.0;
            c15 = 0.0;
        } else if (T > 405.0 && P <= 200.0) {
            c1 = 1.0;
            c2 = 4.7586835 * Math.pow(10.0, -3.0);
            c3 = -3.3569963 * Math.pow(10.0, -6.0);
            c4 = 0.0;
            c5 = -1.3179396;
            c6 = -3.8389101 * Math.pow(10.0, -6.0);
            c7 = 0.0;
            c8 = 2.2815104 * Math.pow(10.0, -3.0);
            c9 = 0.0;
            c10 = 0.0;
            c11 = 0.0;
            c12 = 0.0;
            c13 = 0.0;
            c14 = 0.0;
            c15 = 0.0;
        } else if (T >= 273.0 && T < 305.0 && P <= 1000.0 && P > PCO2sat) {
            c1 = -7.1734882 * Math.pow(10.0, -1.0);
            c2 = 1.5985379 * Math.pow(10.0, -4.0);
            c3 = -4.9286471 * Math.pow(10.0, -7.0);
            c4 = 0.0;
            c5 = 0.0;
            c6 = -2.7855285 * Math.pow(10.0, -7.0);
            c7 = 1.1877015 * Math.pow(10.0, -9.0);
            c8 = 0.0;
            c9 = 0.0;
            c10 = 0.0;
            c11 = 0.0;
            c12 = -96.539512;
            c13 = 4.4774938 * Math.pow(10.0, -1.0);
            c14 = 101.81078;
            c15 = 5.3783879 * Math.pow(10.0, -6.0);
        } else if (T >= 305.0 && T <= 340.0 && P <= 1000.0 && P > (75.0 + (T - 305.0)) * 1.25) {
            c1 = -7.1734882 * Math.pow(10.0, -1.0);
            c2 = 1.5985379 * Math.pow(10.0, -4.0);
            c3 = -4.9286471 * Math.pow(10.0, -7.0);
            c4 = 0.0;
            c5 = 0.0;
            c6 = -2.7855285 * Math.pow(10.0, -7.0);
            c7 = 1.1877015 * Math.pow(10.0, -9.0);
            c8 = 0.0;
            c9 = 0.0;
            c10 = 0.0;
            c11 = 0.0;
            c12 = -96.539512;
            c13 = 4.4774938 * Math.pow(10.0, -1.0);
            c14 = 101.81078;
            c15 = 5.3783879 * Math.pow(10.0, -6.0);
        } else if (T >= 273.0 && T <= 340.0 && P > 1000.0) {
            c1 = -6.5129019 * Math.pow(10.0, -2.0);
            c2 = -2.1429977 * Math.pow(10.0, -4.0);
            c3 = -1.144493 * Math.pow(10.0, -6.0);
            c4 = 0.0;
            c5 = 0.0;
            c6 = -1.1558081 * Math.pow(10.0, -7.0);
            c7 = 1.195237 * Math.pow(10.0, -9.0);
            c8 = 0.0;
            c9 = 0.0;
            c10 = 0.0;
            c11 = 0.0;
            c12 = -221.34306;
            c13 = 0.0;
            c14 = 71.820393;
            c15 = 6.6089246 * Math.pow(10.0, -6.0);
        } else if (T > 340.0 && T < 405.0 && P <= 1000.0 && P > 75.0 + (T - 305.0) * 1.25) {
            c1 = 5.0383896;
            c2 = -4.4257744 * Math.pow(10.0, -3.0);
            c3 = 0.0;
            c4 = 1.9572733;
            c5 = 0.0;
            c6 = 2.4223436 * Math.pow(10.0, -6.0);
            c7 = 0.0;
            c8 = -9.3796135 * Math.pow(10.0, -4.0);
            c9 = -1.502603;
            c10 = 3.027224 * Math.pow(10.0, -3.0);
            c11 = -31.377342;
            c12 = -12.847063;
            c13 = 0.0;
            c14 = 0.0;
            c15 = -1.5056648 * Math.pow(10.0, -5.0);
        } else if (T >= 405.0 && T <= 435.0 && P <= 1000.0 && P > 200.0) {
            c1 = 5.0383896;
            c2 = -4.4257744 * Math.pow(10.0, -3.0);
            c3 = 0.0;
            c4 = 1.9572733;
            c5 = 0.0;
            c6 = 2.4223436 * Math.pow(10.0, -6.0);
            c7 = 0.0;
            c8 = -9.3796135 * Math.pow(10.0, -4.0);
            c9 = -1.502603;
            c10 = 3.027224 * Math.pow(10.0, -3.0);
            c11 = -31.377342;
            c12 = -12.847063;
            c13 = 0.0;
            c14 = 0.0;
            c15 = -1.5056648 * Math.pow(10.0, -5.0);
        } else if (T > 340.0 && T <= 435.0 && P > 1000.0) {
            c1 = -16.063152;
            c2 = -2.705799 * Math.pow(10.0, -3.0);
            c3 = 0.0;
            c4 = 1.4119239 * Math.pow(10.0, -1.0);
            c5 = 0.0;
            c6 = 8.1132965 * Math.pow(10.0, -7.0);
            c7 = 0.0;
            c8 = -1.1453082 * Math.pow(10.0, -4.0);
            c9 = 2.3895671;
            c10 = 5.0527457 * Math.pow(10.0, -4.0);
            c11 = -17.76346;
            c12 = 985.92232;
            c13 = 0.0;
            c14 = 0.0;
            c15 = -5.4965256 * Math.pow(10.0, -7.0);
        } else if (T > 435.0 && P > 200.0) {
            c1 = -1.569349 * Math.pow(10.0, -1.0);
            c2 = 4.4621407 * Math.pow(10.0, -4.0);
            c3 = -9.1080591 * Math.pow(10.0, -7.0);
            c4 = 0.0;
            c5 = 0.0;
            c6 = 1.0647399 * Math.pow(10.0, -7.0);
            c7 = 2.4273357 * Math.pow(10.0, -10.0);
            c8 = 0.0;
            c9 = 3.5874255 * Math.pow(10.0, -1.0);
            c10 = 6.331971 * Math.pow(10.0, -5.0);
            c11 = -249.89661;
            c12 = 0.0;
            c13 = 0.0;
            c14 = 888.768;
            c15 = -6.6348003 * Math.pow(10.0, -7.0);
        }
        double fCO2 = 0.0;
        fCO2 = c1 + (c2 + c3 * T + c4 / T + c5 / (T - 150.0)) * P + (c6 + c7 * T + c8 / T) * Math.pow(P, 2.0) + (c9 + c10 * T + c11 / T) * Math.log(P) + (c12 + c13 * T) / P + c14 / T + c15 * Math.pow(T, 2.0);
        double chempotliqCO2RT = 0.0;
        chempotliqCO2RT = 28.9447706 - 0.0354581768 * T - 4770.67077 / T + 1.02782768 * Math.pow(10.0, -5.0) * Math.pow(T, 2.0) + 33.8126098 / (630.0 - T) + 0.009040371 * P - 0.00114934 * P * Math.log(T) - 0.307405726 * P / T - 0.090730149 * P / (630.0 - T) + 9.32713E-4 * Math.pow(P, 2.0) / Math.pow(630.0 - T, 2.0);
        double lamdaCO2Na = 0.0;
        lamdaCO2Na = -0.411370585 + 6.07632E-4 * T + 97.5347708 / T - 0.023762247 * P / T + 0.017065624 * P / (630.0 - T) + 1.41335834 * Math.pow(10.0, -5.0) * T * Math.log(P);
        double zetaCO2NaCl = 0.0;
        zetaCO2NaCl = 3.3639E-4 - 1.9829898 * Math.pow(10.0, -5.0) * T + 0.002122208 * P / T - 0.005248733 * P / (630.0 - T);
        double tH2O = 0.0;
        tH2O = (T - Tc2) / Tc2;
        double PH2O = 0.0;
        PH2O = Pc2 * T / Tc2 * (1.0 - 38.640844 * Math.pow(-tH2O, 1.9) + 5.894842 * tH2O + 59.876516 * Math.pow(tH2O, 2.0) + 26.654627 * Math.pow(tH2O, 3.0) + 10.637097 * Math.pow(tH2O, 4.0));
        double yCO2 = 0.0;
        yCO2 = (P - PH2O) / P;
        double mCO2 = 0.0;
        mCO2 = yCO2 * P / Math.exp(-Math.log(fCO2) + chempotliqCO2RT + 2.0 * lamdaCO2Na * S + zetaCO2NaCl * Math.pow(S, 2.0));
        double xCO2 = 0.0;
        xCO2 = mCO2 / (55.55555555555556 + mCO2);
        return xCO2;
    }

    public static void main(String[] args) {
        DuanSun testDuanSun = new DuanSun();
        double CO2solubility = testDuanSun.calcCO2solubility(303.15, 100.0, 3.0);
        System.out.println("CO2solubility " + CO2solubility / 0.01802 + " mol/kg");
        SystemElectrolyteCPAstatoil fluid1 = new SystemElectrolyteCPAstatoil(298.15, 10.0);
        fluid1.addComponent("CO2", 0.05, "kg/sec");
        fluid1.addComponent("water", 0.5, "kg/sec");
        fluid1.addComponent("Na+", 0.1, "mol/sec");
        fluid1.addComponent("Cl-", 0.1, "mol/sec");
        fluid1.setMixingRule(10);
        ThermodynamicOperations thermoOPs = new ThermodynamicOperations(fluid1);
        try {
            thermoOPs.TPflash();
            fluid1.display();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        fluid1.init(1);
        try {
            thermoOPs.TPflash();
            fluid1.display();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String fluidname = "";
        fluid1.saveObjectToFile(fluidname, fluidname);
        fluid1.setPhaseIndex(0, 1);
        System.out.println("CO2 in liquid " + fluid1.getPhase(0).getComponent(0).getLogFugacityCoefficient());
        System.out.println("CO2 in liquid " + fluid1.getPhase(0).getComponent(0).getFugacityCoefficient());
        System.out.println("CO2 in liquid " + fluid1.getPhase("aqueous").getComponent("CO2").getx());
    }
}

