/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseGEUnifacPSRK;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.phase.PhaseSrkEos;
import neqsim.thermo.system.SystemEos;

public class SystemUNIFACpsrk
extends SystemEos {
    private static final long serialVersionUID = 1000L;

    public SystemUNIFACpsrk() {
        this.modelName = "UNIFAC-GE-model";
        this.attractiveTermNumber = 0;
        this.phaseArray[0] = new PhaseSrkEos();
        for (int i = 1; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseGEUnifacPSRK();
        }
    }

    public SystemUNIFACpsrk(double T, double P) {
        super(T, P);
        this.attractiveTermNumber = 0;
        this.modelName = "UNIFAC-GE-model";
        this.phaseArray[0] = new PhaseSrkEos();
        this.phaseArray[0].setTemperature(T);
        this.phaseArray[0].setPressure(P);
        for (int i = 1; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseGEUnifacPSRK();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
    }

    public SystemUNIFACpsrk(double T, double P, boolean solidCheck) {
        this(T, P);
        this.attractiveTermNumber = 0;
        this.setNumberOfPhases(4);
        this.modelName = "UNIFAC-GE-model";
        this.solidPhaseCheck = solidCheck;
        this.phaseArray[0] = new PhaseSrkEos();
        this.phaseArray[0].setTemperature(T);
        this.phaseArray[0].setPressure(P);
        for (int i = 1; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseGEUnifacPSRK();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        if (this.solidPhaseCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
    }

    @Override
    public SystemUNIFACpsrk clone() {
        SystemUNIFACpsrk clonedSystem = null;
        try {
            clonedSystem = (SystemUNIFACpsrk)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return clonedSystem;
    }
}

